/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef XECONFIGURATION_H
#define XECONFIGURATION_H

#include <qobject.h>

#include <qstring.h>
#include <qstringlist.h>
#include <qimage.h>
#include <qxml.h>
#include <qdom.h>

#include <kxdocker_setup_sources.h>

#define KXDOCKERVERSION		"0.0.26"
#define KXDOCKERNEED		"0.0.8"


const int MAX_STRING_NAME 	= 50;
//const int MAX_FILE_LENGTH 	= 1024;
const int MAX_ICONS		= 50;


struct XSGObject
{
	QString className;
	QString fileName;
	QString Name;
	QString Group;
};
struct XSGObjectIconImages
{
	QString imgFileName;
	QString imgFileArrow;
	
};

struct XSGObjectIconActions
{
	QString onClickExec;
	QDomNodeList		ActionList;
};

struct XSCfgTasks
{
	void 		*TaskInfo;
	int		ShowThumbnail;
	QImage		Thumbnail;
	QStringList	WindowTitle;
	QStringList	TaskName;
	QStringList	ClassName;
	QPtrList<QObject> Proces;
	class KPopupMenu	*PopupMenu;
};

struct XSGObjectIcon
{
	XSGObject		Info;
	XSGObjectIconImages	Images;
	XSGObjectIconActions	Actions;
	XSCfgTasks		Tasks;
	QString			OverText;
	QDomNodeList		PluginConfiguration;
	//QImage			Poof;
	QString			PoofName;
	class KPopupMenu	*PluginPopupMenu;
};
struct XSCfgMatchIcons
{
	QString				SystemName;
	XSGObjectIcon			*Icon;
};
struct XSGObjectPlugin
{
	XSGObject			Info;
	QDomNodeList			xmlConfiguration;
};
struct XSCfgPlugins
{
	QPtrList<XSCfgMatchIcons> 	Matches;
	QStringList			PluginsPaths;
	QPtrList<XSGObjectPlugin>	Plugin;
};
struct XSCfgIcons
{
	int Size;
	int SizeBig;
	int Raise;
	int Separation;
	int Horiz;
	int EnableThumbnail;
	
	int FontRed;
	int FontGreen;
	int FontBlue;
	QString FontFamily;
	int	FontSize;
	
};

struct XSGCfgBackground
{
	QString			imgBackgroundCenter;
	QString			imgBackgroundLeft;
	QString			imgBackgroundRight;
	QString			imgBackgroundOver;
	int			Tiled;
	QString			imgBackgroundSeparator;
};
struct XSCfgTheme
{
	XSGObject		Info;
	QString			BackgroundPath;
	XSGCfgBackground	Background;
	QString			ArrowsPath;
	QString			PillowPath;
	QString			PoofPath;
	QImage			Poof;
	QStringList		IconsPaths;
	QPixmap			DefaultIcon;
};

struct XSCfgWindow
{
	int borderLeft;
	int borderTop;
	int Width;
	int Height;
	int Top;
	int Left;
	//char Align[MAX_STRING_NAME];
	QString Align;
	int HeightDesktop;
	int LeftForce;
	int TopForce;
	
	int HideTimeout;
	int HideMouseEdge;
	
	int SendToForgroundTimeout;
	int RaiseOnEvents;
	
	int SendToBackground;
	
	int HideMouseCornerLeft;
	int HideMouseCornerRight;
};

struct XSDesignMatrix
{
	// number of elements
	int sizeMatrix;
	// 2d X Axis displace on mouse over
	int *XMatrix;
	// 2d Y Axis displace on mouse over
	int *YMatrix;
	// 2d Zoom on mouse over
	int *ZMatrix;
	// 3d Dinamic Axis displace on mouse over
	int **DMatrix;
	// 2d X+ Axis displace on mouse over
	int *KMatrix;

	int DesignDMoltiplier;
	int DesignYMoltiplier;
	int DesignXMoltiplier;
	
	QString Design;
};

struct XSEngine
{
	int SmoothTimeout;
	//char XMLConf[512];
	QString XMLConf;
	int SleepFPS;
	//int IconsShowed;
	int SleepThreads;
	int SleepAnimations;
	int MaxIconsShowed;
//	int StaticIconsShowed;
	int AndZoomCache;
#ifdef ENABLE_SPECIALENGINE2
	int InterpolationValue;
#endif
};

struct XSConfigurations
{
	QString		Version;
	XSCfgIcons	Icons;
	XSCfgWindow	Window;
	XSDesignMatrix	Matrix;
	XSEngine	Engine;
	//XSGObjectIcon	ObjectsIcon[MAX_ICONS];
	QPtrList<XSGObjectIcon> ObjectsIcons;
	QPtrList<XSGObjectIcon> RollingIcons;
	XSCfgTheme	Theme;
	XSCfgPlugins	Plugins;
	
	QStringList	ConfigurationsPaths;
};



/**
@author Stefano
*/
class XEConfiguration : public QObject
{
Q_OBJECT
public:
    XEConfiguration(QObject *parent = 0, const char *name = 0);

    ~XEConfiguration();
    XSConfigurations * xGetConfiguration();

public slots:
    void xReset();
    void xCfgDefault();
    void xSetup();
    void iconRemove(int);
    void xLoadModules();
    void xLoadModule(const QString moduleName);
    void pluginRemove(const QString);
    void pluginAdd(const QString);
protected:
    XSConfigurations ActiveConfiguration;
signals:
    void xCfgChanged(QObject *);
};

#endif
