// =============================================================================
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviScriptListView"

#include "kvi_script_listview.h"
#include "kvi_script_treeview_item.h"

KviScriptListViewItem::KviScriptListViewItem(
	KviScriptTreeViewItem *it, KviListView *par, QString &l1, QString &l2, QString &l3, QString &l4)
	: KviListViewItem(par, l1, l2, l3, l4)
	, m_pScriptObjectClass(it)
{
	// Nothing here
}

KviScriptListViewItem::KviScriptListViewItem(
	KviScriptTreeViewItem *it, KviScriptListViewItem *par, QString &l1, QString &l2, QString &l3, QString &l4)
	: KviListViewItem(par, l1, l2, l3, l4)
	, m_pScriptObjectClass(it)
{
	// Nothing here
}

KviScriptListViewItem::~KviScriptListViewItem()
{
	if( m_pScriptObjectClass->m_pItem ) {
		// Someone else deleted us!
		m_pScriptObjectClass->m_pItem = 0;
		m_pScriptObjectClass->die(false);
	}
}
