#ifndef _KVI_SCRIPT_CENTER_H_INCLUDED_
#define _KVI_SCRIPT_CENTER_H_INCLUDED_

// =============================================================================
//
//      --- kvi_script_center.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//   Copyright (C) 1999-2000 Till Busch (buti@geocities.com)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include "kvi_tabdialog.h"

class KviAliasEditor;
class KviCodeTester;
class KviEventEditor;
class KviHelpWindow;
class KviObjectViewer;
class KviPopupEditor;
class KviRawEventEditor;
class KviUserToolBarEditor;
class KviVariablesEditor;

class KviScriptCenter : public KviTabDialog
{
	Q_OBJECT
public:
	KviScriptCenter(QWidget *parent = 0);
	~KviScriptCenter();
protected:
	KviAliasEditor       *m_pAliasEditor;
	KviRawEventEditor    *m_pRawEventEditor;
	KviEventEditor       *m_pHiLevelEventEditor;
	KviPopupEditor       *m_pThePopupEditor;
	KviUserToolBarEditor *m_pUserToolBarEditor;
	KviVariablesEditor   *m_pVariablesEditor;
	KviObjectViewer      *m_pObjectViewer;
	KviCodeTester        *m_pCodeTester;
	KviHelpWindow        *m_pHelpWindow;

	virtual void closeEvent(QCloseEvent *);
#ifndef COMPILE_WITH_KDE
	virtual void keyPressEvent(QKeyEvent *e);
#endif
signals:
	void closed();
protected slots:
	void acceptClicked();
	void rejectClicked();
	void applyClicked();
};

#endif // _KVI_SCRIPT_CENTER_H_INCLUDED_
