#ifndef _KVI_SCRIPT_BUTTON_H_INCLUDED_
#define _KVI_SCRIPT_BUTTON_H_INCLUDED_

// =============================================================================
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include "kvi_script_widget.h"

class KviScriptButton : public KviScriptWidget
{
	Q_OBJECT
public:
	KviScriptButton(KviScriptObjectController *, KviScriptObject *, const char *name, KviScriptObjectClassDefinition *);
	~KviScriptButton();
public:
	virtual bool init(QPtrList<KviStr> *params);
	static void initializeClassDefinition(KviScriptObjectClassDefinition *);

	int    builtinFunction_TEXT(QPtrList<KviStr> *params, KviStr &buffer);
	int builtinFunction_SETTEXT(QPtrList<KviStr> *params, KviStr &buffer);
protected slots:
	void buttonClicked();
};

#endif // _KVI_SCRIPT_BUTTON_H_INCLUDED_
