// =============================================================================
//
//      --- kvi_usertoolbutton.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//   Copyright (C) 1999-2000 Till Busch (buti@geocities.com)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviUserToolButton"

#include "kvi_usertoolbutton.h"

KviUserToolButton::KviUserToolButton(
	int id, const QPixmap &pm, const char *textLabel, const char *grouptext,
	QObject *receiver, const char *slot, KviToolBar *parent)
	: KviToolBarButton(pm, textLabel, grouptext, receiver, slot, parent, textLabel)
{
	m_BtnId = id;
	disconnect(this, SIGNAL(clicked()), this, slot);
	connect(this, SIGNAL(clicked()), this, SLOT(wasClicked()));
}

KviUserToolButton::~KviUserToolButton()
{
	disconnect(this, SIGNAL(clicked()));
}

void KviUserToolButton::wasClicked()
{
	emit idClicked(m_BtnId);
}

#include "m_kvi_usertoolbutton.moc"
