#ifndef _KVI_NUMERIC_H_INCLUDED_
#define _KVI_NUMERIC_H_INCLUDED_

// =============================================================================
//
//      --- kvi_numeric.h ---
//
//   Revisited by Szymon Stefanek 07 Jul 1998 (stefanek@tin.it)
//   Re-revisited again on 11 Feb 1999 (stefanek@tin.it)
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1990 Jarkko Oikarinen
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 1
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

/**
 * We will need 4 digit replies for the new IRC protocol
 * and then leave 50-100 numbers between logical groups...
 */

/**
 * ==============================================================================================
 *
 * E = EFnet hybrid 5.3p2
 * e = EFNet hybrid 5.3p2 with #ifdef
 * I = IRCnet 2.10.0p5
 * i = IRCnet, reserved according to Undernet (sic) numerics header
 * U = Undernet u2.10.04
 * u = Undernet u2.10.04 with #ifdef
 * D = DALnet 4.6.7.DF
 * d = DALnet 4.6.7.DF, redundant
 */

/**
 * = 0-199 ====================================================================================
 *
 * Reserve numerics 0-99 for server-client connections where the client
 * is local to the server. If any server is passed a numeric in this range
 * from another server then it is remapped to 100-199. -avalon
 */
#define RPL_WELCOME          1  // :Welcome to the Internet Relay Network %s             [I, E, U, D]
#define RPL_YOURHOST         2  // :Your host is %s, running version %s                  [I, E, U, D]
#define RPL_CREATED          3  // :This server was created %s                           [I, E, U, D]
#define RPL_MYINFO           4  // <server_name> <srv_version> <u_modes> <ch_modes>      [I, E, U, D]
#define RPL_BOUNCE           5  // :Try server %s, port %d                               [I]
#define RPL_PROTOCTL         5  // %s :are available on this server                      [D]
#define RPL_MAP              5  // :%s%s                                                 [U]
#define RPL_MAPMORE          6  // :%s%s --> *more*                                      [U]
#define RPL_MAPEND           7  // :End of /MAP                                          [U]
#define RPL_SNOMASK          8  // %d :: Server notice mask (%#x)                        [U]
#define RPL_STATMEMTOT       9  // %u %u :Bytes Blocks                                   [U]
#define RPL_STATMEM          10 // %u %u %s                                              [U]
// TODO: RPL_????????        11, 12, 13
#define RPL_YOURCOOKIE       14 // <cookie> :is your reconnection cookie                 [E, i?]

/**
 * = 200-399 ====================================================================================
 *
 * Command replies
 */
#define RPL_TRACELINK        200 // "Link <version> <destination> <next server> <next-server-TS-version><zflag> <link-time> <sendQ> <prev-server-sendQ>" [I, E, U, D]
#define RPL_TRACECONNECTING  201 // "Try. %d %s"                                         [I, E, U, D]
#define RPL_TRACEHANDSHAKE   202 // "H.S. %d %s"                                         [I, E, U, D]
#define RPL_TRACEUNKNOWN     203 // "???? %d %s %d"                                      [I, E, U, D]
#define RPL_TRACEOPERATOR    204 // "Oper %d %s"                                         [I, E, U, D]
#define RPL_TRACEUSER        205 // "User %d %s"                                         [I, E, U, D]
#define RPL_TRACESERVER      206 // "Serv <class> <int>S <int>C <server> <nick!user|*!*>@<host|server> <TS-version><zflag>" [I, E, U, D]
#define RPL_TRACENEWTYPE     208 // "<newtype> 0 %s"                                     [I, E, U, D]
#define RPL_TRACECLASS       209 // "Class %d %d"                                        [I, E, U, D]
#define RPL_TRACERECONNECT   210 // "???"                                                [I]
#define RPL_STATSLINKINFO    211 //                                                      [I, E, U, D]
#define RPL_STATSCOMMANDS    212 // "%s %u %u"                                           [I, E, U, D]
#define RPL_STATSCLINE       213 // "%c %s * %s %d %d"                                   [I, E, U, D]
#define RPL_STATSNLINE       214 // "%c %s * %s %d %d"                                   [I, E, U, D]
#define RPL_STATSILINE       215 // "%c %s * %s %d %d"                                   [I, E, U, D]
#define RPL_STATSKLINE       216 //                                                      [I, E, U, D]
#define RPL_STATSPLINE       217 //                                                      [U]
#define RPL_STATSQLINE       217 //                                                      [I, E, U, D]
#define RPL_STATSYLINE       218 //                                                      [I, E, U, D]
#define RPL_ENDOFSTATS       219 //                                                      [I, E, U, D]
// TODO: RPL_??????????      220
#define RPL_UMODEIS          221 //                                                      [I, E, U, D]
#define RPL_STATSBLINE       222 //                                                      [E]
#define RPL_SQLINE_NICK      222 //                                                      [D]
#define RPL_STATSELINE       223 //                                                      [E]
#define RPL_STATSFLINE       224 //                                                      [E]
#define RPL_STATSDLINE       225 //                                                      [E]
// TODO: RPL_??????????      226-230
#define RPL_SERVICEINFO      231 //                                                      [I, U, D]
#define RPL_ENDOFSERVICES    232 //                                                      [I, U, D]
#define RPL_SERVICE          233 //                                                      [I, U, D]
#define RPL_SERVLIST         234 //                                                      [I, E, U, D]
#define RPL_SERVLISTEND      235 //                                                      [I, E, U, D]
// TODO: RPL_??????????      236-238
#define RPL_STATSIAUTH       239 //                                                      [I]
#define RPL_STATSVLINE       240 //                                                      [I]
#define RPL_STATSLLINE       241 //                                                      [I, E, U, D]
#define RPL_STATSUPTIME      242 //                                                      [I, E, U, D]
#define RPL_STATSOLINE       243 //                                                      [I, E, U, D]
#define RPL_STATSHLINE       244 //                                                      [I, E, U, D]
#define RPL_STATSSLINE       245 //                                                      [I, E, u, D]
#define RPL_STATSPING        246 //                                                      [I]
#define RPL_STATSTLINE       246 //                                                      [U]
#define RPL_STATSBLINE_I     247 //                                                      [I]
#define RPL_STATSGLINE       247 //                                                      [U]
#define RPL_STATSXLINE       247 //                                                      [D]
#define RPL_STATSDEFINE      248 //                                                      [I]
#define RPL_STATSULINE       248 //                                                      [U, D]
#define RPL_STATSDEBUG       249 //                                                      [I, E, U, D]
#define RPL_STATSCONN        250 //                                                      [e, U, D]
#define RPL_STATSDLINE_I     250 //                                                      [I]
#define RPL_LUSERCLIENT      251 // ":There are %d users and %d invisible on %d servers" [I, E, U, D]
#define RPL_LUSEROP          252 // "%d :IRC Operators online"                           [I, E, U, D]
#define RPL_LUSERUNKNOWN     253 // "%d :unknown connection(s)"                          [I, E, U, D]
#define RPL_LUSERCHANNELS    254 // "%d :channels formed"                                [I, E, U, D]
#define RPL_LUSERME          255 // ":I have %d clients and %d servers"                  [I, E, U, D]
#define RPL_ADMINME          256 // ":Administrative info about %s"                      [I, E, U, D]
#define RPL_ADMINLOC1        257 // ":%s"                                                [I, E, U, D]
#define RPL_ADMINLOC2        258 // ":%s"                                                [I, E, U, D]
#define RPL_ADMINEMAIL       259 // ":%s"                                                [I, E, U, D]
// TODO: RPL_?????????       260
#define RPL_TRACELOG         261 //                                                      [I, E, U, D]
#define RPL_TRACEEND         262 //                                                      [I, E]
#define RPL_TRACEPING        262 //                                                      [U]
#define RPL_TRYAGAIN         263 // "[14:28:51] [ircd.tin.it][263] [newbie] LINKS :Please wait a while and try again." [I]
#define RPL_LOAD2HI          263 // ":Server load is temporarily too heavy. Please wait a while and try again."        [E]
// TODO: RPL_???????         264
#define RPL_LOCALUSERS       265 // ":Current local users: %d Max: %s"                   [e, D]
#define RPL_GLOBALUSERS      266 // ":Current global users: %d Max: %d"                  [e, D]
// TODO: RPL_???????         267-270
#define RPL_SILELIST         271 //                                                      [U, D]
#define RPL_ENDOFSILELIST    272 //                                                      [U, D]
#define RPL_STATSDELTA       274 // "<timedelta>"                                        [i, E]
#define RPL_STATSDLINE_U     275 //                                                      [U, D]
// TODO: RPL_???????         276-279
#define RPL_GLIST            280 //                                                      [U]
#define RPL_ENDOFGLIST       281 //                                                      [U]
// TODO: RPL_???????         282-289
#define RPL_HELPHDR          290 //                                                      [D]
#define RPL_HELPOP           291 //                                                      [D]
#define RPL_HELPTLR          292 //                                                      [D]
#define RPL_HELPHLP          293 //                                                      [D]
#define RPL_HELPFWD          294 //                                                      [D]
#define RPL_HELPIGN          295 //                                                      [D]
// TODO: RPL_???????         296-299
#define RPL_NONE             300 //                                                      [I, E, U, D]
#define RPL_AWAY             301 // "%s :%s"                                             [I, E, U, D]
#define RPL_USERHOST         302 // ":up to 5 userhost replies"                          [I, E, U, D]
#define RPL_ISON             303 // ":<list of present nicks>"                           [I, E, U, D]
#define RPL_TEXT             304 //                                                      [I, E, U, D]
#define RPL_UNAWAY           305 //                                                      [I, E, U, D]
#define RPL_NOWAWAY          306 //                                                      [I, E, U, D]
#define RPL_WHOISREGNICK     307 // "???"                                                [D]
#define RPL_WHOISADMIN       308 // "???"                                                [d]
#define RPL_WHOISSADMIN      309 // "???"                                                [d]
#define RPL_WHOISHELPOP      310 // "???"                                                [D]

#define RPL_WHOISUSER        311 // "%s %s %s * :%s"                                     [I, E, U, D]
#define RPL_WHOISSERVER      312 // "%s %s :%s"                                          [I, E, U, D]
#define RPL_WHOISOPERATOR    313 // "%s :is an IRC Operator"                             [I, E, U, D]
#define RPL_WHOWASUSER       314 // "%s %s %s * :%s"                                     [I, E, U, D]
#define RPL_ENDOFWHO         315 // "<channel> :End of /WHO list."                       [I, E, U, D]
#define RPL_WHOISCHANOP      316 // "???"                                                [I, E, D]
#define RPL_WHOISIDLE        317 // "%s %ld %ld :seconds idle, signon time"              [I, E, U, D]
#define RPL_ENDOFWHOIS       318 // "%s :End of /WHOIS list."                            [I, E, U, D]
#define RPL_WHOISCHANNELS    319 // "%s :%s"                                             [I, E, U, D]
// TODO: RPL_?????????????   320
#define RPL_LISTSTART        321 // "Channel :Users Name"                                [I, E, U, D]
#define RPL_LIST             322 // "<channel> <users> :<topic>"                         [I, E, U, D]
#define RPL_LISTEND          323 // ":End of /LIST"                                      [I, E, U, D]
#define RPL_CHANNELMODEIS    324 // "<channel> +<mode>"                                  [I, E, U, D]
#define RPL_CHANNELPASSIS    325 // "<channel> <password>"                               [i]
#define RPL_NOCHANPASS       326 // "<channel> :No channel password"                     [i]
#define RPL_CHPASSUNKNOWN    327 //                                                      [i]
#define RPL_CHANURL          328 // "[services.dal.net][328] Pragma #linux :http://dalnet.linuxguru.net" [D]
#define RPL_CREATIONTIME     329 // "<channel> %lu"                                      [E, U, D]
// TODO: RPL_?????????????   330
#define RPL_NOTOPIC          331 // "<channel> :No topic is set."                        [I, E, U, D]
#define RPL_TOPIC            332 // "<channel> :%s"                                      [I, E, U, D]
#define RPL_TOPICWHOTIME     333 // "<channel> <whoset> %lu"                             [e, U, D]
#define RPL_LISTUSAGE        334 //                                                      [U]
#define RPL_LISTSYNTAX       335 //                                                      [D]
// TODO: RPL_??????????      336-337
#define RPL_CHANPASSOK       338 // "<channel> :Channel password OK"                     [i]
#define RPL_BADCHANPASS      339 // "<channel> :Invalid channel password"                [i]
// TODO: RPL_??????????      340
#define RPL_INVITING         341 //                                                      [I, E, U, D]
#define RPL_SUMMONING        342 //                                                      [I, E, D]
// TODO: RPL_?????????       343-345
#define RPL_INVITELIST       346 // "<channel> <exceptionmask>"                          [I]
#define RPL_ENDOFINVITELIST  347 // "<channel> :End of Channel Invite List"              [I]
#define RPL_EXCEPTLIST       348 // "<channel> <exceptionmask>"                          [I]
#define RPL_ENDOFEXCEPTLIST  349 // "<channel> :End of Channel Exception List"           [I]
// TODO: RPL_??????????      350
#define RPL_VERSION          351 // "%s.%s %s :%s"                                       [I, E, U, D]
#define RPL_WHOREPLY         352 // "<chn> <usr> <hst> <srv> <nck> <stat>:<hops> <real>" [I, E, U, D]
#define RPL_NAMREPLY         353 // "= <channel> :<space_separated_list_of_nicks>"       [I, E, U, D]
#define RPL_WHOSPCRPL        354 //                                                      [U]
// TODO: RPL_?????????       355-360
#define RPL_KILLDONE         361 //                                                      [I, E, U, D]
#define RPL_CLOSING          362 //                                                      [I, E, U, D]
#define RPL_CLOSEEND         363 //                                                      [I, E, U, D]
#define RPL_LINKS            364 // "<host> <parent> :<hops> <description>"              [I, E, U, D]
#define RPL_ENDOFLINKS       365 // "%s :End of /LINKS"                                  [I, E, U, D]
#define RPL_ENDOFNAMES       366 // "%s :End of /NAMES list."                            [I, E, U, D]
#define RPL_BANLIST          367 // "<channel> <banmask>"                                [I, E, U, D]
#define RPL_ENDOFBANLIST     368 // "<channel> :End of channel Ban List"                 [I, E, U, D]
#define RPL_ENDOFWHOWAS      369 // "%s :END of /WHOWAS"                                 [I, E, U, D]
#define RPL_INFO             371 // ":%s"                                                [I, E, U, D]
#define RPL_MOTD             372 // ":- %s"                                              [I, E, U, D]
#define RPL_INFOSTART        373 // ":Server INFO"                                       [I, E, U, D]
#define RPL_ENDOFINFO        374 // ":End of /INFO list."                                [I, E, U, D]
#define RPL_MOTDSTART        375 // ":- %s Message of the Day - "                        [I, E, U, D]
#define RPL_ENDOFMOTD        376 // ":End of /MOTD command."                             [I, E, U, D]
#define RPL_MOTD2            377 // ":- %s"                                              [?]
// TODO: RPL_?????????       378-380
#define RPL_YOUREOPER        381 //                                                      [I, E, U, D]
#define RPL_REHASHING        382 //                                                      [I, E, U, D]
#define RPL_YOURESERVICE     383 //                                                      [I, D]
#define RPL_MYPORTIS         384 //                                                      [I, E, U, D]
#define RPL_NOTOPERANYMORE   385 //                                                      [I, E, U, D]
// TODO: RPL_?????????       386-390
#define RPL_TIME             391 //                                                      [I, E, U, D]
#define RPL_USERSSTART       392 //                                                      [I, E, D]
#define RPL_USERS            393 //                                                      [I, E, D]
#define RPL_ENDOFUSERS       394 //                                                      [I, E, D]
#define RPL_NOUSERS          395 //                                                      [I, E, D]
// TODO: RPL_?????????       396-399

/**
 * = 400-599 ====================================================================================
 *
 * Errors are in the range from 400-599 currently and are grouped by what
 * commands they come from.
 */
// TODO: ERR_?????????       400
#define ERR_NOSUCHNICK       401 // "%s :No such nick/channel"                           [I, E, U, D]
#define ERR_NOSUCHSERVER     402 // "%s :No such server"                                 [I, E, U, D]
#define ERR_NOSUCHCHANNEL    403 // "%s :No such channel"                                [I, E, U, D]
#define ERR_CANNOTSENDTOCHAN 404 // "%s :Cannot send to channel"                         [I, E, U, D]
#define ERR_TOOMANYCHANNELS  405 // "%s :You have joined too many channels"              [I, E, U, D]
#define ERR_WASNOSUCHNICK    406 // "%s :There was no such nickname"                     [I, E, U, D]
#define ERR_TOOMANYTARGETS   407 // "%s :Duplicate recipients. No message delivered"     [I, E, U, D]
#define ERR_NOSUCHSERVICE    408 // "%s :No such service"                                [I, D]
#define ERR_NOORIGIN         409 // ":No origin specified"                               [I, E, U, D]
// TODO: ERR_??????????      410
#define ERR_NORECIPIENT      411 // ":No recipient given (%s)"                           [I, E, U, D]
#define ERR_NOTEXTTOSEND     412 // ":No text to send"                                   [I, E, U, D]
#define ERR_NOTOPLEVEL       413 // "%s :No toplevel domain specified"                   [I, E, U, D]
#define ERR_WILDTOPLEVEL     414 // "%s :Wildcard in toplevel Domain"                    [I, E, U, D]
#define ERR_BADMASK          415 // "???"                                                [I]
#define ERR_QUERYTOOLONG     416 // "???"                                                [U]
// TODO: ERR_??????????      417-420
#define ERR_UNKNOWNCOMMAND   421 // "%s :Unknown command"                                [I, E, U, D]
#define ERR_NOMOTD           422 // ":MOTD File is missing"                              [I, E, U, D]
#define ERR_NOADMININFO      423 // "%s :No administrative info available"               [I, E, U, D]
#define ERR_FILEERROR        424 // ":File error doing %s on %s"                         [I, E, U, D]
// TODO: ERR_??????????      425-430
#define ERR_NONICKNAMEGIVEN  431 // ":No nickname given"                                 [I, E, U, D]
#define ERR_ERRONEUSNICKNAME 432 // "%s :Erroneous nickname"                             [I, E, U, D]
#define ERR_NICKNAMEINUSE    433 // "%s :Nickname is already in use."                    [I, E, U, D]
#define ERR_SERVICENAMEINUSE 434 // "???"                                                [I, D]
#define ERR_SERVICECONFUSED  435 // "???"                                                [I, D]
#define ERR_NICKCOLLISION    436 // "%s :Nickname collision KILL"                        [I, E, U, D]
#define ERR_UNAVAILRESOURCE  437 // "???"                                                [I]
#define ERR_NICKTOOFAST      438 // "???"                                                [U]
#define ERR_TARGETTOOFAST    439 // "???"                                                [U, D]
#define ERR_SERVICESDOWN     440 // "???"                                                [D]
#define ERR_USERNOTINCHANNEL 441 // "%s %s :They are not on that channel"                [I, E, U, D]
#define ERR_NOTONCHANNEL     442 // "%s :You are not on that channel"                    [I, E, U, D]
#define ERR_USERONCHANNEL    443 // "%s %s :is already on channel"                       [I, E, U, D]
#define ERR_NOLOGIN          444 // "%s :User not logged in"                             [I, E, U, D]
#define ERR_SUMMONDISABLED   445 // ":SUMMON has been removed/disabled"                  [I, E, U, D]
#define ERR_USERSDISABLED    446 // ":USERS has been removed/disabled"                   [I, E, U, D]
// TODO: ERR_??????????      447-450
#define ERR_NOTREGISTERED    451 // ":You have not registered"                           [I, E, U, D]
#define ERR_IDCOLLISION      452 // ":ID collision KILL"                                 [i, ?]
#define ERR_NICKLOST         453 // "<nick>:Nickname collision; please enter a new nick" [i, ?]
// TODO: ERR_??????????      454
#define ERR_HOSTILENAME      455 // "???"                                                [D]
// TODO: ERR_??????????      456-460
#define ERR_NEEDMOREPARAMS   461 // "%s :Not enough parameters"                          [I, E, U, D]
#define ERR_ALREADYREGISTRED 462 // ":You may not reregister"                            [I, E, U, D]
#define ERR_NOPERMFORHOST    463 // ":Your host is not among the privileged"             [I, E, U, D]
#define ERR_PASSWDMISMATCH   464 // ":Password Incorrect"                                [I, E, U, D]
#define ERR_YOUREBANNEDCREEP 465 // ":You are banned from this server- %s"               [I, E, U, D]
#define ERR_YOUWILLBEBANNED  466 // "???"                                                [I, E, U, D]
#define ERR_KEYSET           467 // "%s:Channel key already set"                         [I, E, U, D]
#define ERR_INVALIDUSERNAME  468 // "???"                                                [U, ?]
// TODO: ERR_???????????     469-470
#define ERR_CHANNELISFULL    471 // "%s :Cannot join channel (+l)"                       [I, E, U, D]
#define ERR_UNKNOWNMODE      472 // "%c :is unknown mode char to me"                     [I, E, U, D]
#define ERR_INVITEONLYCHAN   473 // "%s :Cannot join channel (+i)"                       [I, E, U, D]
#define ERR_BANNEDFROMCHAN   474 // "%s :Cannot join channel (+b)"                       [I, E, U, D]
#define ERR_BADCHANNELKEY    475 // "%s :Cannot join channel (+k)"                       [I, E, U, D]
#define ERR_BADCHANMASK      476 // "%s :Bad Channel Mask"                               [I, E, U, D]
#define ERR_MODELESS         477 // "???"                                                [U]
#define ERR_NEEDREGGEDNICK   477 // "???"                                                [U]
#define ERR_BANLISTFULL      478 // "???"                                                [U, D]
// TODO: ERR_???????????     479-480
#define ERR_NOPRIVILEGES     481 // ":Permission Denied- You are not an IRC operator"    [I, E, U, D]
#define ERR_CHANOPRIVSNEEDED 482 // "%s :You are not channel operator"                   [I, E, U, D]
#define ERR_CANNOTKILLSERVER 483 // ":You cannot kill a server!"                         [E, U, D]
#define ERR_DESYNC           484 // "???"                                                [E]
#define ERR_ISCHANSERVICE    484 // "???"                                                [U]
#define ERR_CHANTOORECENT    487 // "<channel> :Channel created too recently"            [i]
#define ERR_TSLESSCHAN       488 // "<channel> :Mode <mode> not available on TS-less channel" [i]
// TODO: ERR_???????????     489-490
#define ERR_NOOPERHOST       491 // ":Only few of mere mortals may try to enter the twilight zone" [I, E, U, D]
#define ERR_NOSERVICEHOST    492 // "???"                                                [I, D]
// TODO: ERR_???????????     493-500
#define ERR_UMODEUNKNOWNFLAG 501 // ":Unknown MODE flag"                                 [I, E, U, D]
#define ERR_USERSDONOTMATCH  502 // ":Cannot change mode for other users"                [I, E, U, D]
#define ERR_GHOSTEDCLIENT    503 // ":Message could not be delivered to %s"              [E]
#define ERR_LAST_ERR_MSG     504 // ":Last Error Message"                                [E]
// TODO: ERR_???????????     505-510
#define ERR_SILELISTFULL     511 // "???"                                                [U, D]
#define ERR_NOSUCHGLINE      512 // "???"                                                [U]
#define ERR_TOOMANYWATCH     513 // "???"                                                [D]
#define ERR_BADPING          514 // "???"                                                [U]
#define ERR_NEEDPONG         515 // "???"                                                [D]
#define ERR_LISTSYNTAX       516 // "???"                                                [D]
/** DalNet (excellent) extension that substitutes the ISON ping */
#define RPL_LOGON            600 // "<nick> <user> <host> <logintime> :logged online"    [D]
#define RPL_LOGOFF           601 // "<nick> <user> <host> <logintime> :logged offline"   [D]
#define RPL_WATCHOFF         602 // "<nick> <user> <host> <logintime> :stopped watching" [D]
#define RPL_WATCHSTAT        603 // ":You have <n> and are on <n> WATCH entries"         [D]
#define RPL_NOWON            604 // "<nick> <user> <host> <logintime> :is online"        [D]
#define RPL_NOWOFF           605 // "<nick> <user> <host> 0 :is offline"                 [D]
#define RPL_WATCHLIST        606 // "???"                                                [D]
#define RPL_ENDOFWATCH       607 // ":End of WATCH <char l=list s=stats>"                [D]

#endif // _KVI_NUMERIC_H_INCLUDED_
