#ifndef _KVI_MASKEDITOR_H_INCLUDED_
#define _KVI_MASKEDITOR_H_INCLUDED_

// =============================================================================
//
//      --- kvi_maskeditor.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qframe.h>

#include "kvi_string.h"

class KviBanMask;
class KviLabel;
class KviListView;
class KviPushButton;

class KviMaskEditor : public QFrame
{
	Q_OBJECT
public:
	KviMaskEditor(QWidget *parent);
	~KviMaskEditor();
protected:
	KviListView   *m_pMaskBox;
	KviPushButton *m_pRemoveMask;
	KviPushButton *m_pCommit;
	KviLabel      *m_pLabel;
	KviStr         m_szMasksRemoved;
public:
	void doEdit(
		QObject *receiver, const char *slot, QPtrList<KviBanMask> *maskList, const char *masksLabel, bool bCanCommit
	);
	void setCanCommit(bool bCanCommit);
protected:
	void setMasks(QPtrList<KviBanMask> *maskList, const char *masksLabel);
protected slots:
	void commitChanges();
	void cancelClicked();
	void removeMaskClicked();
signals:
	void masksEditCompleted(const char *bansToRemove);
};

#endif // _KVI_MASKEDITOR_H_INCLUDED_
