#ifndef _KVI_COMMAND_H_INCLUDED_
#define _KVI_COMMAND_H_INCLUDED_

// =============================================================================
//
//      --- kvi_command.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qptrlist.h>

#include "kvi_string.h"

class KviScriptObject;
class KviUserParser;
class KviVariableCache;
class KviWindow;

#define KVI_COMMAND_FLAG_RECOGNIZE_OBJECT_SCOPE_OPERATOR 1
#define KVI_COMMAND_FLAG_BREAK_PENDING                   2

#define KVI_GLOBAL_VAR_CHAR    '%'
#define KVI_COMMENT_BEGIN_CHAR '#'

class KviCommand
{
public:
	KviCommand(const char *pBuf, KviWindow *pWnd);
	~KviCommand();
public:
	const char       *m_ptr;
	KviWindow        *m_wnd;

	int               m_err;
	KviStr            m_szErrorToken;
	KviStr            m_szErrorLocation;

	KviStr            m_buffer;
	KviStr            m_retBuffer;

	KviVariableCache *m_pLocalVarCache;
private:
	KviScriptObject  *m_pScopeObject;
	QPtrList<KviStr> *m_pParamList;

	KviStr            m_szThisId;
	int               m_flags;
public:
	bool hasError();
	void skipWhitespace();
	void setThisId(const char *);

	const char *thisId();

	bool hasThisId();
	// ALWAYS returns false
	bool setError(int iError, const char *szLocation, const char *szErrToken = 0);
	void clearBuffer();
	void skipSpace();
	bool hasParams();

	void setParams(const KviStr &param0, const char *paramBuffer);
	void setParams(const KviStr &param0, QPtrList<KviStr> *pList);

	bool setParamsFromCommand(const KviStr &param0, KviCommand *, KviUserParser *);
	void getParamCount(KviStr &buffer);
	void getSingleParam(int param, KviStr &buffer);
	void getParam(int fromParam, int toParam, KviStr &buffer);
	// ALWAYS returns true
	bool warning(const char *format, ...);

	QPtrList<KviStr> *m_switchList;

	bool hasSwitch(char letter);
	bool getSwitchValue(char letter, KviStr &buffer);
	void clearSwitchList();
	void setReturnValue(const char *retBuffer);

	KviScriptObject *scopeObject();
	void setScopeObject(KviScriptObject *);
	void setRecognizeObjectScopeOperator(bool);
	bool recognizeObjectScopeOperator();

	void setBreakPending(bool bPending);
	bool breakPending();
};

inline bool KviCommand::hasParams()                        { return m_pParamList != 0; };
inline void KviCommand::clearBuffer()                      { m_buffer = ""; }

inline void KviCommand::setThisId(const char *tid)         { m_szThisId = tid; };
inline const char *KviCommand::thisId()                    { return m_szThisId.ptr(); };

inline KviScriptObject *KviCommand::scopeObject()          { return m_pScopeObject; };
inline void KviCommand::setScopeObject(KviScriptObject *o) { m_pScopeObject = o; };

inline bool KviCommand::breakPending()                     { return (m_flags & KVI_COMMAND_FLAG_BREAK_PENDING); };

inline void KviCommand::clearSwitchList()
{
	while( m_switchList->first() )
		m_switchList->removeFirst();
}

inline void KviCommand::setRecognizeObjectScopeOperator(bool bRec)
{
	if( bRec )
		m_flags |= KVI_COMMAND_FLAG_RECOGNIZE_OBJECT_SCOPE_OPERATOR;
	else
		m_flags &= (~KVI_COMMAND_FLAG_RECOGNIZE_OBJECT_SCOPE_OPERATOR);
};

inline bool KviCommand::recognizeObjectScopeOperator()
{
	return (m_flags & KVI_COMMAND_FLAG_RECOGNIZE_OBJECT_SCOPE_OPERATOR);
};

inline void KviCommand::setBreakPending(bool bPending)
{
	if( bPending )
		m_flags |= KVI_COMMAND_FLAG_BREAK_PENDING;
	else
		m_flags &= (~KVI_COMMAND_FLAG_BREAK_PENDING);
};

#endif // _KVI_COMMAND_H_INCLUDED_
