/**vim: ts=4, wrap, tw=80
  *
  *		--- libkvibiffsystray.h ---
  *
  * Authors:
  * 	Krzysztof Godlewski <kristoff@poczta.wprost.pl>
  * 	Szymon Stefanek <stefanek@tin.it>
  * 
  * This program is FREE software. You can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your opinion) any later version.
  *
  * This program is distributed in the HOPE that it will be USEFUL,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  * See the GNU General Public License for more details.

  * You should have received a copy of the GNU General Public License
  * along with this program. If not, write to the Free Software Foundation,
  * Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
  **/
 
#ifndef _LIBKVIBIFFSYSTRAY_H_
#define _LIBKVIBIFFSYSTRAY_H_


#include "kvi_systray.h"

class KviBiffSocket;
class QPopupMenu;

class KviBiffWidget : public KviSysTrayWidget
{
	Q_OBJECT
	
public:
	KviBiffWidget(KviSysTray * parent,KviFrame * frm,const char *tooltip);
	~KviBiffWidget();

	KviFrame * frame();
	virtual QPixmap * icon();
// Show text pointed by 'txt' for 'time' ms. If perm == TRUE it is permanent
	void showText( const char *txt, uint time, bool perm );

private slots:
	void slotHide();
	void fillMailboxPopup();
	void showOrginalText();
	
protected:
	virtual void paintEvent( QPaintEvent * );
	virtual void timerEvent( QTimerEvent * );
	virtual void mousePressEvent( QMouseEvent * );

private:
	KviFrame	*	m_pFrm;
	QPopupMenu	*	m_popup;
	QPopupMenu	*	m_mBoxPopup;
	bool 			m_showingText;
	KviStr			m_textToShow;
	QTimer		*	m_pTextTimer;
};

inline KviFrame * KviBiffWidget::frame(){ return m_pFrm; };

#endif		// ! _LIBKVIBIFFSYSTRAY_H_
