//
//   File : kvi_input.h (/usr/build/NEW_kvirc/kvirc/kvirc/kvi_input.h)
//   Last major modification : Sun Jan 3 1999 23:04:10 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#ifndef _KVI_INPUT_H_INCLUDED_
#define _KVI_INPUT_H_INCLUDED_

#include <qwidget.h>
#include <qpixmap.h>
#include <qlist.h>

#include "kvi_string.h"

class KviIrcView;
class KviListBox;
class KviUserParser;
class KviWindow;

// Q_PROPERTY Trick:
//    We set a special property on the widgets that should keep their focus
//    when tab is pressed , and they want to process the tab.
//    the READ method is a dummy int function!

class KviInput : public QWidget
{
	friend class KviUserParser;
	Q_OBJECT
	Q_PROPERTY( int KviProperty_FocusOwner READ heightHint )
public:
	KviInput(KviWindow *parent,KviUserParser *pParser,KviListBox *listBox=0);
	~KviInput();
protected:
	KviStr   m_szTextBuffer;
	QPixmap *m_pMemBuffer;
	int      m_iCursorPosition;
	int      m_iFirstVisibleChar;
	int      m_iSelectionBegin;
	int      m_iSelectionEnd;
	char     m_iCurFore;
	char     m_iCurBack;
	bool     m_bCurBold;
	bool     m_bCurUnderline;
	int      m_iBlockLen;
	int      m_iBlockWidth;
	bool     m_bControlBlock;
	bool     m_bCursorOn;
	int      m_iCursorTimer;
	int      m_iDragTimer;
	int      m_iLastCursorXPosition;
	KviListBox *m_pListBoxToControl;
	int      m_iSelectionAnchorChar;
	QList<KviStr> *m_pHistory;
	int      m_iCurHistoryIdx;
	KviStr   m_szSaveTextBuffer;
	bool     m_bUpdatesEnabled;
	KviStr   m_szAltKeyCode;
	KviUserParser *m_pUserParser;
	KviWindow *m_pParent;
	KviStr   m_szLastCompletionBuffer;
	int      m_iLastCompletionIndex;
	int      m_iLastCompletionCursorPosition;
	int      m_iLastCompletionCursorXPosition;
	int      m_iLastCompletionFirstVisibleChar;
// added by munehiro 30 oct 1999
	KviStr	 m_szStringBeforeSubstitution;
	bool	 m_bLastEventWasASubstitution;
	int	 m_iCursorPositionBeforeSubstitution;
	int	 m_iCursorXPositionBeforeSubstitution;
	int	 m_iFirstVisibleCharBeforeSubstitution;
	char	 m_cDetonationChar;
	void checkForSubstitution();
public:
	int heightHint() const;
	void setText(const char *text);
	void insertChar(char c);
//	void controlViewScrolling(KviIrcView *view);
//	void setNickCompletionSource(KviListBox * box);
private:
	char * runUpToTheFirstVisibleChar();
	bool   extractNextBlock(char *p,int curXPos,int maxXPos);
	void drawTextBlock(GC gc_aux,HANDLE hMemBuffer,int curXPos,int bottom,char *p,int len,int wdth);
	char getSubstituteChar(char control_code);
	void moveRightFirstVisibleCharToShowCursor();
	void repaintWithCursorOn();
	void selectOneChar(int pos);
	int  charIndexFromXPosition(int xPos);
	int  xPositionFromCharIndex(int chIdx);
	void killDragTimer();
	void handleDragSelection();
	void end();
	void home();
	bool hasSelection();
	void moveCursorTo(int idx,bool bRepaint = true);
	void returnPressed(bool bRepaint = true);
	void completion(bool bShift);
	void nickCompletion(bool bAddMask,KviStr &word,bool bFirstWordInLine);
public slots:
	void copy();
	void cut();
	void paste();
	void selectAll();
	void clear();
protected:
	virtual void paintEvent(QPaintEvent *);
	virtual void resizeEvent(QResizeEvent *);
	virtual void timerEvent(QTimerEvent *e);
	virtual void focusInEvent(QFocusEvent *);
	virtual void focusOutEvent(QFocusEvent *);
	virtual void keyPressEvent(QKeyEvent *e);
	virtual void keyReleaseEvent(QKeyEvent *e);
	virtual void mousePressEvent(QMouseEvent *e);
	virtual void mouseReleaseEvent(QMouseEvent *);
	virtual void dragEnterEvent(QDragEnterEvent *e);
	virtual void dropEvent(QDropEvent *e);
signals:
	void keyPressed();
//	void textInput(KviStr *);
//	void changedFont(const QFont &newFont);
//	virtual void dragMoveEvent(QDragMoveEvent *e);
};

#endif //_KVI_INPUT_H_INCLUDED_
