//
//   File : kvi_helpqml.cpp (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_helpqml.cpp)
//   Last major modification : Thu Mar 25 1999 19:10:12 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//#define _KVI_DEBUG_CHECK_RANGE_
//#define _KVI_DEBUG_CLASS_NAME_ "KviHelpQMLClasses"

#include "kvi_debug.h"
#include "kvi_helpqml.h"
#include "kvi_locale.h"
#include "kvi_frame.h"
#include "kvi_app.h"
#include "kvi_options.h"
#include "kvi_fileutils.h"

#include <qfile.h>
#include <qtextstream.h>
#include <qnamespace.h>
#include <qdragobject.h>
/*
	@quickhelp: nohelpavailable
	@widget: No help available
		There is no help available for the item you have selected.<br>
		Go back to the <a href="index.html">Main index</a>
*/
/*

QMimeSource * g_pCurMimeSource = 0; //Absurd...but it is needed.... QMimeSourceFactory::data() is const. (WHY ?)

KviHelpQMLProvider::KviHelpQMLProvider()
:QMimeSourceFactory()
{
//	debug("Global QMimeSourceFactory : constructed");
	__range_valid(g_pCurMimeSource == 0);
}

KviHelpQMLProvider::~KviHelpQMLProvider()
{
//	debug("Global QMimeSourceFactory : destrukted");
	if(g_pCurMimeSource){
		delete g_pCurMimeSource;
		g_pCurMimeSource = 0;
	}
}



const QMimeSource* KviHelpQMLProvider::data(const QString& abs_name) const
{
	QMimeSource * s = 0;
	KviStr fName = abs_name; //SHOULD BE RELATIVE!!!
	fName.toLower();
	KviStr fPath;
	if(fName.left(1) == "/"){
		if(!kvi_fileExists(fName.ptr())){
			int idx = fName.findLastIdx('/');
			fName.cutLeft(idx+1);
		} else fPath = fName;
		// Forget global path if does not exist...
	}
	if(fPath.isEmpty()){
		// Localized help
		g_pApp->getGlobalKVircDirectory(fPath,KviApp::Help,fName.ptr());
		if(!kvi_fileExists(fPath.ptr())){
			// Try default locale (en)
			g_pApp->getGlobalKVircDirectory(fPath,KviApp::HelpEN,fName.ptr());
			if(!kvi_fileExists(fPath.ptr())){
				// Try non localized one
				g_pApp->getGlobalKVircDirectory(fPath,KviApp::HelpNoIntl,fName.ptr());
				if(!kvi_fileExists(fPath.ptr())){
					// Look in the local dir
					g_pApp->getLocalKVircDirectory(fPath,KviApp::Help,fName.ptr());
					if(!kvi_fileExists(fPath.ptr())){
						// last script path
						fPath = g_pOptions->m_szLastScriptPath;
						if(!fPath.lastCharIs('/'))fPath.append('/');
						fPath.append(fName);
						if(!kvi_fileExists(fPath.ptr())){
							fPath = g_pOptions->m_szLastScriptPath;
							if(!fPath.lastCharIs('/'))fPath.append('/');
							fPath.append("help/");
							fPath.append(fName);
							if(!kvi_fileExists(fPath.ptr())){
								if(fName.findFirstIdx("nohelpavailable") == -1){
									fName = "nohelpavailable.kvihelp";
									g_pApp->getGlobalKVircDirectory(fPath,KviApp::Help,fName.ptr());
								}
							}
						}
					}
				}
			}
		}
	}

	g_pApp->m_szLastHelpDocument = fName;

#ifdef _KVI_DEBUG_CLASS_NAME_
	KviStr szName = fPath;
	__debug_1arg("QML document requested %s",fPath.ptr());
#endif

	QFile f(_CHAR_2_QSTRING(fPath.ptr()));

	if(f.open(IO_ReadOnly)){
		QTextStream t(&f);
		QString data = t.read();
		f.close();
		//Modify the background color on the fly!
		QString temp;
		temp.sprintf("<qt type=\"page\" bgcolor=\"#%X%X%X\">",g_pOptions->m_clrHelpBack.red(),
			g_pOptions->m_clrHelpBack.green(),g_pOptions->m_clrHelpBack.blue());
		data.prepend(temp);
		data.append("</qt>");
		s = new QTextDrag(data);
	} else {
		QString data = __tr("<qt type=page bgcolor=\"#000000\" text=\"#FF0000\">"\
							"<center><h2>Warning</h2><br>"\
							"The requested document <br>");
		data+= _CHAR_2_QSTRING(fName.ptr());
		data+= __tr("<br>can not be open for reading.</center></qt>");
		s = new QTextDrag(data);
	}

	if(g_pCurMimeSource){
		delete g_pCurMimeSource;
		g_pCurMimeSource = 0;
	}
	g_pCurMimeSource = s;
	return s;
}

*/
KviHelpQMLStyleSheet::KviHelpQMLStyleSheet(QObject *parent)
:QStyleSheet(parent)
{
	__debug("Global style sheet : constructor");
	QStyleSheetItem * style = new QStyleSheetItem(this, "example" );
    style->setFontFamily(g_pOptions->m_fntHelpFixed.family());
	style->setColor(g_pOptions->m_clrHelpExample);
    style->setDisplayMode(QStyleSheetItem::DisplayBlock);
    style->setWhiteSpaceMode(QStyleSheetItem::WhiteSpacePre);
    style->setMargin(QStyleSheetItem::MarginAll,8);
    style->setFontSize(g_pOptions->m_fntHelpFixed.pointSize());
//	insert(style); // qt segfaulted with it....(maybe in the future it will be needed)
	style = new QStyleSheetItem( this, "doctitle" );
	style->setColor(g_pOptions->m_clrHelpTitle);
    style->setDisplayMode(QStyleSheetItem::DisplayBlock);
    style->setFontFamily(g_pOptions->m_fntHelpNormal.family());
    style->setFontSize(g_pOptions->m_fntHelpNormal.pointSize() + 6);
	style->setFontWeight(QFont::Bold);
    style->setMargin(QStyleSheetItem::MarginVertical,10);
    style->setMargin(QStyleSheetItem::MarginHorizontal,0);
	style = new QStyleSheetItem( this, "docsubtitle" );
	style->setColor(g_pOptions->m_clrHelpSubtitle);
    style->setDisplayMode(QStyleSheetItem::DisplayBlock);
    style->setFontFamily(g_pOptions->m_fntHelpNormal.family());
    style->setFontSize(g_pOptions->m_fntHelpNormal.pointSize() + 2);
	style->setFontWeight(QFont::Bold);
    style->setMargin(QStyleSheetItem::MarginVertical,5);
    style->setMargin(QStyleSheetItem::MarginHorizontal,0);
	style = new QStyleSheetItem( this, "docbody" );
	style->setColor(g_pOptions->m_clrHelpFore);
    style->setFontFamily(g_pOptions->m_fntHelpNormal.family());
    style->setFontSize(g_pOptions->m_fntHelpNormal.pointSize());
    style->setDisplayMode(QStyleSheetItem::DisplayBlock);
    style->setMargin(QStyleSheetItem::MarginVertical,0);
    style->setMargin(QStyleSheetItem::MarginHorizontal,0);
	style = new QStyleSheetItem( this, "docpre" );
	style->setColor(g_pOptions->m_clrHelpFore);
    style->setFontFamily(g_pOptions->m_fntHelpNormal.family());
    style->setFontSize(g_pOptions->m_fntHelpNormal.pointSize());
    style->setDisplayMode(QStyleSheetItem::DisplayBlock);
    style->setMargin(QStyleSheetItem::MarginVertical,0);
    style->setMargin(QStyleSheetItem::MarginHorizontal,0);
    style->setWhiteSpaceMode(QStyleSheetItem::WhiteSpacePre);
}

KviHelpQMLStyleSheet::~KviHelpQMLStyleSheet()
{
	__debug("Global style sheet : destruktor");
}

void KviHelpQMLStyleSheet::error(const QString &err) const
{
	debug("StyleSheetError : %s",err.latin1());
}

#include "m_kvi_helpqml.moc"
