//
//   File : kvi_fileutils.cpp (/usr/build/NEW_kvirc/kvirc/kvicore/kvi_fileutils.cpp)
//   Last major modification : Fri Dec 25 1998 18:26:48 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

//#define _KVI_DEBUG_CHECK_RANGE_
#include "kvi_debug.h"

#include "kvi_settings.h"

#define _KVI_FILEUTLIS_CPP_
#include "kvi_fileutils.h"

#include "kvi_locale.h"

#include <qdir.h>
#include <qfile.h>
#include <qfileinfo.h>

//================ kvi_askFor*Name ============//

#include <qfiledialog.h>

QString kvi_askForDirectoryName(const char *basePath)
{
	return QFileDialog::getExistingDirectory(basePath);
}

QString kvi_askForOpenFileName(const char *basePath,const char *filter)
{
	return QFileDialog::getOpenFileName(basePath,filter);
}

QStringList kvi_askForOpenFileNames(const char *basePath,const char *filter)
{
	return QFileDialog::getOpenFileNames(filter,basePath);
}

QString kvi_askForSaveFileName(const char *baseFileName)
{
	return QFileDialog::getSaveFileName(baseFileName);
}

//================ kvi_isAbsolutePath ===============//

bool kvi_isAbsolutePath(const char *path)
{
	__range_valid(path);
	return ((*path)=='/');
}

//============ kvi_directoryExists ================//

bool kvi_directoryExists(const char *path)
{
	__range_valid(path);
	QFileInfo f(path);
	return (f.exists() && f.isDir());
}

//============ kvi_fileExists ================//

bool kvi_fileExists(const char *path)
{
	__range_valid(path);
	QFileInfo f(path);
	return (f.exists() && f.isFile());
}

//============= kvi_fileIsReadable =============//

bool kvi_fileIsReadable(const char *path)
{
	__range_valid(path);
	QFileInfo f(path);
	return (f.exists() && f.isFile() && f.isReadable());
}

//================ kvi_makeDir ================//

bool kvi_makeDir(const char *path)
{
	__range_valid(path);
	QDir d;
	KviStr dir(path);
	KviStr createdDir("");
	dir.stripLeft('/');
	while(dir.hasData()){
		createdDir+="/";
		createdDir+=dir.getToken('/');
		if(!kvi_directoryExists(createdDir.m_ptr)){
			if(!d.mkdir(createdDir.m_ptr)){
				debug("Can't create directory %s",createdDir.m_ptr);
				return false;
			}
		}
	}
	return true;
}

//=================== kvi_readLine =====================//

bool kvi_readLine(QFile *f,KviStr &str)
{
	char tmp_buf[256];
	int cur_len = 0;
//	char *cur_ptr = tmp_buf;
	str = "";
	int ch = f->getch();
	
	while((ch != -1)&&(ch != '\n')&&(ch != 0)){
		tmp_buf[cur_len] = ch;
		cur_len++;
		if(cur_len > 255){
			if(tmp_buf[255] == '\r')cur_len--; //Ignore CR...
			str.append(tmp_buf,cur_len);
			cur_len = 0;
		}
		ch = f->getch();
	}
	if(ch == 0){
		KviStr fName = f->name();
		debug("Warning : %s is not an ascii file",fName.ptr());
	}
	if(cur_len > 0){
		if(tmp_buf[cur_len-1] == '\r')cur_len--; //Ignore last CR
		str.append(tmp_buf,cur_len);
	}
//	debug("ch is now %c , cur_len is now %d , string is %s",ch,cur_len,str.ptr());
	return (ch == '\n'); //more data to read else a broken file or EOF
}

//==================== kvi_readStrippedLine =====================//

bool kvi_readStrippedLine(QFile *f,KviStr &str)
{
	bool bRet = kvi_readLine(f,str);
	str.stripWhiteSpace();
	return bRet;
}

//==================== kvi_readFirstNonEmptyStrippedLine =========================//

bool kvi_readFirstNonEmptyStrippedLine(QFile *f,KviStr &str)
{
	bool bContinue;
	do{
		bContinue = kvi_readStrippedLine(f,str);
	} while(bContinue && str.isEmpty());
	return bContinue;
}

//=================== kvi_writeLine =======================//

bool kvi_writeLine(QFile *f,const char *line)
{
	bool bRet = (f->writeBlock(line,strlen(line)) != -1);
	return bRet ? (f->putch('\n') != -1) : false;
}

//=================== kvi_loadFile =======================//

bool kvi_loadFile(const char *path,KviStr &buffer)
{
	QFile f(path);
	if(!f.open(IO_ReadOnly))return false;
	buffer = "";
	KviStr tmp;
	while(kvi_readLine(&f,tmp)){
		buffer.append(tmp);
		buffer.append('\n'); // kvi_readLine returned true...last char was a newline
	}
	// kvi_readLine returned false , no ending newline encountered
	// but tmp may still contain some data
	if(tmp.hasData())buffer.append(tmp);
	return true;
}

bool kvi_writeFile(const char *path,KviStr &buffer)
{
	QFile f(path);
	if(!f.open(IO_WriteOnly|IO_Truncate))return false;
	if(f.writeBlock(buffer.ptr(),buffer.len()) != buffer.len())return false;
	f.close();
	return true;
}

bool kvi_copyFile(const char *src,const char *dst)
{
	QFile f1(src);
	if(!f1.open(IO_ReadOnly))return false;
	QFile f2(dst);
	if(!f2.open(IO_WriteOnly|IO_Truncate)){
		f1.close();
		return false;
	}
	char buffer[1024];
	while(!f1.atEnd()){
		int len = f1.readBlock(buffer,1024);
		if(len == -1){
			f1.close();
			f2.close();
			return false; //"serious error"
		}
		f2.writeBlock(buffer,len);
	}
	f1.close();
	f2.close();
	return true;
}

bool kvi_renameFile(const char *src,const char *dst)
{
	QDir d;
	return d.rename(_CHAR_2_QSTRING(src),_CHAR_2_QSTRING(dst));
}
