/*
	mtip.cpp - A tip widget
	Copyright (C) 2003  Konrad Twardowski <kdtonline@poczta.onet.pl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "mtip.h"

#include <qtooltip.h>

#include <kiconloader.h>

// public

MTip::MTip(const TipType tipType, QWidget *parent)
	: KActiveLabel(parent, "MTip")
{
	setFrameStyle(StyledPanel | Sunken);
	setTipType(tipType);
	setTipText("");
}

MTip::~MTip()
{
}

void MTip::setTipText(const QString &value)
{
	// valign and "center" ?
	QString leftCell = "<td align=\"center\" valign=\"center\">";
	leftCell += _iconPath.isEmpty() ? "&nbsp;" : ("<img src=\"" + _iconPath + "\">");
	leftCell += "</td>";
	setText(
		"<qt>" \
		"<table border=\"0\" cellpadding=\"0\" cellspacing=\"2\">" \
		"<tr>" + leftCell + "<td>" + value + "</td></tr>" \
		"</table>" \
		"</qt>"
	);
}

void MTip::setTipType(const TipType value)
{
	_type = value;
	switch (_type)
	{
		case Info:
			_iconPath = getIconPath("messagebox_info");
			setPaletteBackgroundColor(white);
			setPaletteForegroundColor(blue);
			break;
		case Normal:
			_iconPath = getIconPath("messagebox_info");
			setPaletteBackgroundColor(QToolTip::palette().active().background());
			setPaletteForegroundColor(black);
			break;
		case Warning:
			_iconPath = getIconPath("messagebox_warning");
			setPaletteBackgroundColor(yellow);
			setPaletteForegroundColor(black);
			break;
		default:
			_iconPath = "";
	}
}

// private

QString MTip::getIconPath(const QString &name) const
{
	return KGlobal::iconLoader()->iconPath(name, KIcon::NoGroup, KIcon::SizeLarge);
}
