/***************************************************************************
                                krspwidgets.cpp
                             -------------------
    copyright            : (C) 2000 by Shie Erlich & Rafi Yanai
    e-mail               : krusader@users.sourceforge.net
    web site             : http://krusader.sourceforge.net
 ---------------------------------------------------------------------------
  Description 
 ***************************************************************************

  A 

     db   dD d8888b. db    db .d8888.  .d8b.  d8888b. d88888b d8888b.
     88 ,8P' 88  `8D 88    88 88'  YP d8' `8b 88  `8D 88'     88  `8D
     88,8P   88oobY' 88    88 `8bo.   88ooo88 88   88 88ooooo 88oobY'
     88`8b   88`8b   88    88   `Y8b. 88~~~88 88   88 88~~~~~ 88`8b
     88 `88. 88 `88. 88b  d88 db   8D 88   88 88  .8D 88.     88 `88.
     YP   YD 88   YD ~Y8888P' `8888Y' YP   YP Y8888D' Y88888P 88   YD

                                                     S o u r c e    F i l e

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "krspwidgets.h"
#include "../krusader.h"
#include "../krusaderview.h"
#include "../Panel/kvfspanel.h"
#include "../kicons.h"
#include <qcombobox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qlistbox.h>
#include <qspinbox.h>
#include <klocale.h>

///////////////////// initiation of the static members ////////////////////////
QStrList KRSpWidgets::maskList;

///////////////////////////////////////////////////////////////////////////////

KRSpWidgets::KRSpWidgets(){
}

QString KRSpWidgets::getMask(QString caption) {
  KRMaskChoiceSub *p=new KRMaskChoiceSub();
  p->setCaption(caption);
  p->exec();
  if (p->selection->currentText()=="") return QString::null; 
    else return p->selection->currentText();
}

void KRSpWidgets::selectCompareColorMask(int *left, int *right) {
  // this should be an exact copy of the one in kvfspanel
  enum cmpColor {none = 0, exclusive = 1, newer = 2, older = 4, identical = 8 };
  int l = krApp->mainView->left->colorMask;
  int r = krApp->mainView->right->colorMask;

  // create the dialog, and fill in the data according to current color mask
  colorMaskDialog *dlg = new colorMaskDialog();
  dlg->newerLeft->setChecked(l & newer);
  dlg->olderLeft->setChecked(l & older);
  dlg->identicalLeft->setChecked(l & identical);
  dlg->exclusiveLeft->setChecked(l & exclusive);
  dlg->newerRight->setChecked(r & newer);
  dlg->olderRight->setChecked(r & older);
  dlg->identicalRight->setChecked(r & identical);
  dlg->exclusiveRight->setChecked(r & exclusive);

  if (!dlg->exec()) {
    *left = *right = -1;
    return;
  }

  // create masks
  (*left) = 0; (*right) = 0;
  (*left) |= (dlg->newerLeft->isChecked() ? newer : 0);
  (*left) |= (dlg->olderLeft->isChecked() ? older : 0);
  (*left) |= (dlg->identicalLeft->isChecked() ? identical : 0);
  (*left) |= (dlg->exclusiveLeft->isChecked() ? exclusive : 0);

  (*right) |= (dlg->newerRight->isChecked() ? newer : 0);
  (*right) |= (dlg->olderRight->isChecked() ? older : 0);
  (*right) |= (dlg->identicalRight->isChecked() ? identical : 0);
  (*right) |= (dlg->exclusiveRight->isChecked() ? exclusive : 0);
}

/////////////////////////// newFTP ////////////////////////////////////////
QString KRSpWidgets::newFTP() {
  newFTPSub *p=new newFTPSub();
  p->exec();
  if (p->url->text()=="") return QString::null;
  QString URL="ftp://"+p->username->text() + ":" +
              p->password->text() + "@" + p->url->text() + ":" + p->port->cleanText();

  return URL;
}

newFTPSub::newFTPSub() : newFTPGUI(0,0,true) {
  prefix->setReadOnly(true);
  url->setFocus();
  setGeometry(krApp->x()+krApp->width()/2-width()/2,krApp->y()+krApp->height()/2-height()/2,width(),height());
}

void newFTPSub::accept() {
  newFTPGUI::accept();
}

void newFTPSub::reject() {
  url->setText("");
  newFTPGUI::reject();
}

/////////////////////////// KRMaskChoiceSub ///////////////////////////////
KRMaskChoiceSub::KRMaskChoiceSub() : KRMaskChoice(0,0,true) {
  PixmapLabel1->setPixmap(LOADICON("kr_select"));
  label->setText(i18n("Enter a selection:"));
  // the predefined selections list
  krConfig->setGroup("Private");
  QStrList lst;
  int i=krConfig->readListEntry("Predefined Selections",lst);
  if (i>0) preSelections->insertStrList(lst);
  // the combo-box tweaks
  selection->setDuplicatesEnabled(false);
  selection->insertStrList(KRSpWidgets::maskList);
  selection->lineEdit()->setText("*");
  selection->lineEdit()->selectAll();
  selection->setFocus();
}

void KRMaskChoiceSub::reject() {
  selection->clear();
  KRMaskChoice::reject();
}

void KRMaskChoiceSub::accept() {
  QString topItem=KRSpWidgets::maskList.getFirst();
  if (topItem!=selection->currentText())
    KRSpWidgets::maskList.insert(0,selection->currentText().local8Bit());
  // write down the predefined selections list
  QStrList list;
  QListBoxItem *i=preSelections->firstItem();
  while (i!=0) {
    list.append(i->text().local8Bit());
    i=i->next();
  }
  krConfig->setGroup("Private");
  krConfig->writeEntry("Predefined Selections",list);
  KRMaskChoice::accept();
}

void KRMaskChoiceSub::addSelection() {
  QString temp=selection->currentText();
  bool itemExists=false;
  QListBoxItem *i=preSelections->firstItem();
  // check if the selection already exists
  while (i!=0)
    if (i->text()==temp) { 
      itemExists=true; 
      break; 
    } else i=i->next();
  if (temp!="" && !itemExists) {
    preSelections->insertItem(selection->currentText());
    preSelections->update();
  }
}

void KRMaskChoiceSub::deleteSelection() {
  if (preSelections->currentItem()!=-1) {
    preSelections->removeItem(preSelections->currentItem());
    preSelections->update();
  }
}

void KRMaskChoiceSub::clearSelections() {
  preSelections->clear();
  preSelections->update();
}

void KRMaskChoiceSub::acceptFromList(QListBoxItem *i) {
  selection->insertItem(i->text(),0);
  accept();
}
