/*
 *  Copyright (C) 1999 Peter Amstutz
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of *the
 *  License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307 USA 
 */
#ifndef _GFX_H_
#define _GFX_H_

#include <ggi/ggi.h>
#include "player.h"
#include "terrain.h"

/* The maximum value for a color. */
#define CMAX ((uint16)(~0))
#define MAX_WALLS 6

extern ggi_visual_t gfx_vis;
extern ggi_visual_t gfx_tankpic, gfx_tankpic_right, gfx_tankpic_left;
extern int gfx_xmax, gfx_ymax;	/* actual window/graphics mode dimensions */
extern int gfx_xoff, gfx_yoff;	/* playing field drawing offset */
extern int gfx_xsize, gfx_ysize;	/* playing field on-screen dimensions */
extern ggi_pixel gfx_tankcolor[MAX_TANKS + 1 + 1]; /* MAX_TANKS + blank + grey */
extern ggi_pixel gfx_wallcolor[MAX_WALLS];
extern ggi_pixel gfx_white;
extern ggi_pixel gfx_green;
extern ggi_pixel gfx_red;
extern int observer_color;
extern int gfx_visualdepth;
extern int gfx_armorBar;

void gfxDrawTerrain(int sx, int sy, int sw, int sh, int tx, int ty, int tw,
		    int th, TerrainSpans_ter * in);
ggi_visual_t gfxScaleMemvis(ggi_visual_t input, int newx, int newy);
ggi_visual_t gfxFlipMemvis(ggi_visual_t input);
ggi_visual_t gfxXPMtoMemvis(char **xpm);
void gfxDrawSky(int sx, int sy, int w, int h);
void gfxInit();
void gfxInitTankImage();
void gfxInitWallColors();
void gfxShutdown();
void gfxBlitTankSprite(int sx, int sy, ggi_visual_t sp, ggi_pixel color);
void gfxDrawTank(Player_pl * pl);
void gfxEraseTank(Player_pl * pl, int n);
void gfxUpdate();
void gfxDoUpdate();
void gfxDrawCircle(int xo, int yo, int r);
void gfxDrawThickCircle(int xo, int yo, int r);
void gfxDrawEllipse(int xo, int yo, int a, int b);
void gfxDrawThickEllipse(int xo, int yo, int a, int b);
void gfxDrawSimpleExplosion(int x, int y, int r);
void gfxDrawArea(int tx, int ty, int w, int h);
void gfxDrawWalls(int sx, int sy, int sw, int sh);
void gfxDrawPlayerList();

int gfxTerrainToScreenXCoord(int tx);
int gfxTerrainToScreenYCoord(int ty);
int gfxScreenToTerrainXCoord(int sx);
int gfxScreenToTerrainYCoord(int sy);
int gfxScaleTerrainToScreenXDimen(int tx);
int gfxScaleTerrainToScreenYDimen(int ty);
int gfxScaleScreenToTerrainXDimen(int sx);
int gfxScaleScreenToTerrainYDimen(int sy);


#endif
