/***************************************************************************
                          xmlstream.cpp  -  description
                             -------------------
    begin                : Thu Sep 30 1999
    copyright            : (C) 1999 by Seth Hartbecke
    email                : gandalf@netins.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "xmlstream.h"
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/time.h>
#include <stdio.h>
#include <sys/un.h>
#include <unistd.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>





XMLStream::XMLStream( QObject *parent, const char *name )
	: Expat( parent , name )
{
	notifier = 0;
}

XMLStream::~XMLStream()
{
	cleanup();
}

void XMLStream::cleanup()
{
	if (notifier != 0)
	{
		delete notifier;
		notifier = 0;
	}

	if (fd != 0)
	{
		writeData("</stream:stream>");
		close(fd);
		fd = 0;
	}
}


void XMLStream::disconnect()
{
 	cleanup();
 	connectionLost();
}

void XMLStream::connectionLost()
{
 	printf("XMLStream::connectionLost()...should be overridden?\n");
}

void XMLStream::sendKeepalive()
{
	printf("XMLStream::sendKeepalive()\n");
        writeData("  \n");
}

/* handles the coversion of a tag to a string and sends it */
int XMLStream::sendTag(XMLNode &t)
{
	printf("Sending Data To Server:\n");
        printf("\e[1m\e[31m");  // Color red
	XMLNode::printXML( &t );
        printf("\e[0m");        // Color normal

 	return writeData( t.getXML() );
}

int XMLStream::connectXMLStream( const char *_server, int _port, const char *_xmlns, const char *_xmlnsStream )
{
 	server = _server;
 	port = _port;
 	xmlns = _xmlns;
 	xmlnsStream = _xmlnsStream;
 	
 	/* Here is where we actually attempt to connect to this server */
	int len, retVal;
	struct sockaddr_in address;
	struct hostent *hostinfo;	

	//printf("XMLStream:: attempting to connect to %s\n", (const char *)server);

	// Create a socket
	fd = socket(AF_INET, SOCK_STREAM, 0);
	
	// Lookup the host name
	hostinfo = gethostbyname((const char *)server);	
	if(!hostinfo)
	{
		printf("XMLStream::ConnectToServer--Unable to find host %s\n", (const char *)server);
		fd = 0;

		return DNS_NOT_FOUND;
	}
	
	/* Ok...we found the host, now let's try to acutally connect */
	address.sin_family = AF_INET;
	address.sin_addr = *(struct in_addr *)*hostinfo -> h_addr_list;
	address.sin_port = htons(port);
	
	len = sizeof(address);
	
	retVal = ::connect(fd, (struct sockaddr *)&address, len);
	if (retVal != 0)
	{
		printf("XMLStream::XMLStream--Unable to connect to host %s:%d\n", (const char *)server, port);
		fd = 0;

		return CONNECTION_REJECTED;
	}
		
 	/* Get expat ready */
 	Expat::reset();
	
	notifier = new QSocketNotifier(fd, QSocketNotifier::Read);
 	connect( notifier, SIGNAL(activated(int)), this, SLOT(newData()) );

	// First we are going to send the <?xml packet... stuff
	QString stuffToSend;
	stuffToSend.sprintf("<?xml version=\"1.0\"?><stream:stream to=\"%s\" xmlns=\"%s\" xmlns:stream=\"%s\">", (const char *)server, (const char *)xmlns, (const char *)xmlnsStream);
	writeData(stuffToSend);	

        keepAlive = new QTimer( this );
        connect( keepAlive, SIGNAL(timeout()), this, SLOT(sendKeepalive()) );
        keepAlive->start( 300000, FALSE );       // Every 1 minute

	return 0;			 	
}

bool XMLStream::isConnected()
{
	if (fd == 0)
		return false;
	else
		return true;
}

int XMLStream::writeData(QString s)
{
	int bytesWritten;

	if (fd == 0)
		return -1;

  	QCString utf = s.utf8();

 	bytesWritten = write(fd, (void *)(const char *)utf, utf.length());

        if ( bytesWritten != (int)s.length() )
		connectionLost();

        return bytesWritten;
}

// This is the function that reads the data out of the communication
// pipe and sends it to Expat.
void XMLStream::newData()
{
 	char buf[1025];
 	int len;
 	int i;
 	
 	for(i=0;i<1025;i++)
 		buf[i] = '\0';
 		
	len = read(fd, buf, 1024);
 	
	buf[len] = '\0';
	
	//printf("XMLStream::Read %s\n", buf);	

	parse( buf );
			
	if (len == 0)
	{
		printf("XMLStream::read(): Connection to server closed\n");

		cleanup();

		connectionLost();
 	 	return;
	}
	 	 	
}




