/***************************************************************************
                          userlistmenu.cpp  -  description                              
                             -------------------                                         
    begin                : Sun Jan 9 2000                                           
    copyright            : (C) 2000 by Seth Hartbecke                         
    email                : gandalf@netins.net                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "userlistmenu.h"

#include <userpresence.h>

UserListMenu::UserListMenu(QWidget *parent, const char *name )
	: QPopupMenu(parent,name)
{
        nextMenuId = 1;

	insertItem( "Add User", this, SLOT(addNewUser()), 0, nextMenuId );
        nextMenuId++;
	insertSeparator();

	int count_i;
	for (count_i=0; count_i<jabber->numberUsers(); count_i++)
                addUser( jabber->getUser(count_i) );

	connect( jabber, SIGNAL(newUser(User *)), this, SLOT(addUser(User *)) );
}

UserListMenu::~UserListMenu()
{

}

void UserListMenu::userInfoChanged(User *u)
{
        int id = userMenuIDmap[ u ];
        QPixmap icon;

        if ( u->numberResources() == 0 )
        	icon = KGlobal::iconLoader()->loadIcon("user_offline", KIcon::Small );
        else
        	icon = u->getHighestPresence()->getIcon();

        changeItem( id, icon, u->getRealName() );
}

void UserListMenu::presenceChanged(User *u, UserPresence *)
{
        int id = userMenuIDmap[ u ];
        QPixmap icon;

        if ( u->numberResources() == 0 )
        	icon = KGlobal::iconLoader()->loadIcon("user_offline", KIcon::Small );
        else
        	icon = u->getHighestPresence()->getIcon();

        changeItem( id, icon, u->getRealName() );
}

void UserListMenu::addUser(User *u)
{
        if (u->getNode().isEmpty())
                return; // This is a transport

        QPixmap icon;
        connect( u, SIGNAL(userDeleted(User *)), this, SLOT(removeUser(User *)) );

        if ( u->numberResources() == 0 )
        	icon = KGlobal::iconLoader()->loadIcon("user_offline", KIcon::Small );
        else
        	icon = u->getHighestPresence()->getIcon();


	insertItem( icon, u->getRealName(), u, SLOT(show()), 0, nextMenuId );
        userMenuIDmap.insert( u, nextMenuId );
        connect( u, SIGNAL(informationChanged(User *)), this, SLOT(userInfoChanged(User *)) );
        connect( u, SIGNAL(presenceChanged(User *, UserPresence *)), this, SLOT(presenceChanged(User *, UserPresence *)) );
        nextMenuId++;
}

void UserListMenu::addNewUser()
{
	UserAdd *newUser;
	newUser = new UserAdd( 0 );

	newUser->show();
}

void UserListMenu::removeUser( User *u )
{
        int id = userMenuIDmap[ u ];

        removeItem( id );
        userMenuIDmap.remove( u );
}

