/***************************************************************************
                          konverse.cpp  -  description
                             -------------------
    begin                : Sat Oct  21 22:39:20 CDT 2000

    copyright            : (C) 1999 by Seth Hartbecke
    email                : gandalf@netins.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "setstatus.h"

DlgSetStatus *DlgSetStatus::openDlg = 0;

void DlgSetStatus::setStatus( JabberCore::StatusType defaultStatus )
{
 	if ( !openDlg )
        	openDlg = new DlgSetStatus( defaultStatus );
        else
        {
		openDlg->statusChanged( defaultStatus );
                openDlg->cboStatus->setCurrentItem( defaultStatus );
  	}
}

DlgSetStatus::DlgSetStatus( JabberCore::StatusType defaultStatus )
	: QWidget( 0, "Set Status Dlg" )
{
	setCaption( "Set Status - Konverse" );

	lblStatus = new QLabel( "Status:", this, "lblstatus" );
        lblDescription = new QLabel( "Description: ", this, "lbldescription" );
        lblPriority = new QLabel( "Priority: ", this, "lblpriority" );

        ok = new QPushButton( "Ok", this, "ok" );
        connect( ok, SIGNAL(clicked()), this, SLOT(okClicked()) );
        cancel = new QPushButton( "Cancel", this, "cancel" );
        connect( cancel, SIGNAL(clicked()), this, SLOT(cancelClicked()) );
	txtDescription = new QLineEdit( this, "description" );
	txtDescription->setFocus();
	connect( txtDescription, SIGNAL(returnPressed()), this, SLOT(okClicked()) );
        spnPriority = new QSpinBox( -10, 20, 1, this, "spnpriority" );
        spnPriority->setValue( 10 );
        cboStatus = new QComboBox( false, this, "cboStatus" );
        cboStatus->insertItem( KGlobal::iconLoader()->loadIcon("user_chat", KIcon::Small ), "Chat" );
        cboStatus->insertItem( KGlobal::iconLoader()->loadIcon("user_online", KIcon::Small ), "Normal" );
        cboStatus->insertItem( KGlobal::iconLoader()->loadIcon("user_away", KIcon::Small ), "Away" );
        cboStatus->insertItem( KGlobal::iconLoader()->loadIcon("user_xaway", KIcon::Small ), "Extended Away" );
        cboStatus->insertItem( KGlobal::iconLoader()->loadIcon("user_dnd", KIcon::Small ), "Do Not Disturb" );
        cboStatus->setCurrentItem( defaultStatus );

        statusChanged( defaultStatus );
        connect( cboStatus, SIGNAL(activated(int)), this, SLOT(statusChanged(int)) );

        layout = new QGridLayout( this, 4, 3, 5, 5 );
        layout->addWidget( lblStatus, 0, 0 );
        layout->addWidget( lblDescription, 1, 0 );
        layout->addWidget( lblPriority, 2, 0 );
        layout->addWidget( cboStatus, 0, 1 );
        layout->addMultiCellWidget( txtDescription, 1, 1, 1, 2 );
        layout->addWidget( spnPriority, 2, 1 );

        btnLayout = new QHBoxLayout( 0, 5, 5 );
        btnLayout->addWidget( ok );
        btnLayout->addWidget( cancel );
        layout->addItem( btnLayout, 3, 2 );


        show();
}

DlgSetStatus::~DlgSetStatus()
{
	delete layout;
        /*
        delete btnLayout;
        */

        delete lblStatus;
        delete lblDescription;
        delete lblPriority;

        delete txtDescription;
        delete spnPriority;
        delete cboStatus;

        delete ok;
        delete cancel;

        openDlg = 0;
}

void DlgSetStatus::statusChanged( int i )
{
 	switch( i )
        {
         	case JabberCore::Chat:
                	txtDescription->setText( "Somebody please talk to me" );
                 	break;
          	case JabberCore::Normal:
                	txtDescription->setText( "Connected with Konverse jabber client" );
                        break;
           	case JabberCore::Away:
                	txtDescription->setText( "I'm not here" );
                        break;
            	case JabberCore::ExtendedAway:
                	txtDescription->setText( "I'm far away from here" );
                        break;
             	case JabberCore::DND:
                	txtDescription->setText( "I'm here, but busy.  Go away." );
                        break;
        }
}

void DlgSetStatus::okClicked()
{
 	jabber->setStatus( (JabberCore::StatusType)cboStatus->currentItem(), spnPriority->value(), txtDescription->text() );

	close();
}

void DlgSetStatus::closeEvent( QCloseEvent * )
{
	delete this;
}



/***************************************************************************
			SetStatusMenu
***************************************************************************/
SetStatusMenu::SetStatusMenu(QWidget *parent, const char *name)
	: QPopupMenu( parent, name )
{
        setCheckable( true );

        idChat = insertItem( KGlobal::iconLoader()->loadIcon("user_chat", KIcon::Small ), "Available for Chat", this, SLOT(setChat()) );
        idNormal = insertItem( KGlobal::iconLoader()->loadIcon("user_online", KIcon::Small ), "Normal", this, SLOT(setNormal()) );
        idAway = insertItem( KGlobal::iconLoader()->loadIcon("user_away", KIcon::Small ), "Away", this, SLOT(setAway()) );
        idxa = insertItem( KGlobal::iconLoader()->loadIcon("user_xaway", KIcon::Small ), "Extended Away", this, SLOT(setExendedAway()) );
        idDND = insertItem( KGlobal::iconLoader()->loadIcon("user_dnd", KIcon::Small ), "Do Not Disturb", this, SLOT(setDND()) );

        connect( jabber, SIGNAL(changedStatus()), this, SLOT(connectionStatusChanged()) );
}

SetStatusMenu::~SetStatusMenu()
{

}

void SetStatusMenu::connectionStatusChanged()
{
        setItemChecked( idChat, false );
        setItemChecked( idNormal, false );
        setItemChecked( idAway, false );
        setItemChecked( idxa, false );
        setItemChecked( idDND, false );

        switch ( jabber->getShow() )
        {
         	case JabberCore::Chat:
		        setItemChecked( idChat, true );
                        break;
          	case JabberCore::Normal:
		        setItemChecked( idNormal, true );
                        break;
          	case JabberCore::Away:
		        setItemChecked( idAway, true );
                        break;
          	case JabberCore::ExtendedAway:
		        setItemChecked( idxa, true );
                        break;
          	case JabberCore::DND:
		        setItemChecked( idDND, true );
                        break;
        }
}

/***************************************************************************
			SetStatusCbo
***************************************************************************/
SetStatusCbo::SetStatusCbo( QWidget *parent, const char *name )
        : QComboBox( parent, name )
{
        insertItem( KGlobal::iconLoader()->loadIcon("user_chat", KIcon::Small ), "Available for Chat" );
        insertItem( KGlobal::iconLoader()->loadIcon("user_online", KIcon::Small ), "Normal" );
        insertItem( KGlobal::iconLoader()->loadIcon("user_away", KIcon::Small ), "Away" );
        insertItem( KGlobal::iconLoader()->loadIcon("user_xaway", KIcon::Small ), "Extended Away" );
        insertItem( KGlobal::iconLoader()->loadIcon("user_dnd", KIcon::Small ), "Do Not Disturb" );

        connect( jabber, SIGNAL(changedStatus()), this, SLOT(connectionStatusChanged()) );
        connect( this, SIGNAL(activated(int)), this, SLOT(selectionChanged()) );
}

void SetStatusCbo::connectionStatusChanged()
{
        switch ( jabber->getShow() )
        {
         	case JabberCore::Chat:
		        setCurrentItem( 0 );
                        break;
          	case JabberCore::Normal:
		        setCurrentItem( 1 );
                        break;
          	case JabberCore::Away:
		        setCurrentItem( 2 );
                        break;
          	case JabberCore::ExtendedAway:
		        setCurrentItem( 3 );
                        break;
          	case JabberCore::DND:
		        setCurrentItem( 4 );
                        break;
        }

}

void SetStatusCbo::selectionChanged()
{
        DlgSetStatus::setStatus( (JabberCore::StatusType)currentItem() );

        connectionStatusChanged();
}

