/***************************************************************************
                          konverse.cpp  -  description
                             -------------------
    begin                : Fri Oct  1 22:39:20 CDT 1999

    copyright            : (C) 1999 by Seth Hartbecke
    email                : gandalf@netins.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "konverse.h"
#include <setstatus.h>
#include <kaboutdata.h>

Konverse::Konverse(QWidget*parent,const char* name)
	:KDockWindow(parent,name)
{
	blinkTimer = new QTimer(this, "The timer");
	blinkTimer->stop();
	connect( blinkTimer, SIGNAL(timeout()), this, SLOT(blinkIcon()) );

	setFixedSize( 24, 24 );
	
	// Load a few icons...
	onlineIcon	= KGlobal::iconLoader()->loadIcon("konverse_online", KIcon::NoGroup );
	awayIcon 	= KGlobal::iconLoader()->loadIcon("konverse_away", KIcon::NoGroup );
	xawayIcon 	= KGlobal::iconLoader()->loadIcon("konverse_xaway", KIcon::NoGroup );
	dndIcon 	= KGlobal::iconLoader()->loadIcon("konverse_dnd", KIcon::NoGroup );
	chatIcon 	= KGlobal::iconLoader()->loadIcon("konverse_chat", KIcon::NoGroup );
	messageIcon 	= KGlobal::iconLoader()->loadIcon("new_message", KIcon::NoGroup );
	offLineIcon 	= KGlobal::iconLoader()->loadIcon("konverse_offline", KIcon::NoGroup );
	normalIcon	= offLineIcon;
	currentIcon 	= offLineIcon;

	displayPixmap();

	// This will alert the tool try icon when there are new unread messages
	connect( jabber->messageBin(), SIGNAL(currentMessageCount(int)), this, SLOT(updateNumberUnread(int)) );

	connect( jabber, SIGNAL(connected()),    this, SLOT(onlineStatusChanged()));
	connect( jabber, SIGNAL(disconnected()), this, SLOT(onlineStatusChanged()));
	connect( jabber, SIGNAL(changedStatus()), this, SLOT(connectionStatusChanged()));


	loginDialog = 0;
	// Load config file...see if we need to show the connect dialog.
 	KSimpleConfig *myConfig = new KSimpleConfig("konverserc");
	myConfig->setGroup("connection");

	if ( myConfig->readBoolEntry("auto_login", false) == false )
	{
		showConnectDialog();
	}
	else
	{
		// Tell the core to log us in
		jabber->connectToServer( myConfig->readEntry("server")
			, myConfig->readEntry("port", "5222").toInt()
			, myConfig->readEntry("login_id")
			, myConfig->readEntry("password")
			, myConfig->readEntry("nick")
		);
	}
	delete myConfig;

	/* This builds the popup menu */
	popup = new KPopupMenu(0, "popup");
	popup->insertTitle( "Konverse" );
	//popup -> setFont(QFont("Helvetica", 12));
	popup->insertItem( "Show &Roster", this, SLOT(showRosterList()) );
	userListMenu = new UserListMenu;
	userMenuID = popup->insertItem("User Information", userListMenu);
        statusMenuID = popup->insertItem( "&Set Status", new SetStatusMenu );
        otherIMSystemsID = popup->insertItem( "&Other IM Systems...", this, SLOT(showAgentsDialog()) );
	connectID = popup->insertItem( "&Connect...", this, SLOT(showConnectDialog()));
	disconnectID = popup->insertItem( "&Disconnect", jabber, SLOT(disconnect()));
	popup -> insertItem( KGlobal::iconLoader()->loadIcon("exit", KIcon::Small), "&Quit", this, SLOT(shutdown()));
	//popup -> insertSeparator();
	//popup -> insertItem(PixAbout, "About ", this, SLOT(showAbout()));
	//popup -> insertItem(PixHelp, "Help", this, SLOT(showHelp()));

	popup->setItemEnabled( disconnectID, false);
        popup->setItemEnabled( userMenuID, false );
        popup->setItemEnabled( statusMenuID, false );

	// Create the roster list
	rosterList = new RosterTree( 0, 0 );
}

Konverse::~Konverse()
{
	delete rosterList;
	if (loginDialog != 0)
	{
		delete loginDialog;
	}
}


void Konverse::displayPixmap()
{
	setPixmap(currentIcon);
}

void Konverse::blinkIcon()
{
	if (currentIconShown != 0)
	{
		currentIconShown = 0;
		currentIcon = messageIcon;
	}
	else
	{
		currentIconShown = 1;
		currentIcon = normalIcon;
	}
	displayPixmap();
}

void Konverse::updateNumberUnread(int numberUnread)
{
		if (numberUnread > 0)
		{
			blinkTimer->start(500);
		}
		else
		{
			blinkTimer->stop();
			currentIcon = normalIcon;
			displayPixmap();
		}
}

void Konverse::mouseDoubleClickEvent(QMouseEvent *)
{
	DlgChat *newChat;

	newChat = jabber->messageBin()->startChat();

	if (newChat != 0)
	{
		newChat->show();
	}
	else
	{
		toggleRosterList();
	}
}

void Konverse::onlineStatusChanged()
{
	if (jabber->isConnected())
	{
		if (loginDialog != 0)
			delete loginDialog;

		popup->setItemEnabled( connectID, false);
		popup->setItemEnabled( disconnectID, true);
                popup->setItemEnabled( userMenuID, true );
                popup->setItemEnabled( statusMenuID, true );
                popup->setItemEnabled( otherIMSystemsID, true );
	}
	else
	{
		popup->setItemEnabled( connectID,  true);
		popup->setItemEnabled( disconnectID, false);
                popup->setItemEnabled( userMenuID, false );
                popup->setItemEnabled( statusMenuID, false );
                popup->setItemEnabled( otherIMSystemsID, false );
	}

	setNormalIcon();
	currentIcon = normalIcon;
	displayPixmap();
}

void Konverse::connectionStatusChanged()
{
	setNormalIcon();
	currentIcon = normalIcon;
	displayPixmap();
}

void Konverse::setNormalIcon()
{
	if (jabber->isConnected())
		switch ( jabber->getShow() )
		{
			case JabberCore::Chat:
				normalIcon = chatIcon;
				break;
			case JabberCore::Away:
				normalIcon = awayIcon;
				break;
			case JabberCore::ExtendedAway:
				normalIcon = xawayIcon;
				break;
			case JabberCore::DND:
				normalIcon = dndIcon;
				break;
			default:
				normalIcon = onlineIcon;
		}
	else
		normalIcon = offLineIcon;
}

void Konverse::popupMenu()
{
	popup->popup(QCursor::pos());
}

void Konverse::mousePressEvent(QMouseEvent *event)
{
	if(event->button() == RightButton)
	{
		// popup the context menu
		popupMenu();
	}
}

void Konverse::shutdown()
{
	jabber->disconnect();

	kapp->quit();
}

void Konverse::showHelp()
{
   QMessageBox::about(0,   "Konverse help",
                           "Will be filled in later...\n\nsome html based help or something" );
}

void Konverse::showAbout()
{
   QMessageBox::about(0,   "About Konverse",
                            "Konverse v"VERSION"\n" );
}

void Konverse::showRosterList()
{
	rosterList->show();
}

void Konverse::toggleRosterList()
{
	if (rosterList->isVisible())
		rosterList->hide();
	else
		rosterList->show();
}

void Konverse::showConnectDialog()
{
	if (loginDialog == 0)
	{
		// Show the login dialog...it is not open so we need to make it.
		loginDialog = new DlgLogin();
		connect( loginDialog, SIGNAL(dlgClosed()), this, SLOT(connectDialogCosed()) );
		loginDialog->show();
	}
	else
		loginDialog->show();

}

void Konverse::connectDialogCosed()
{
	// The login dialog is informing us that it is about to delete
	// itself.
	loginDialog = 0;
}




































