/***************************************************************************
                          FILENAME  -  description
                             -------------------
    begin                : DATE
    copyright            : (C) YEAR by AUTHOR
    email                : EMAIL
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef DLGLOGIN_H
#define DLGLOGIN_H

#include <config.h>

#include <kapp.h>
#include <knuminput.h>
#include <kmessagebox.h>
#include <ksimpleconfig.h>

#include <qstring.h>
#include <qwidget.h>
#include <qtabdialog.h>
#include <qlayout.h>
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qpushbutton.h>

#include <jabbercore.h>
#include <xmlfile.h>


/**
  * This is the login dialog you see when the system starts.
  *
  * @author Seth Hartbecke
  * @short Login dialog
  */
class DlgLogin : public QDialog
{
   Q_OBJECT
public:
	DlgLogin(QWidget *parent=0, const char *name=0);
	~DlgLogin();

        /**
         * Call this method if you want a login dialog displayed.  This makes shure
         * that there is only one open.
         */
        static void showLogin();

protected slots:
	void savePasswordClicked();
	void autoConnectClicked();
	void connectPressed();
	void createAccountClicked();

signals:
	/* For when the login dialog closes */		
	void dlgClosed();
	
private:
        static DlgLogin *currentWindow;
	/* Saves the settings they typed */
	void saveDialogSettings();
	
	/* will notifiy other people we are about to close */
	void closeEvent(QCloseEvent *e);
	
	/* Checks to make sure everything is typed correctly */
	bool validateForm();

	QGridLayout *topLayout;
	QGridLayout *serverLayout;
	
	QLabel *lblLoginID;
	QLabel *lblPassword;
	QLabel *lblNick;
	QLabel *lblServer;
	QLabel *lblPort;
		
	QLineEdit *txtLoginID;
	QLineEdit *txtPassword;
	QLineEdit *txtNick;	
	QLineEdit *txtServer;
	QLineEdit *txtPort;
	
	QCheckBox *rememberPassword;
	QCheckBox *autoLogin;
	
	QPushButton *btnConnect;
	QPushButton *btnNewAccount;
		
	QGroupBox *serverGroupBox;
};

#endif



