/***************************************************************************
                          dlgchat.h  -  description
                             -------------------
    begin                : Sat Oct 2 1999
    copyright            : (C) 1999 by Seth Hartbecke
                               (C) 2000-2001 Jerome Lalande
    email                : gandalf@netins.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef DLGCHAT_H
#define DLGCHAT_H

#include <time.h>

#include <config.h>

#include <qwidget.h>
#include <qmultilinedit.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qsplitter.h>
#include <qdatetime.h>

#include <kmenubar.h>
#include <kpopupmenu.h>
#include <ktmainwindow.h>
#include <kpushbutton.h>

#include "conversationview.h"
#include "xmlnode.h"
#include <messagereciever.h>
#include <messagebin.h>


class User;
class UserPresence;
#include "jabbercore.h"
#include "jabberid.h"

#include "wrapedit.h"

class ConversationView;

/**
  * This is the chat dialog.
  * @author Seth Hartbecke
  * @author Jerome Lalande
*/
class DlgChat
        : public KMainWindow
        , public MessageReciever
{
Q_OBJECT
public:
	DlgChat(QWidget *parent=0, const char *name=0);
	~DlgChat();

	void newPacket(XMLNode *t);
        void setJID( JabberID &newTO );

private slots:
	void sendClicked();
	void closeClicked();
        void showPrefs();

        void presenceChanged(User *, UserPresence *);
        void myConnectionChanged();

private:
        QSplitter *_split;
	QWidget *centralWidget;
	ConversationView *conversation;
	WrapEdit *stuffToSay;
	KPushButton *btnSend;
	KPushButton *btnClose;
	QGridLayout *layout;
	QGridLayout *btnLayout;

        User *_otherGuy;
        KPopupMenu *_chat;

	void closeEvent(QCloseEvent *e);
};


#endif






















