/***************************************************************************
                          conversationview.cpp  -  description
                             -------------------
    begin                : Sat Oct 2 1999
    copyright            : (C) 1999 by Seth Hartbecke
    email                : gandalf@netins.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "conversationview.h"
#include <qmessagebox.h>
#include <kapp.h>
#include <qstylesheet.h>

char *ConversationView::colors[] = { "blue", "#7823c6",
                                "green", "#ff8c00", "navy",
                                "#ddb904", "\0" };

ConversationView::ConversationView(QWidget *parent, const char *name )
	: QTextBrowser(parent,name)
{
	_msgCounter = 0;
	_body = "<html><body bgcolor=\"white\">";
        setText( _body );
        _scrollTimer = new QTimer( this, "timer" );
        connect( _scrollTimer, SIGNAL(timeout()), this, SLOT(scroll()) );
        _currColor = -1;

        (void) new QStyleSheetItem( styleSheet(), "timestamp" );

        styleSheet()->item( "timestamp" )->setLogicalFontSizeStep( -1 );
        settingChanged( "chat:showtimestamp", jabber->prefs()->getValue( "chat:showtimestamp", "true" ) );

        connect( jabber->prefs(), SIGNAL(valueChanged(const QString &, const QString &)), this, SLOT(settingChanged(const QString &, const QString &)) );
}


void ConversationView::addLine( QDateTime &when, QString whatDidTheySay, QString saidBy, QString color)
{
 	QString textToAdd;
        QString txtWhen = KGlobal::locale()->formatDateTime( when );

        if ( color == "auto" )
        {
                if ( _nameColorXRef.contains( saidBy ) )
                        color = _nameColorXRef[ saidBy ];
                else
                {
                        _currColor++;

                        if ( colors[ _currColor ][0] == '\0' )
                                _currColor = 0;

                        color = colors[ _currColor ];
                        _nameColorXRef.insert( saidBy, color );
                }
        }

        if ( strncasecmp(whatDidTheySay, "/me ", 4) == 0)
        {
                /* we want to put this in the user's color as an
                   announcement like *** seth says hello
                */
                systemAnnouncement( when, "*** " + saidBy + whatDidTheySay.right( whatDidTheySay.length() - 3 ), color );

                return;
        }

        /* Create the HTML we are going to add */
        txtWhen.replace(  QRegExp(" "), "&nbsp;");
 	textToAdd = "<TABLE cellpadding=\"0\" cellspacing=\"0\" BORDER=0>";
        textToAdd += "<TR><td nowrap valign=\"top\"><timestamp>" + txtWhen + "</timestamp></td><TD nowrap valign=\"top\"><FONT COLOR=\"" + color + "\"><b>" + saidBy + "&nbsp;</B></FONT></TD>";
        textToAdd += "<TD>" + HTMLize( whatDidTheySay ) + "</TD></TR></TABLE>";


        setVScrollBarMode( AlwaysOn );
        addHTML( textToAdd );
        setVScrollBarMode( Auto );

}

void ConversationView::systemAnnouncement( QDateTime &when, QString announcement, QString color )
{
        QString txtWhen = KGlobal::locale()->formatDateTime( when );

        QString html;
        html = "<font size=\"-1\" nowrap>" + txtWhen + "</font>&nbsp;&nbsp;<font color=\"" + color + "\">" + HTMLize( announcement ) + "<br></font>";
        addHTML( html );
}

void ConversationView::addHTML( QString html )
{
        _body = "";

        _msgCounter++;
	QString theAnchor;
	theAnchor.sprintf("<A NAME=\"line_%d\">", _msgCounter);

        _body += theAnchor + html;

        QScrollBar *bar = verticalScrollBar();
        if ( bar->value() + 2 > bar->maxValue() )
                _scrollTimer->start( 100 );

        append( _body );

        /* Move the scrollbar */
	//QString anchorName;
	//anchorName.sprintf("line_%d", _msgCounter);
	//scrollToAnchor( anchorName );
}

QString ConversationView::HTMLize( QString text )
{
        // Convert what was passed so that it is goood,
        // clean HTML
        QString clean;
 	clean = XMLNode::escape(text);
 	clean.replace( QRegExp("\n"), "<BR>\n");
 	clean.replace( QRegExp("  "), "&nbsp;&nbsp;");
 	clean.replace( QRegExp("\t"), "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
 	clean.replace( QRegExp("&apos;"), "'");

        return clean;
}

void ConversationView::scroll()
{
        QScrollBar *bar = verticalScrollBar();

        if ( jabber->prefs()->getValue( "chat:smoothscroll", "true" ) == "true" )
        {
                // Scroll half way down what is left
                int amountLeft = bar->maxValue() - bar->value();
                int scrollTo;
                if ( amountLeft <= 1 )
                {
                        _scrollTimer->stop();
                        scrollTo = bar->maxValue();
                }
                else
                        scrollTo = ( amountLeft / 2 ) + bar->value();

                bar->setValue( scrollTo );
        }
        else
        {
                // Snap to the top of the next message
                bar->setValue( bar->maxValue() );
                QString anchorName;
                anchorName.sprintf("line_%d", _msgCounter);
                scrollToAnchor( anchorName );

                _scrollTimer->stop();
        }
}

void ConversationView::settingChanged( const QString &key, const QString &value )
{
        if ( key == "chat:showtimestamp" )
        {
                QString body = text();

                if ( value == "true" )
                        styleSheet()->item( "timestamp" )->setDisplayMode( QStyleSheetItem::DisplayBlock );
                else
                        styleSheet()->item( "timestamp" )->setDisplayMode( QStyleSheetItem::DisplayNone );

                setStyleSheet( styleSheet() );
                setText( body );
                _scrollTimer->start( 100 );
        }
}



