/***************************************************************************
                          io_internet.h  -  description
                             -------------------
    begin                : Thu Aug 16 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef IO_INTERNET_H
#define IO_INTERNET_H

/* Local */
#include "definitions.h"
#include "io_base.h"
#include "match_param.h"
#include "command.h"

/* Tabs */
#include "tabmanager.h"
#include "console.h"
#include "challenge_graph.h"
#include "tab_seeklist.h"

class KSocket;
class KProcess;
class resource;
class core;
class dlg_login;
class dlg_challenge;

#include <qfile.h>

/**
  *@author Troy Corbin Jr / Alexander Wels.
  */

struct MatchRecord
{
  int         knightsID;
  int         serverID;
  bool        observing;
  bool        examining;
  bool        finished;
};

const int READ_BUFFER_SIZE = 64 * 1024; /* 64k is max ip packet size */

const int LOGIN_STAGE_NAME = 1;
const int LOGIN_STAGE_PASSWORD = 2;
const int LOGIN_STAGE_LOGGED_IN = 3;

const unsigned int NORMAL_MODE = 1;
const unsigned int UPDATE_SOUGHT_MODE = 2;
const unsigned int NEW_GAME_MODE = 3;
const unsigned int OBSERVE_GAME_MODE = 4;
const unsigned int CHALLENGE_MODE = 5;
const unsigned int PARSE_MOVE_LIST_MODE = 6;

const unsigned int PARSE12_MODE_NEW = 1;
const unsigned int PARSE12_MODE_MOVE = 2;

typedef QMap<QWidget *, QWidget *> TabMap;

class io_internet : public io_base
{
  Q_OBJECT
  public:
                              io_internet(QWidget *parent = NULL, resource *Rsrc = NULL);
                              ~io_internet();

  public slots:
    virtual void              recvCMD(const Command& command);
    void                      readCommand(KSocket *);
    void                      sendUserName(void);
    void                      sendPassword(void);
    void                      send(const QString&);
    void                      nullifyChallenge( void );
    void                      acceptChallenge( void );
    void                      declineChallenge( void );
    void                      processSeekTimer( void );
    void                      connectToServer( void );
    void                      selfDestruct( void );
    void                      setUserInfo(QString userName, QString passWord);
  signals:
    virtual void              sendCMD(const Command& command);
    void                      setLastPrivateSource( const QString& );
    void                      setLastChannelSource( const QString& );

  protected:
    void                      parseLine(QString command);
    void                      parseLoginData(QString command);
    void                      writeToConsole(QString text, QString tag);
    void                      updateSoughtList(QString text);
    void                      parseStyle12(QString line, const unsigned int mode);
    void                      sendUserSettings(void);
    void                      parseMoveList(QString data);
    void                      sendEndOfGameCommand(QString line);
  private:

    dlg_login                 *loginDlg;
    dlg_challenge             *challenge;

    /* These are used to handle the automagic seek command */
    QTimer                    *seekTimer;
    
    /* These are used for the connection & logon */
    QFile                     *Log;
    KSocket                   *socket;
    KProcess                  *myTimeseal;
    struct serverResource     *myServer;
    int                       loginStage;
    unsigned int              parseMode;
    QString                   lastTag;
    int                       ficsMoveListNumber;
    QString                   lineBuffer;
    bool                      connected;
    QString                   userName;
    QString                   passWord;

    /* communication with the server */
    QStringList               command_list; /* this is a temp buffer while waiting for the movelist */
    bool                      waiting_for_move_list;
    QMap<match_param *, int>  fics_ids;
    QMap<int, int>            fics_to_knights; /* maps fics id's to knights id's */
    TabMap                    myTabList; /* maintains the list of the tabs currently owned by this io_internet */
    QValueList<Command>       myCommandBuffer; /* this is a buffer for all the commands io_internet received while not connected to a server */
};

#endif
