/***************************************************************************
                           test.h - 
                         ---------------------------
    begin                : Fri Mar 16 2001
    copyright            : (C) 2001 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.1 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TEST_H
#define TEST_H

#include <kmainwindow.h>
#include <qwidget.h>
#include <qtextview.h>
#include <qtimer.h>
#include "kmmanager.h"

class NotifyChange;

class TestApp : public KMainWindow 
{
   friend class NotifyChange;

   Q_OBJECT
public:
   TestApp(const char * file, int id);
   void run();
   void init();
	 
public slots:
   void slotStart();
   void slotStop();
   void slotQuit();
   void slotRun();
   void slotUpdate(KObject obj);

private:
   QWidget *_view;
   QLabel *_text;
   KMManager _m;
   int _id;
   QTimer _timer;
};

class NotifyChange : public KNotifyChange 
{
public:
   NotifyChange(TestApp *app) : _app(app) {}
   virtual ~NotifyChange() {}
   virtual void operator()(const KObject obj) const;
private:
   TestApp *_app;
};

#endif

/* Local Variables: */
/* mode: c++ */
/* End: */
