/***************************************************************************
                          ktransferkioimpl.h  -  description
                             -------------------
    begin                : Sun Nov 5 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.9 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KTRANSFERKIOIMPL_H
#define KTRANSFERKIOIMPL_H

#include <kio/job.h>
#include "ktransferimpl.h"

#include <kio/global.h>

/**
 * @short Concrete implementation of transfer based on @ref KIO::job.
 *
 * @author Sergio Moretti
 *
 * @version $Id: ktransferkioimpl.h,v 1.9 2001/04/02 20:38:51 sergio Exp $
 */

class KTransferKioImpl : public KTransferImpl  
{
   Q_OBJECT
  
   friend class KTransferKio;
   friend class KObject;

public: 
   ~KTransferKioImpl();

   /** get the temporary file */
   virtual KURL getTempFile(const KURL &rmt, const KURL &lcl) const;

   virtual bool isProtocolSupported(const QString &proto) const;

   // config

   bool getDisableCookie() const;
   void setDisableCookie(bool v);
   bool getDisableCache() const;
   void setDisableCache(bool v);

protected:
   /** create empty transfer */
   KTransferKioImpl(int type);

   /** clone operation */
   virtual KObjectImpl* clone() const;

   virtual void loadData();

   const KTransferKioImpl * global() const;

   /** start a new job
    * @param offset offset for source, if 0 use the local offset
    * @param resumeOrAbort true to abort unresumable transfer
    */
   void startJob(unsigned long offset, bool resumeOrAbort);

   // define abstract methods
   virtual bool processStart();

   virtual bool processKill();

   virtual void processCheckResumeBegin();

   virtual void processCheckResumeEnd();
   
protected slots:
   void slotResult(KIO::Job*);

   //void slotConnected(KIO::Job*);

   void slotTotalSize(KIO::Job*, unsigned long size);

   void slotProcessedSize(KIO::Job*, unsigned long size);

   void slotInfoMessage(KIO::Job*, const QString &msg);

   void slotRetryTimeout();

   void slotConnect();

   void slotDownload();

   void slotCanResume(bool canResume);

private:
   KIO::SimpleJob *_job;
   bool _startDownload;
   QTimer _waitRetry;
   /** partial saved for restoring from checkResume */
   int _oldPartial;

   // config
   bool _cfg_disableCookie;
   bool _cfg_disableCache;
};

/**
 * @short Job to implement a transfer, borrowed from KIO::FileCopyJob
 *
 * @author Sergio Moretti
 *
 * @version $Id: ktransferkioimpl.h,v 1.9 2001/04/02 20:38:51 sergio Exp $
 */

class KTransferJob : public KIO::SimpleJob 
{
   Q_OBJECT

public:
   KTransferJob(const KURL &src, const KURL &dest, unsigned long srcOffset, 
		bool resumeOrAbort, bool disableCookie, bool disableCache);
   ~KTransferJob();

   //static KIO::SlaveManagerGlobal * managerInstance();

protected:
   void connectSubjob(KIO::SimpleJob * job );

protected slots:
   void slotData(KIO::Job*, const QByteArray &data);

   void slotDataReq(KIO::Job*, QByteArray &data);

   void slotCanResume(KIO::Job *job, unsigned long offset);

   void slotTotalSize(KIO::Job*, unsigned long size);

   void slotProcessedSize(KIO::Job*, unsigned long size);

   void slotPercent(KIO::Job*, unsigned long pct);

   void slotResult(KIO::Job *job);

   //void slotNeedConfiguration(KIO::Job *job, const KIO::MetaData &data);

signals:
   void sigConnect();

   void sigDownload();

   void sigCanResume(bool);

private:
   KURL _src, _dest;
   bool _canResume,_resumeAnswerSent, _resumeOrAbort, _disableCookie, 
      _disableCache;
   unsigned long _srcOffset, _totalSize;
   KIO::TransferJob *_getJob, *_putJob;
   QByteArray _buffer;

   static int _cnt;
   //static KIO::SlaveManagerGlobal *_managerInstance;
};

#endif

/* Local Variables: */
/* mode: c++ */
/* End: */
