/***************************************************************************
                          ktmanagerimpl.cpp  -  description
                             -------------------
    begin                : Tue Oct 17 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.17 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kdebug.h>
#include <qdir.h>
#include <qtextstream.h>
#include <kapp.h>
#include "utils.h"
#include "krootcontainerimpl.h"
#include "kfactoryimpl.h"
#include "ktransferimpl.h"
#include "ktmanagerimpl.h"


const char KTManagerImpl::DOCID[] = "TManager";
const char KTManagerImpl::DOCTYPE[] = "<!DOCTYPE TManager >";


KTManagerImpl::KTManagerImpl(int type) 
   : KContainerImpl(type), _title(), _cfg_logFile("-")
{
}

KTManagerImpl::~KTManagerImpl()
{
   //kdDebug(D_INI) << name() << ": TManager destroy" << endl;
}

const KTManagerImpl * KTManagerImpl::global() const 
{ 
   return dynamic_cast<const KTManagerImpl*>(KObjectImpl::global()); 
}

KTransferImpl * KTManagerImpl::itemNew(int type, const KURL &rmt, 
				       const KURL &lcl) 
{
   QString docId = KFactoryImpl::factory()->docId(type);
   int objId = root()->assignId();
   QString objStrId = 
      QString("%1-%2").arg(KFactoryImpl::factory()->typeStr(type)).arg(objId);
   kdDebug(D_INI) << name() << ": item new " << objStrId << endl;
   QDomElement e = root()->findDefault(type)->dom().cloneNode(false).toElement();
   kdFatal(e.isNull(), D_INI) << name() << ": default null for Transfer" << endl;
   domItems().appendChild(e);
   e.setAttribute("Id", objId);
   e.setAttribute("Name", objStrId);
   //e.setAttribute("Type", QString::number(type));
   e.setAttribute("Remote", rmt.url());
   e.setAttribute("Local", lcl.path());
   return dynamic_cast<KTransferImpl*>(itemLoad(e));
}

void KTManagerImpl::itemRemove(KObjectImpl *obj) 
{
   KTransferImpl *t = dynamic_cast<KTransferImpl*>(obj);
   if (t->isRunning())
      t->kill();
   //FIXME!!!
   while (t->isRunning()) 
      kapp->processEvents();
   KContainerImpl::itemRemove(t);
}

bool KTManagerImpl::isItemInsertable(const KObjectImpl *item) 
{
   const KTransferImpl * t = dynamic_cast<const KTransferImpl*>(item);
   QFileInfo file(t->local().path());
   if (!t->isProtocolSupported(t->remote().protocol()) || file.isDir())
   {
      kdWarning(D_RUN) << name() << ": item " << t->name() << " rejected : protocol unsupported" << endl;
      return false;
   }
   QString filepath = file.absFilePath();
   file.setFile(t->tmp().path());
   if (file.isDir()) 
   {
      kdWarning(D_RUN) << name() << ": item " << t->name() << " rejected : tmp " << file.absFilePath() << " is a directory" << endl;
      return false;
   }
   for (Iterator it(*this); it.current(); ++it)
   {
      KTransferImpl *tt = dynamic_cast<KTransferImpl*>(it.current());
      if (tt->remote() == t->remote() || tt->local().path() == filepath)
      {
	 kdWarning(D_RUN) << name() << ": item " << t->name() << " rejected : rmt or local in use" << endl;
	 return false;
      }
   }
   return true;
}

void KTManagerImpl::loadData() 
{
   // item type hardcoded, select it using object type
   dom().setAttribute("ItemType", TYP_FILE_TRANSFER_T);
   KContainerImpl::loadData();
   kdDebug(D_INI) << name() << ": TManager loadData" << endl;
   if (!dom().hasAttribute("DefaultType"))
   {
      setPriority(PRM_NORMAL); // override object's priority at first creation
      setAutoDownload(false);
      setMaxBandwidth(0);
      setMinBandwidth(0);
      setMaxConnection(3);
      setAutoRemove(false);
      setWorkingDir(QDir::homeDirPath());
      setDownloadDir(QDir::homeDirPath());
      setLogFile("");
      setDefaultType(itemType()+1);
   }
   // state
   _title = dom().attribute("Title", "");
   setGlobal(false); // override default global
   // config
   _cfg_autoDownload = dom().attribute("AutomaticDownload", 
				       QString::number(false)).toInt();
   _cfg_maxBandwidth = dom().attribute("MaxBandwidth", 
				       QString::number(0)).toInt();
   _cfg_minBandwidth = dom().attribute("MinBandwidth", 
				       QString::number(0)).toInt();
   _cfg_maxConnection = dom().attribute("MaxOpenConnection", 
					QString::number(3)).toInt();
   _cfg_autoRemove = dom().attribute("RemoveTransferCompleted",
				     QString::number(false)).toInt();
   _cfg_workingDir = dom().attribute("WorkingDirectory", QDir::homeDirPath());
   _cfg_downloadDir = dom().attribute("DownloadDirectory", QDir::homeDirPath());
   _cfg_logFile = dom().attribute("LogFile", "");
   _cfg_defaultType = dom().attribute("DefaultType", 
				      QString::number(itemType()+1)).toInt();
   _bandwidth = 0;
   _mediumBandwidth = 0;
}

/*
KManager * KTManagerImpl::manager() const 
{ 
  return dynamic_cast<KManager*>(parent()); 
}
*/

void KTManagerImpl::runPeriodically()
{
   //kdDebug(KMAGO_CONFIG) << name() << " UPDATE" << endl;
   if (getAutoRemove())
      scanForRemoving();
   KContainerImpl::runPeriodically();
}

void KTManagerImpl::scanForRemoving()
{
   for (Iterator it(*this); it.current(); ++it)
   {
      KTransferImpl *t = dynamic_cast<KTransferImpl*>(it.current());
      //t->update(); //XXXXXXXXXXXXXX
      if (t->isComplete())
	 // remove complete transfer
	 itemRemove(t); //FIXME how removing an item changes iterator?
   }
}

KTransferImpl* KTManagerImpl::selectForRunning(bool dLock, bool &runInFuture)
{
   KTransferImpl *best = 0;
   if (((_mediumBandwidth != 0 || _bandwidth != 0) && itemActiveCount() == 0)
       || (itemActiveCount() != 0))
   {
      setMod(MDI_BAND);
   }
   _bandwidth = 0;
   _mediumBandwidth = 0;
   // get the bandwidth and the open transfers count, candidate for running
   for (Iterator it(*this); it.current(); ++it)
   {
      KTransferImpl *t = dynamic_cast<KTransferImpl*>(it.current());
      if (t->isRunning())
      {
	 _bandwidth += t->bandwidth();
	 _mediumBandwidth += t->mediumBandwidth();
	 // check for stopping
	 if (getAutoDownload() && getMinBandwidth() 
	     && t->mediumBandwidth() < getMinBandwidth()
	     && t->startTime().elapsed() > 30000) //FIXME find a place for this
	    t->stop();
	 runInFuture = true;
      } 
      else 
      {
	 if (t->isRunnable(getAutoDownload()) 
	     && (best == 0 || t->cmpPriority(best) == 1))
	    best = t;
	 runInFuture |= t->isRunnableInFuture(dLock, getAutoDownload());
      }
   }
   //debug("band=%ld, mband=%ld, conn=%d", _bandwidth, _mediumBandwidth, _activeCount);
   if (best == 0 
       || (getMaxConnection() && itemActiveCount() >= getMaxConnection())
       || (getMaxBandwidth() && bandwidth() > getMaxBandwidth()))
      return 0;
   //kdDebug(D_RUN) << name() << ": start transfer: " << best->name() <<endl;
   return best;
}

//////////// state members

void KTManagerImpl::setTitle(const QString &t)
{
   if (_title != t)
   {
      _title = t;
      dom().setAttribute("Title", _title);
      setMod(MDI_TMN_TITLE);
      root()->setModified();
   }      
}

/////////// config entries

bool KTManagerImpl::getAutoDownload() const 
{
   return useGlobal() ? global()->getAutoDownload() : _cfg_autoDownload;
}

void KTManagerImpl::setAutoDownload(bool m) 
{
   if (m != getAutoDownload()) 
   {
      _cfg_autoDownload = m;
      if (m)
	 // reset state of transfers: killed to runnable
	 for (Iterator it(*this); it.current(); ++it)
	 {
	    KTransferImpl *t = dynamic_cast<KTransferImpl*>(it.current());
	    if (t->state() == TRN_END_KILL) 
	    {
	       t->setState(TRN_READY);
	       t->emitMod();
	    }
	 }
      dom().setAttribute("AutomaticDownload", _cfg_autoDownload);
      setMod(MDI_TMN_CFG_AUTODWNL);
      root()->setModified();
   }
}

bool KTManagerImpl::getAutoRemove() const 
{
   return useGlobal() ? global()->getAutoRemove() :_cfg_autoRemove;
}

void KTManagerImpl::setAutoRemove(bool v)
{
   if (_cfg_autoRemove != v)
   {
      _cfg_autoRemove = v;
      dom().setAttribute("RemoveTransferCompleted", _cfg_autoRemove);
      setMod(MDI_TMN_CFG_AUTOREMOVE);
      root()->setModified();
   }
}

int KTManagerImpl::getMaxConnection() const 
{
   return useGlobal() ? global()->getMaxConnection() :_cfg_maxConnection;
}

void KTManagerImpl::setMaxConnection(int v)
{
   if (_cfg_maxConnection != v)
   {
      _cfg_maxConnection = v;
      dom().setAttribute("MaxOpenConnection", _cfg_maxConnection);
      setMod(MDI_CFG_MAXCONN);
      root()->setModified();
   }
}

int KTManagerImpl::getMaxBandwidth() const 
{
   return useGlobal() ? global()->getMaxBandwidth() :_cfg_maxBandwidth;
}

void KTManagerImpl::setMaxBandwidth(int v)
{
   if (_cfg_maxBandwidth != v)
   {
      _cfg_maxBandwidth = v;
      dom().setAttribute("MaxBandwidth", _cfg_maxBandwidth);
      setMod(MDI_CFG_MAXBAND);
      root()->setModified();
   }
}

int KTManagerImpl::getMinBandwidth() const 
{
   return useGlobal() ? global()->getMinBandwidth() :_cfg_minBandwidth;
}

void KTManagerImpl::setMinBandwidth(int v)
{
   if (_cfg_minBandwidth != v)
   {
      _cfg_minBandwidth = v;
      dom().setAttribute("MinBandwidth", _cfg_minBandwidth);
      setMod(MDI_CFG_MINBAND);
      root()->setModified();
   }
}

QString KTManagerImpl::getLogFile() const 
{
   return useGlobal() ? global()->getLogFile() :_cfg_logFile;
}

void KTManagerImpl::setLogFile(const QString &v)
{
   if (_cfg_logFile != v)
   {
      _cfg_logFile = v; 
      dom().setAttribute("LogFile", _cfg_logFile);
      setMod(MDI_TMN_CFG_LOGFILE);
      root()->setModified();
   }
}

const QDir & KTManagerImpl::getWorkingDir() const 
{
   return useGlobal() ? global()->getWorkingDir() :_cfg_workingDir;
}

void KTManagerImpl::setWorkingDir(const QString &d) 
{ 
   if (_cfg_workingDir.absPath() != d)
   {
      _cfg_workingDir = d;
      dom().setAttribute("WorkingDirectory", _cfg_workingDir.absPath());
      setMod(MDI_CFG_WORKINGDIR); 
   }
}

const QDir & KTManagerImpl::getDownloadDir() const 
{
   return useGlobal() ? global()->getDownloadDir() :_cfg_downloadDir;
}

void KTManagerImpl::setDownloadDir(const QDir &v)
{
   if (_cfg_downloadDir != v)
   {
      _cfg_downloadDir = v; 
      dom().setAttribute("DownloadDirectory", _cfg_downloadDir.absPath());
      setMod(MDI_TMN_CFG_DWNLDIR);
      root()->setModified();
   }
}

int KTManagerImpl::getDefaultType() const 
{
   return useGlobal() ? global()->getDefaultType() : _cfg_defaultType;
}

void KTManagerImpl::setDefaultType(int v)
{
   if (_cfg_defaultType != v)
   {
      _cfg_defaultType = v; 
      dom().setAttribute("DefaultType", _cfg_defaultType);
      setMod(MDI_TMN_CFG_DFLTYPE);
      root()->setModified();
   }
}

#include "ktmanagerimpl.moc"
