/***************************************************************************
                          ktmanager.h  -  description
                             -------------------
    begin                : Tue Oct 17 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.11 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KTMANAGER_H
#define KTMANAGER_H

#include <qdir.h>
#include <kurl.h>
#include "kcontainer.h"

class KTManagerImpl;
class KMManager;
class KTransfer;

/**
 * @short Bridge class for @ref KTManagerImpl object.
 * 
 * @author Sergio Moretti
 *
 * @version $Id: ktmanager.h,v 1.11 2001/03/05 20:59:22 sergio Exp $
 */

class KTManager : public KContainer 
{
   friend class KObject;
   friend class KMManager;

public: 
   typedef QValueList<KTManager> List;

   KTManager() {}
   static KTManager null() { return KTManager(); }

   /** document name */
   static const char * docId();
   /** dom document type */
   static const char * docType();

   /** returns the manager's title */
   QString title() const;
   /** sets the title of the manager */
   void setTitle(const QString &t) const;
   /** get the current bandwidth */
   int bandwidth() const;
   int mediumBandwidth() const;
   /** send a message to display */
   //void message(const QString &msg) = 0;
   /** add a new transfer wget type object */
   KTransfer itemNew(int type, const KURL &rmt, const KURL &lcl) const;
   // attribute management
   /** return autodownload mode */
   bool getAutoDownload() const;
   /** enable/disable autodownload */
   void setAutoDownload(bool m=true) const;
   bool getAutoRemove() const;
   void setAutoRemove(bool r) const;
   int getMaxConnection() const;
   void setMaxConnection(int c) const;
   int getMaxBandwidth() const;
   void setMaxBandwidth(int b) const;
   int getMinBandwidth() const;
   void setMinBandwidth(int b) const;
   const QDir & getDownloadDir() const;
   void setDownloadDir(const QString &d) const;
   const QDir & getWorkingDir() const;
   void setWorkingDir(const QString &d) const;
   int getDefaultType() const;
   void setDefaultType(int t) const;
   QString getLogFile() const;
   void setLogFile(const QString &f) const;

protected:
   KTManager(KTManagerImpl *impl);
   KTManagerImpl * impl() const;
};

#endif

/* Local Variables: */
/* mode: c++ */
/* End: */
