/***************************************************************************
                          kobject.cpp  -  description
                             -------------------
    begin                : Fri Oct 20 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.10 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kdebug.h>
#include "kfactoryimpl.h"
#include "kobjectimpl.h"
#include "kcontainerimpl.h"
#include "krootcontainerimpl.h"
#include "ktransferimpl.h"
#include "ktmanagerimpl.h"
#include "kmmanagerimpl.h"

#include "kcntiterator.h"
#include "krootcontainer.h"
#include "kcontainer.h"
#include "ktransfer.h"
#include "ktmanager.h"
#include "kmmanager.h"
#include "kobject.h"

#ifdef ENABLE_WGET
#include "ktransferwgetimpl.h"
#include "ktransferwget.h"
#endif

#ifdef ENABLE_KIO
#include "ktransferkioimpl.h"
#include "ktransferkio.h"
#endif

KObject::KObject(KObjectImpl *impl) : _impl(impl) 
{
}

int KObject::id() const 
{ 
   return impl()->id(); 
}

const char * KObject::name() const 
{
   return impl()->name(); 
}

int KObject::type() const 
{
   return impl()->type(); 
}

QDomElement KObject::dom() const 
{
   return impl()->dom();
}

const ModFlags & KObject::modState() const 
{ 
   return impl()->modState(); 
}

bool KObject::useGlobal() const 
{
   return impl()->useGlobal();
}

bool KObject::getGlobal() const 
{
   return impl()->getGlobal();
}

void KObject::setGlobal(bool g) const
{
   impl()->setGlobal(g);
}

bool KObject::isGlobal() const 
{
   return impl()->isGlobal();
}

bool KObject::isDefault() const 
{
   return impl()->isDefault();
}

bool KObject::isNormal() const 
{
   return impl()->isNormal();
}

bool KObject::isRoot() const
{
   return impl()->isRoot();
}

void KObject::start() const
{
   impl()->start();
}
 
void KObject::kill(bool wait) const
{
   impl()->kill(wait);
}

bool KObject::isRunning() const 
{
   return impl()->isRunning();
}

bool KObject::isMod(ModIndex p) const 
{
   return impl()->isMod(p);
}

bool KObject::isMods(const ModFlags &f) const 
{
   return impl()->isMods(f);
}

void KObject::resetMods() const
{
   return impl()->resetMods();
}

void KObject::emitMod() const
{
   return impl()->emitMod();
}

QString KObject::modString() const
{
   return impl()->modString();
}

void KObject::deleteInstance() 
{
   delete static_cast<KObjectImpl*>(_impl);
   //_impl = QGuardedPtr<KObjectImpl>();
}

void KObject::runPeriodically() const
{
   impl()->runPeriodically(); 
}

bool KObject::connect(const char *signal, const QObject *receiver, 
		      const char *member) const 
{
   return impl()->connect(impl(), signal, receiver, member);
}

KContainer KObject::container() const 
{ 
   return KContainer(impl()->container()); 
}

KRootContainer KObject::root() const 
{ 
   return KRootContainer(impl()->root()); 
}

int KObject::priority() const 
{
   return impl()->priority();
}

int KObject::prioritySum() const 
{
   return impl()->prioritySum();
}

void KObject::setPriority(int p) const
{
   impl()->setPriority(p);
}

QString KObject::message() const 
{
   return impl()->message();
}
 
void KObject::setMessage(const QString &msg) const
{
   impl()->setMessage(msg);
}

QObject * KObject::toQObject() const 
{
   return static_cast<QObject*>(impl());
}

KRootContainer KObject::toRootContainer() const 
{
   return KRootContainer(dynamic_cast<KRootContainerImpl*>(impl())); 
}

KContainer KObject::toContainer() const 
{
   return KContainer(dynamic_cast<KContainerImpl*>(impl())); 
}

KTransfer KObject::toTransfer() const 
{
   return KTransfer(dynamic_cast<KTransferImpl*>(impl())); 
}

KTManager KObject::toTManager() const 
{
   kdFatal(dynamic_cast<KTManagerImpl*>(impl()) != impl()) << "toTManager null" << endl;
   return KTManager(dynamic_cast<KTManagerImpl*>(impl())); 
}

KMManager KObject::toMManager() const 
{
   return KMManager(dynamic_cast<KMManagerImpl*>(impl())); 
}

#ifdef ENABLE_WGET
KTransferWget KObject::toTransferWget() const 
{
   return KTransferWget(dynamic_cast<KTransferWgetImpl*>(impl())); 
}
#endif

#ifdef ENABLE_KIO
KTransferKio KObject::toTransferKio() const 
{
   return KTransferKio(dynamic_cast<KTransferKioImpl*>(impl())); 
}
#endif

QString KObject::typeStr(int type) 
{
   return KFactoryImpl::factory()->typeStr(type);
}

void KObject::initFactory() 
{
   // init once
   if (KFactoryImpl::factory()->prototype(TYP_TMANAGER) != 0)
      return;
   //KFactoryImpl::factory()->addPrototype(TYP_MMANAGER, new KMManagerImpl(TYP_MMANAGER), "MManager");
   KFactoryImpl::factory()->addPrototype(TYP_TMANAGER,
					 new KTManagerImpl(TYP_TMANAGER), 
					 "TManager");
#ifdef ENABLE_WGET
   KFactoryImpl::factory()->addPrototype(TYP_TWGET,
					 new KTransferWgetImpl(TYP_TWGET), 
					 "Wget");
#endif
#ifdef ENABLE_KIO
   KFactoryImpl::factory()->addPrototype(TYP_TKIO,
					 new KTransferKioImpl(TYP_TKIO), 
					 "Kio");
#endif
}

void KObject::deleteFactory()
{
   delete KFactoryImpl::factory();
}
