/***************************************************************************
                          kmmanager.h  -  description
                             -------------------
    begin                : Wed Oct 18 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.9 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMMANAGER_H
#define KMMANAGER_H

#include "krootcontainer.h"
#include "knotifychange.h"

class KMManagerImpl;
class KTManager;

/**
 * @short Bridge class for @ref KMManagerImpl object.
 *
 * @author Sergio Moretti
 *
 * @version $Id: kmmanager.h,v 1.9 2001/03/22 09:26:52 sergio Exp $
 */

class KMManager : public KRootContainer 
{
   friend class KObject;

public: 
   KMManager() {}

   /** document name */
   static QString docId();
   /** dom document type */
   static QString docType();
   /** null value */
   static KMManager null() { return KMManager(); }

   /** static function to create a manager */
   static KMManager managerLoad(const QString &fileName, bool createMode,
				KNotifyChange *cb);
   /** new item */
   KTManager itemNew(const QString &title) const;
   /** bandwidth */
   int bandwidth() const;
   /** medium bandwidth */
   int mediumBandwidth() const;
   /** download locking */
   bool downloadLock() const;
   void setDownloadLock(bool v) const;
   bool isIdle() const;
   void setIdle(bool l);
   void startPendingTransfer();

   // CONFIG

   int getMaxConnection() const;
   void setMaxConnection(int c) const;
   int getMaxBandwidth() const;
   void setMaxBandwidth(int b) const;

protected:
   KMManager(KMManagerImpl *impl);
   KMManagerImpl * impl() const;
};

#endif

/* Local Variables: */
/* mode: c++ */
/* End: */
