/***************************************************************************
                           kdlgtransferprogress.h -
                         ---------------------------
    begin                : Tue Apr  3 2001
    copyright            : (C) 2001 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.1 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KDLGTRANSFERPROGRESS_H
#define KDLGTRANSFERPROGRESS_H

#include <qwidget.h>
#include <qstring.h>
#include <ksystemtray.h>

class KTransfer;

/**
 * @short Window to view the transfer download progress.
 *
 * @author Sergio Moretti
 *
 * @version $Id: kdlgtransferprogress.h,v 1.1 2001/04/04 18:06:04 sergio Exp $
 */

class KDlgTransferProgress : public QWidget
{
   Q_OBJECT
public:
   KDlgTransferProgress(KTransfer t, bool viewTray, QWidget *parent,
			const char *name=0);
   ~KDlgTransferProgress();

protected:
   void initDialog(KTransfer t);

protected slots:
   void slotUpdate(int p);
   void slotStart();
   void slotStop();

signals:
   void sigClose(int id);

protected:
   KTransfer t;
   int _id;
   KSystemTray *_tray;

private:

};

#endif

/* Local Variables: */
/* mode: c++ */
/* End: */
