/***************************************************************************
                           kdlgtransferkio1.cpp - 
                         ---------------------------
    begin                : Mon Mar  5 2001
    copyright            : (C) 2001 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.2 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#ifdef ENABLE_KIO

#include <klocale.h>
#include <qtooltip.h>
#include <qlayout.h>
#include <qgroupbox.h>
#include "ktransferkio.h"
#include "kdlgtransferkio1.h"

KDlgTransferKio1::KDlgTransferKio1(KTransferKio tr, QWidget *parent, 
				   const char *name) 
   : QWidget(parent,name), t(tr)
{
   initDialog();
   slotSetGlobal(t.useGlobal());
}

KDlgTransferKio1::~KDlgTransferKio1()
{
}

void KDlgTransferKio1::init()
{
   cbtCookie->setChecked(t.getDisableCookie());
   cbtCache->setChecked(t.getDisableCache());
}

void  KDlgTransferKio1::initDialog()
{
   QBoxLayout *l = new QVBoxLayout(this, 8);

   QGroupBox *gbox = new QGroupBox(1, Horizontal, i18n("General"), this, "GB1");
   l->addWidget(gbox);

   cbtCookie = new QCheckBox(i18n("Disable Cookie"), gbox, "cbtCookie");
   QToolTip::add(cbtCookie, i18n("Enable/Disable cookie management"));

   cbtCache = new QCheckBox(i18n("Disable HTTP Cache"), gbox, "cbtCache");
   QToolTip::add(cbtCookie, i18n("Enable/Disable HTTP Cache"));

   adjustSize();
   setMinimumSize(size());
}

void KDlgTransferKio1::accept()
{
   t.setDisableCookie(cbtCookie->isChecked());
   t.setDisableCache(cbtCache->isChecked());
}

void KDlgTransferKio1::reject()
{
}

bool KDlgTransferKio1::isAcceptable()
{
   return true;
}

void KDlgTransferKio1::slotSetGlobal(bool on) 
{
   cbtCookie->setEnabled(!on);
   cbtCache->setEnabled(!on);
   init();
}

#include "kdlgtransferkio1.moc"

#endif

/* Local Variables: */
/* mode: c++ */
/* End: */
