/***************************************************************************
                          kdlgmanager.cpp  -  description
                             -------------------
    begin                : Mon Sep 18 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.12 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qvbox.h>
#include "kdlgtransfer1.h"
#include "kdlgmanagerset.h"
#include "kdlgmanager1.h"
#include "kdlgmanager.h"
#ifdef ENABLE_WGET
#include "ktransferwget.h"
#include "kdlgtransferwget1.h"
#endif
#ifdef ENABLE_KIO
#include "ktransferkio.h"
#include "kdlgtransferkio1.h"
#endif

KDlgManager::KDlgManager(KTManager mngr, QWidget *parent, 
			 const char *name ) 
   : KDialogBase(Tabbed, i18n("Manager Options"), Ok|Cancel, Ok, parent, name, 
		 true), m(mngr) 
{
   init();
}

KDlgManager::~KDlgManager()
{
}

void KDlgManager::init() 
{
   //resize(340, 380);
   //setMinimumSize(340, 380);

   QVBox *page = addVBoxPage(i18n("Settings"));
   _ps = new KDlgManagerSet(m, page, "KDlgManagerSet");

   page = addVBoxPage(i18n("Manager"));
   _p1 = new KDlgManager1(m, page, "KDlgManager1");

   KTransfer t;

#ifdef ENABLE_WGET
   page = addVBoxPage(i18n("Wget 1"));
   t = m.findGlobal(TYP_TWGET).toTransferWget();
   _p2 = new KDlgTransfer1(t, page, "KDlgTransfer1-Wget");
 
   page = addVBoxPage(i18n("Wget 2"));
   _p3 = new 
      KDlgTransferWget1(t.toTransferWget(), page, "KDlgTransferWget1");
   connect(_p2, SIGNAL(signalGlobalChange(bool)), 
	   _p3, SLOT(slotSetGlobal(bool)));
#endif
	
#ifdef ENABLE_KIO
   page = addVBoxPage(i18n("Kio 1"));
   t = m.findGlobal(TYP_TKIO).toTransferKio();
   _p4 = new KDlgTransfer1(t, page, "KDlgTransfer1-Kio");

   page = addVBoxPage(i18n("Kio 2"));
   _p5 = new 
      KDlgTransferKio1(t.toTransferKio(), page, "KDlgTransferKio1");
   connect(_p4, SIGNAL(signalGlobalChange(bool)), 
	   _p5, SLOT(slotSetGlobal(bool)));
#endif
}

void KDlgManager::slotOk() 
{
   if (!_ps->isAcceptable()
       || !_p1->isAcceptable()
#ifdef ENABLE_WGET
       || !_p2->isAcceptable() || !_p3->isAcceptable()
#endif
#ifdef ENABLE_KIO
       || !_p4->isAcceptable() || !_p5->isAcceptable()
#endif
      )
      return;

   _ps->accept();
   _p1->accept();
#ifdef ENABLE_WGET
   _p2->accept();
   _p3->accept();
   m.findGlobal(TYP_TWGET).emitMod();  
#endif
#ifdef ENABLE_KIO
   _p4->accept();
   _p5->accept();
   m.findGlobal(TYP_TKIO).emitMod();
#endif
   m.emitMod();
   //_doc->setModified(); //FIXME!! inutile, stato cambiato dai proto
   //_doc->setCurrentTransfer(0); // FIXME!! solo x update bottone autoResume
   KDialogBase::slotOk();
}

void KDlgManager::slotCancel()
{
   _ps->reject();
   _p1->reject();
#ifdef ENABLE_WGET
   _p2->reject();
   _p3->reject();
   m.findGlobal(TYP_TWGET).emitMod();  
#endif
#ifdef ENABLE_KIO
   _p4->reject();
   _p5->reject();
   m.findGlobal(TYP_TKIO).emitMod();
#endif
   KDialogBase::slotCancel();
}

#include "kdlgmanager.moc"
