/***************************************************************************
                          boldlistboxitem.cpp  -  description
                             -------------------
    begin                : ??? ??? 12 2003
    copyright            : (C) 2003 by Leonid Zeitlin
    email                : lz@europe.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "boldlistboxitem.h"
#include <qpainter.h>

BoldListBoxItem::BoldListBoxItem(QListBox *listbox, const QPixmap &pix,
  const QString &text, bool bold)
  : QListBoxPixmap(listbox, pix, text), m_bold(bold)
{
}

BoldListBoxItem::~BoldListBoxItem()
{
}

void BoldListBoxItem::paint(QPainter *painter)
{
	if (m_bold) {
		QFont font = painter->font();
		font.setBold(true);
		painter->setFont(font);
	}
	QListBoxPixmap::paint(painter);	
}
