/***************************************************************************
 *   Copyright (C) 2004, 2005 Thomas Nagy                                  *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qdragobject.h>
#include <qpainter.h>
#include <qwidgetstack.h>
#include <qtoolbutton.h>

#include <kstatusbar.h>
#include <kdebug.h>
#include <kglobal.h>
#include <ktip.h>
#include <kparts/part.h>
#include <kparts/partmanager.h>
#include <klineedit.h>
#include <kurl.h>
#include <kurldrag.h>
#include <kurlrequesterdlg.h>
#include <kconfig.h>
#include <kconfigdialog.h>
#include <kaboutdata.h>
#include <kfiledialog.h>
#include <kactionclasses.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kdeversion.h>
#include <kmenubar.h>
#include <kkeydialog.h>
#include <kmessagebox.h>
#include <ktabwidget.h>
#include <kedittoolbar.h>
#include <kstdaccel.h>
#include <kaction.h>
#include <kstdaction.h>

#include "settings.h"
#include "prefs-base.h"
#include "DTreeListView.h"
#include "KDissertPart.h"
#include "KDissertView.h"
#include "TextProperties.h"
#include "MiscProperties.h"
#include "KDissert.h"

KDissert::KDissert(QDomElement& dockConfig, KMdi::MdiMode mode)
	: KMdiMainFrm( 0, "KDissert", mode )
{
	resize( 800, 600 ); // start at 800x600 the first time

	setManagedDockPositionModeEnabled(true);
	setStandardMDIMenuEnabled(false);

	m_manager = new KParts::PartManager(this);
	connect(m_manager, SIGNAL(activePartChanged(KParts::Part*)),
			this, SLOT(createGUI(KParts::Part*)) );

	m_dockConfig = dockConfig;
	dockManager->setReadDockConfigMode(KDockManager::RestoreAllDockwidgets);

#if KDE_IS_VERSION(3, 3, 0)
	setToolviewStyle( KMdi::TextAndIcon );
	tabWidget()->setHoverCloseButton( false );
#endif

	if ( m_dockConfig.hasChildNodes() )
		readDockConfig(m_dockConfig);

	dockManager->finishReadDockConfig();
	setMenuForSDIModeSysButtons( menuBar() );
	setManagedDockPositionModeEnabled(true); 

	// accept dnd
	setAcceptDrops(true);

	// then, setup our actions
	setupActions();

	//createShellGUI( true );

	// and a status bar
	statusBar()->show();

	// apply the saved mainwindow settings, if any, and ask the mainwindow
	// to automatically save settings if changed: window size, toolbar
	// position, icon size, etc.
	setAutoSaveSettings();

	connect( this, SIGNAL( viewActivated( KMdiChildView * ) ),
			this, SLOT( currentChanged( KMdiChildView * ) ) );

	m_miscproperties = new MiscProperties(this, "misc_infos");
	m_miscproperties->setIcon( SmallIcon("attach") );
	m_miscproperties->setCaption( i18n("Attachments") );
	addToolWindow( m_miscproperties, KDockWidget::DockBottom, getMainDockWidget(), 20 );

	m_textproperties = new TextProperties(this, "properties");
	m_textproperties->setIcon( SmallIcon("pencil") );
	m_textproperties->setCaption( i18n("Item Text") );
	m_textpropertiestoolview = addToolWindow( m_textproperties, KDockWidget::DockBottom, getMainDockWidget(), 20 );

	//KDockWidget* widget = dynamic_cast<KDockWidget*>(m_textpropertiestoolview->wrapperWidget());
	//widget->setFocusProxy( m_textproperties );

	m_treeviewstack = new QWidgetStack(this, "treeview_stack");
	m_treeviewstack->setIcon( SmallIcon("kdissert") );
	m_treeviewstack->setCaption( i18n("Tree View") );
	m_frame = new QFrame(m_treeviewstack);
	m_treeviewstack->addWidget( m_frame );
	addToolWindow( m_treeviewstack, KDockWidget::DockLeft, getMainDockWidget(), 30 );

	QToolButton *but = new QToolButton(tabWidget());
	but->setIconSet(SmallIcon("tab_remove"));
	but->adjustSize();
	but->hide();
	connect(but, SIGNAL(clicked()), actionCollection()->action( "file_close" ), SIGNAL(activated()));
	tabWidget()->setCornerWidget(but, TopRight);

	//changeCaption(QString::null);
	showTipOnStart();
}

KDissert::~KDissert()
{
	writeDockConfig(m_dockConfig);
}

void KDissert::setupActions()
{
	setXMLFile("kdissertui.rc");

	KStdAction::openNew(this, SLOT(slotFileNew()), actionCollection());
	KStdAction::open(this, SLOT(slotFileOpen()), actionCollection());

	m_openRecentAction = KStdAction::openRecent(this, SLOT(openURL(const KURL&)), actionCollection());
	m_openRecentAction->setWhatsThis( i18n("Opens recently opened file.") );
	m_openRecentAction->loadEntries( kapp->config(), "RecentFiles" );

	KStdAction::tipOfDay( this, SLOT( showTip() ), actionCollection() 
			)->setWhatsThis(i18n("This shows useful tips on the use of this application."));

	KStdAction::close(this, SLOT(slotFileClose()), actionCollection());
	KStdAction::quit(this, SLOT(slotFileQuit()), actionCollection());

	m_toolbarAction = KStdAction::showToolbar(this, SLOT(optionsShowToolbar()), actionCollection());
	m_statusbarAction = KStdAction::showStatusbar(this, SLOT(optionsShowStatusbar()), actionCollection());

	KStdAction::keyBindings(this, SLOT(optionsConfigureKeys()), actionCollection());
	KStdAction::preferences(this, SLOT(optionsPreferences()), actionCollection());


	new KAction( i18n("Focus on the text panel"), "F2", this, SLOT(slotFocusOnTPanel()), actionCollection(), "kdissert_focustpanel");
	new KAction( i18n("Focus on the map"), "F3", this, SLOT(slotFocusOnMap()), actionCollection(), "kdissert_focusmap");
	//    new KAction( i18n("Focus on the attachement panel"), "F3", this, SLOT(slotFocusOnAPanel()), actionCollection(), "kdissert_focusapanel");

	// TODO : Volunteers ? anyone ?
	//KAction* action = KStdAction::configureToolbars(this, 
	//         SLOT(optionsConfigureToolbars()), actionCollection());
/*
	new KAction(i18n("&Add link..."), 0, this,
			SLOT(slotLinkAdd()), actionCollection(), "link_add");
	new KAction(i18n("&Remove link"), 0, this,
			SLOT(slotLinkRemove()), actionCollection(), "link_remove");
	new KAction(i18n("Open link"), 0, this,
			SLOT(slotLinkOpen()), actionCollection(), "link_open");
	new KAction(i18n("&Modify link..."), 0, this,
			SLOT(slotLinkModify()), actionCollection(), "link_modify");
	new KAction(i18n("&Copy link location"), 0, this,
			SLOT(slotLinkCopy()), actionCollection(), "link_copy");
*/
	createGUI( NULL );
}

void KDissert::showTip() 
{
	KTipDialog::showTip(this,QString::null,true);
}

void KDissert::showTipOnStart()
{
	KTipDialog::showTip(this);
}

void KDissert::slotFileNew()
{
	KDissertView *view = new KDissertView(this);
	m_manager->addPart( view->part() );

	connect(view->part(), SIGNAL(itemSelected(DDataItem*)), m_textproperties, SLOT(setCurrentItem(DDataItem*)));
	connect(view->part(), SIGNAL(itemChanged(int)), m_textproperties, SLOT(itemChanged(int)) );
	connect(view->part(), SIGNAL(itemSelected(DDataItem*)), m_miscproperties, SLOT(setCurrentItem(DDataItem*)));

	addWindow( view );

	// add the tree view to the widget stack
	m_treeviewstack->addWidget( view->part()->treeview() );
	m_views += view;

	connect(view->part(), SIGNAL(accessed(const KURL&)), this, SLOT(slotFileOpened(const KURL&)) );

	currentChanged( view );
}

void KDissert::slotFileOpened(const KURL & url)
{
	m_openRecentAction->addURL(url);
	m_openRecentAction->saveEntries( kapp->config(), "RecentFiles" );
	//statusBar()->message(i18n("The project was saved")+" "+url.prettyURL(), 5000);
}

void KDissert::slotFileOpen()
{
	KURL url = KFileDialog::getOpenURL(QString::null,
			i18n("*.kdi|kdissert project (*.kdi)") +"\n"+
			i18n("*.mm|Freemind files (*.mm)") +"\n"+
			i18n("*.kno|Knowit files (*.kno)") ,
			NULL, i18n("Open a mindmap project"));

	if (url.isEmpty())
		return;

	openURL(url);
}

void KDissert::openURL(const KURL & url)
{
	// check if the url is not already opened first
	QValueList<KDissertView*>::iterator it  = m_views.begin();
	QValueList<KDissertView*>::iterator end = m_views.end();
	for (; it != end; ++it)
	{
		KDissertView *view = *it;
		if (view->part()->url() == url)
		{
			activateView(view);
			return;
		}
	}

	KDissertView *view = new KDissertView(this);
	m_manager->addPart( view->part() );

	connect(view->part(), SIGNAL(itemSelected(DDataItem*)), m_textproperties, SLOT(setCurrentItem(DDataItem*)));
	connect(view->part(), SIGNAL(itemChanged(int)), m_textproperties, SLOT(itemChanged(int)) );
	connect(view->part(), SIGNAL(itemSelected(DDataItem*)), m_miscproperties, SLOT(setCurrentItem(DDataItem*)));
	connect(view->part(), SIGNAL(accessed(const KURL&)), this, SLOT(slotFileOpened(const KURL&)) );

	addWindow( view );

	// add the tree view to the widget stack
	m_treeviewstack->addWidget( view->part()->treeview() );
	m_views += view;

	view->part()->openURL(url);
	currentChanged( view );
}

void KDissert::currentChanged( KMdiChildView *current )
{
	//kdWarning()<<"current view changed"<<endl;
	if (!current)
	{
		m_manager->setActivePart(NULL);
		setCaption("kdissert");
		m_treeviewstack->raiseWidget( m_frame );
		return;
	}

	// switch to the corresponding document
	if ( m_views.contains( (KDissertView*) current ) )
	{
		KDissertView *view = (KDissertView*) current;
		view->updateCaption();
		m_manager->setActivePart( view->part() );

		/*	if (view->part()->url().isValid())
			{
			m_openRecentAction->addURL(view->part()->url());
			}*/

		m_treeviewstack->raiseWidget( view->part()->treeview() );
	}
}

void KDissert::slotFileClose()
{
	requestClose( activeWindow() );
}

bool KDissert::requestClose(KMdiChildView* v)
{
	//    kdWarning()<<"closing view"<<v<<endl;
	//    if (view == NULL)
	//	return;

	if (v == NULL)
	{
		if ( m_views.count() == 1)
		{
			KDissertView *view = m_views[0];
			if (view->part()->queryClose())
			{
				m_manager->removePart( view->part() );

				m_treeviewstack->removeWidget( view->part()->treeview() );
				m_treeviewstack->raiseWidget( m_frame );

				closeWindow( view );
				m_views.clear();
				setCaption("kdissert");
				return true;
			}
			return false;
		}
		return true;
	}

	// TODO : warning : we are using only KDissertView parts for the moment
	// what will happen if we load other kind of parts ? (ita)
	KDissertView *view = (KDissertView*) v;
	if ( m_views.contains( view ) )
	{
		m_views.remove( view );
		if ( view->part()->queryClose() )
		{
			m_manager->removePart( view->part() );
			m_treeviewstack->removeWidget( view->part()->treeview() );

			closeWindow( view );
			return true;
		}
		return false;
	}
	return true;
}

void KDissert::slotFileQuit()
{
	close();
}

void KDissert::optionsShowToolbar()
{
	if (m_toolbarAction->isChecked()) toolBar()->show();
	else toolBar()->hide();
}

void KDissert::optionsShowStatusbar()
{
	if (m_statusbarAction->isChecked()) statusBar()->show();
	else statusBar()->hide();
}

void KDissert::optionsConfigureKeys()
{
	//KKeyDialog::configure(actionCollection());
	KKeyDialog dlg( false, this );
	QPtrList<KXMLGUIClient> clients = guiFactory()->clients();

	for( QPtrListIterator<KXMLGUIClient> it( clients ); it.current(); ++it )
		dlg.insert ( (*it)->actionCollection(), (*it)->instance()->aboutData()->programName() );

	dlg.configure();

	for (int i=0; i<m_views.count(); i++)
	{
		m_views[i]->part()->reloadXML();
	}
}

void KDissert::optionsConfigureToolbars()
{
	//saveMainWindowSettings(KGlobal::config(), autoSaveGroup());
}

/*void KDissert::newToolbarConfig()
  {
// this slot is called when user clicks "Ok" or "Apply" in the toolbar editor.
// recreate our GUI, and re-apply the settings (e.g. "text under icons", etc.)
createGUI();
applyMainWindowSettings(KGlobal::config(), autoSaveGroup());
}*/

void KDissert::optionsPreferences()
{
	// The preference dialog is derived from prefs-base.ui which is subclassed into Prefs
	//
	// compare the names of the widgets in the .ui file 
	// to the names of the variables in the .kcfg file
	if (KConfigDialog::showDialog("settings"))
		return;	

	KConfigDialog *dialog = new KConfigDialog(this, "settings", Settings::self(), KDialogBase::Swallow);
	dialog->addPage(new Prefs_base(), i18n("General"), "package_settings");
	connect(dialog, SIGNAL(settingsChanged()), this, SLOT(settingsChanged()));
	dialog->show();
}

void KDissert::settingsChanged()
{
	// tell the truth to our documents
	QValueList<KDissertView*>::iterator it  = m_views.begin();
	QValueList<KDissertView*>::iterator end = m_views.end();
	for (; it != end; ++it)
	{
		KDissertView *view = *it;
		view->part()->settingsChanged();
	} 
}

void KDissert::changeStatusbar(const QString& text)
{
	// display the text on the statusbar
	statusBar()->message(text, 2000);
}

void KDissert::dragEnterEvent(QDragEnterEvent *event)
{
	// accept uri drops only
	event->accept(KURLDrag::canDecode(event));
}

void KDissert::dropEvent(QDropEvent *event)
{
	KURL::List urls;

	// see if we can decode a URI.. if not, just ignore it
	if (KURLDrag::decode(event, urls) && !urls.isEmpty())
	{
		// okay, we have a URI.. process it
		const KURL &url = urls.first();

		// load in the file
		openURL(url);
	}
}

bool KDissert::queryClose()
{
	QValueList<KDissertView*>::iterator it;

	// check if we can close all documents
	for (it = m_views.begin(); it != m_views.end(); ++it)
	{
		// kdWarning()<<"searching for the part"<<endl;
		KDissertView *view = *it;
		if (!view->part()->queryClose())
		{
			return false;
		}
	}

	// and now close the documents
	for (it = m_views.begin(); it != m_views.end(); ++it)
	{
		// now close all views
		KDissertView *view = *it;

		m_manager->removePart( view->part() );
		closeWindow( view );
	}

	m_openRecentAction->saveEntries( kapp->config(), "RecentFiles" );

	return true;
}

void KDissert::slotFocusOnTPanel()
{
	m_textproperties->summaryedit->setFocus();
}

void KDissert::slotFocusOnMap()
{
	KDissertView* v = (KDissertView*) activeWindow();
	if (!v) return;

	v->part()->widget()->setFocus();
}

void KDissert::slotSetStatusBarText(const QString & mes)
{
	statusBar()->message(mes, 5000); 
}

#include "KDissert.moc"
