package org.kde.koala;
import org.kde.qt.*;


/** {@link KListView} emits these signals */
public interface KListViewSignals {
	void rightButtonPressed( QListViewItem arg1, QPoint arg2, int arg3 );
	void collapsed( QListViewItem item );

/** 
 This signal is emitted after all the items have been moved. It reports info for
 each and every item moved, in order.  The first element in <code>items</code> associates
 with the first of afterFirst and afterNow.

*/
//	void moved( QList<QListViewItem>* items, QList<QListViewItem>* afterFirst, QList<QListViewItem>* afterNow );
	void destroyed();
	void returnPressed( QListViewItem arg1 );
	void rightButtonClicked( QListViewItem arg1, QPoint arg2, int arg3 );
	void contentsMoving( int x, int y );
	void pressed( QListViewItem arg1, QPoint arg2, int arg3 );

/** 
 This signal is emitted whenever a context-menu should be shown for item <code>i.</code>
 It automatically adjusts for all settings involved (Menu key, showMenuOnPress/Click).

*/
	void contextMenu( KListView l, QListViewItem i, QPoint p );
	void clicked( QListViewItem arg1, QPoint arg2, int arg3 );

/** 
 This signal is emitted when the shortcut key for popup-menus is pressed.

 Normally you should not use this, just connect a slot to signal
 {@link KListView#contextMenu} to correctly
 handle showing context menus regardless of settings.

*/
	void menuShortCutPressed( KListView list, QListViewItem item );
	void currentChanged( QListViewItem arg1 );

/** 
 Same as above, but without the extra information.
   
*/
	void itemRenamed( QListViewItem item );
	void mouseButtonPressed( int arg1, QListViewItem arg2, QPoint arg3, int arg4 );
	void expanded( QListViewItem item );
	void mouseButtonClicked( int arg1, QListViewItem arg2, QPoint arg3, int arg4 );

/** 
 This signal gets emitted whenever something acceptable is
 dropped onto the listview.

 This function also provides a parent, in the event that your listview
 is a tree

*/
	void dropped( QDropEvent e, QListViewItem parent, QListViewItem after );

/** 
 This signal gets emitted whenever the user double clicks into the
 listview.

 Note that you may not delete any {@link QListViewItem} objects in slots
 connected to this signal.

 This signal is more or less here for the sake of completeness.
 You should normally not need to use this. In most cases its better
 to use {@link KListView#executed} instead.
   
*/
	void doubleClicked( QListViewItem item, QPoint pos, int c );
	void selectionChanged( QListViewItem arg1 );

/** 
 Connect to this signal if you want to do some preprocessing before
 a move is made, for example, to disable sorting

 This is sent only once per each groups of moves.  That is, for each
 drop that is a move this will be emitted once, before KListView calls
 {@link KListView#moveItem}

*/
	void aboutToMove();
	void onViewport();
	void onItem( QListViewItem item );

/** 
 This signal is emitted whenever the user executes an listview item.
 That means depending on the KDE wide Single Click/Double Click
 setting the user clicked or double clicked on that item.

 Note that you may not delete any {@link QListViewItem} objects in slots
 connected to this signal.
   
*/
	void executed( QListViewItem item, QPoint pos, int c );
}

