/***************************************************************************
 *   Copyright (C) 2004-2009 by Thomas Fischer                             *
 *   fischer@unix-ag.uni-kl.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "webquerymathscinet.h"

#include <qlayout.h>
#include <qlabel.h>
#include <qregexp.h>
#include <qspinbox.h>

#include <kpushbutton.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kurl.h>
#include <kdebug.h>
#include <kio/netaccess.h>
#include <kmessagebox.h>

#include <settings.h>

namespace KBibTeX
{
    WebQueryMathSciNetWidget::WebQueryMathSciNetWidget( QWidget *parent, const char *name )
            : WebQueryWidget( parent, name )
    {
        init();

        Settings *settings = Settings::self();
        QString value = settings->getWebQueryDefault( "MathSciNet" );
        value = value == QString::null ? "" : value;
        lineEditQuery->setText( value );
        slotTextChanged( value, true );
    }

    void WebQueryMathSciNetWidget::init()
    {
        QVBoxLayout *vLayout = new QVBoxLayout( this, 0, KDialog::spacingHint() );

        QHBoxLayout *hLayout = new QHBoxLayout( );
        vLayout->addLayout( hLayout );

        KPushButton *clearSearchText = new KPushButton( this );
        clearSearchText->setIconSet( QIconSet( SmallIcon( "locationbar_erase" ) ) );
        hLayout->addWidget( clearSearchText );
        QLabel *label = new QLabel( i18n( "Search &term:" ), this );
        hLayout->addWidget( label );
        lineEditQuery = new KLineEdit( this );
        hLayout->addWidget( lineEditQuery );
        label->setBuddy( lineEditQuery );
        hLayout->addSpacing( KDialog::spacingHint() * 2 );
        connect( clearSearchText, SIGNAL( clicked() ), lineEditQuery, SLOT( clear() ) );
        connect( lineEditQuery, SIGNAL( textChanged( const QString& ) ), this, SLOT( slotTextChanged( const QString& ) ) );
        hLayout->setStretchFactor( lineEditQuery, 4 );
        KCompletion *completionQuery = lineEditQuery->completionObject();

/*
        label = new QLabel( i18n( "&Number of results:" ), this );
        hLayout->addWidget( label );
        spinBoxMaxHits = new QSpinBox( 1, 250, 1, this );
        spinBoxMaxHits->setValue( 10 );
        hLayout->addWidget( spinBoxMaxHits );
        label->setBuddy( spinBoxMaxHits );
*/

        label = new QLabel( i18n( "<qt>Use the same synatx as for <a href=\"http://www.math.tamu.edu/~comech/tools/bibget/\">BIBGET</a>. For spaces within a search element, use \"<tt>+</tt>\".<br/>Example: <tt>a=gilkey t=invariance book 1984</tt></qt>" ), this );
        vLayout->addWidget( label );

        vLayout->addStretch( 0 );

        connect( lineEditQuery, SIGNAL( returnPressed() ), this, SIGNAL( startSearch() ) );
        connect( lineEditQuery, SIGNAL( returnPressed( const QString& ) ), completionQuery, SLOT( addItem( const QString& ) ) );
    }

    WebQueryMathSciNet::WebQueryMathSciNet( QWidget* parent ): WebQuery( parent )
    {
        m_widget = new WebQueryMathSciNetWidget( parent );
    }

    WebQueryMathSciNet::~WebQueryMathSciNet()
    {
        delete m_widget;
    }

    QString WebQueryMathSciNet::title()
    {
        return i18n( "MathSciNet" );
    }

    QString WebQueryMathSciNet::disclaimer()
    {
        return i18n( "American Mathematical Society" );
    }

    QString WebQueryMathSciNet::disclaimerURL()
    {
        return "http://www.ams.org/ams/copyright.html";
    }

    WebQueryWidget *WebQueryMathSciNet::widget()
    {
        return m_widget;
    }

    void WebQueryMathSciNet::query()
    {
        WebQuery::query();
        Settings *settings = Settings::self();
        settings->setWebQueryDefault( "MathSciNet", m_widget->lineEditQuery->text() );

        setNumStages( 1 );

        QStringList searchTerms = QStringList::split( QRegExp( "\\s+" ), m_widget->lineEditQuery->text().stripWhiteSpace() );
        if ( searchTerms.isEmpty() )
        {
            setEndSearch( WebQuery::statusInvalidQuery );
            return;
        }

        QStringList queryTerms;
        int count = 1;
        for ( QStringList::ConstIterator it = searchTerms.constBegin(); it != searchTerms.constEnd(); ++it )
        {
            const QString term=*it;
            if ( term.startsWith( "a=" ) )
                queryTerms << QString( "pg%1=AUCN" ).arg( count ) << QString( "s%1=%2" ).arg( count ).arg( term.mid( 2 ) );
            else if ( term.startsWith( "t=" ) )
                queryTerms << QString( "pg%1=TI" ).arg( count ) << QString( "s%1=%2" ).arg( count ).arg( term.mid( 2 ) );
            else if ( term.startsWith( "k=" ) )
                queryTerms << QString( "pg%1=ALLF" ).arg( count ) << QString( "s%1=%2" ).arg( count ).arg( term.mid( 2 ) );
            else if ( term.startsWith( "r=" ) )
                queryTerms << QString( "pg%1=MR" ).arg( count ) << QString( "s%1=%2" ).arg( count ).arg( term.mid( 2 ) );
            else if ( term.startsWith( "j=" ) )
                queryTerms << QString( "pg%1=JOUR" ).arg( count ) << QString( "s%1=%2" ).arg( count ).arg( term.mid( 2 ) );
            else
                queryTerms << QString( "pg%1=ALLF" ).arg( count ) << QString( "s%1=%2" ).arg( count ).arg( term );
            ++count;
        }

        KURL url( QString( "http://www.ams.org/msnmain?fn=130&fmt=bibtex&l=100&extend=1&" ).append( queryTerms.join( "&" ) ) );
        kdDebug()<<"url="<<url.prettyURL()<<endl;

        BibTeX::File *bibFile = downloadBibTeXFile( url );
        enterNextStage();

        if ( bibFile != NULL && !m_aborted )
        {
            for ( BibTeX::File::ElementList::iterator it = bibFile->begin(); it != bibFile->end(); ++it )
            {
                BibTeX::Entry *entry = dynamic_cast<BibTeX::Entry*>( *it );
                if ( entry != NULL )
                    emit foundEntry( entry, false );
            }
            setEndSearch( WebQuery::statusSuccess );
        }
        else if ( !m_aborted )
        {
            QString message = KIO::NetAccess::lastErrorString();
            if ( message.isEmpty() )
                message.prepend( '\n' );
            message.prepend( QString( i18n( "Querying database '%1' failed." ) ).arg( title() ) );
            KMessageBox::error( m_parent, message );
            setEndSearch( WebQuery::statusError );
        }
        else
            setEndSearch( WebQuery::statusAborted );

        if ( bibFile != NULL )
            delete bibFile;
    }

}
