/***************************************************************************
                          viewsettingswidget.cpp  -  description
                             -------------------
    begin                : lr mar 2 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qradiobutton.h>
#include <qcheckbox.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kapplication.h>
#include <kconfig.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "viewsettingswidget.h"

//-----------------------------------------------
ViewSettingsWidget::ViewSettingsWidget(QWidget *parent, const char *name )
	:	ViewSettingsBase(parent,name)
{
	readSettings();
}
//-----------------------------------------------
ViewSettingsWidget::~ViewSettingsWidget(){
}
//-----------------------------------------------
void ViewSettingsWidget::readSettings() {
	QString oldGroup = kapp->config()->group();
	kapp->config()->setGroup("View Settings");
	QString tmp = QString::fromLatin1("Detail");
	QString viewType = kapp->config()->readEntry("View Style", tmp );
	if( viewType == tmp )
		p_detailedViewButton->setChecked( true );
	else
		p_iconViewButton->setChecked( true );

	p_treeViewCheckBox->setChecked( kapp->config()->readBoolEntry("Show TreeView", true) );

	kapp->config()->setGroup("General");
	tmp = QString::fromLatin1("Enabled");
	QString statusBarStr = kapp->config()->readEntry("StatusBar", tmp);
	p_statusBarCheckBox->setChecked( statusBarStr == tmp );
	p_runSettingsCheckBox->setChecked( kapp->config()->readBoolEntry( "Run Time Settings", true) );

	kapp->config()->setGroup("MainWindow Toolbar mainToolBar");
	p_mainToolBarCheckBox->setChecked( ! kapp->config()->readBoolEntry("Hidden", false) );

	kapp->config()->setGroup("MainWindow Toolbar helpToolBar");
	p_helpToolBarCheckBox->setChecked( ! kapp->config()->readBoolEntry("Hidden", false) );

	kapp->config()->setGroup("MainWindow Toolbar TaskBar");
	p_taskBarCheckBox->setChecked( ! kapp->config()->readBoolEntry("Hidden", false) );

	kapp->config()->setGroup("Child View Options");
	p_childToolBarCheckBox->setChecked( kapp->config()->readBoolEntry("Child ToolBar", true) );
	p_childPathToolBarCheckBox->setChecked( kapp->config()->readBoolEntry("Child Path ToolBar", true) );
	p_childStatusBarCheckBox->setChecked( kapp->config()->readBoolEntry("Child StatusBar", true) );
	p_childInfoBarCheckBox->setChecked( kapp->config()->readBoolEntry("Child InfoBar", true) );

	kapp->config()->setGroup("View Options");
	p_localFileSysCheckBox->setChecked( kapp->config()->readBoolEntry("Show Local", true)  );
	p_transferViewCheckBox->setChecked( kapp->config()->readBoolEntry("Show Transfer", true)  );
	p_logViewCheckBox->setChecked( kapp->config()->readBoolEntry("Show Log", true) );

	slotViewSelect();
	kapp->config()->setGroup( oldGroup );
}
//-----------------------------------------------
void ViewSettingsWidget::saveSettings() {
	QString oldGroup = kapp->config()->group();
	kapp->config()->setGroup("View Settings");
	if( p_detailedViewButton->isChecked() )
		kapp->config()->writeEntry("View Style", QString::fromLatin1("Detail") );
	else
		kapp->config()->writeEntry("View Style", QString::fromLatin1("Simple") );

	kapp->config()->writeEntry("Show TreeView", p_treeViewCheckBox);

	kapp->config()->setGroup("General");
	if( p_statusBarCheckBox->isChecked() )
		kapp->config()->writeEntry("StatusBar", QString::fromLatin1("Enabled") );
	else
		kapp->config()->writeEntry("StatusBar", QString::fromLatin1("Disabled") );

	kapp->config()->writeEntry( "Run Time Settings", p_runSettingsCheckBox->isChecked() );

	kapp->config()->setGroup("MainWindow Toolbar mainToolBar");
	kapp->config()->writeEntry("Hidden", ! p_mainToolBarCheckBox->isChecked() );

	kapp->config()->setGroup("MainWindow Toolbar helpToolBar");
	kapp->config()->writeEntry("Hidden", ! p_helpToolBarCheckBox->isChecked() );

	kapp->config()->setGroup("MainWindow Toolbar TaskBar");
	kapp->config()->writeEntry("Hidden", ! p_taskBarCheckBox->isChecked() );

	kapp->config()->setGroup("Child View Options");
	kapp->config()->writeEntry("Child ToolBar", p_childToolBarCheckBox->isChecked() );
	kapp->config()->writeEntry("Child Path ToolBar", p_childPathToolBarCheckBox->isChecked() );
	kapp->config()->writeEntry("Child StatusBar", p_childStatusBarCheckBox->isChecked() );
	kapp->config()->writeEntry("Child InfoBar", p_childInfoBarCheckBox->isChecked() );

	kapp->config()->setGroup("View Options");
	kapp->config()->writeEntry("Show Local", p_localFileSysCheckBox->isChecked());
	kapp->config()->writeEntry("Show Transfer", p_transferViewCheckBox->isChecked());
	kapp->config()->writeEntry("Show Log", p_logViewCheckBox->isChecked());

	kapp->config()->setGroup( oldGroup );
	kapp->config()->sync();
}
//-----------------------------------------------
#ifndef NO_INCLUDE_MOCFILES
#include "viewsettingswidget.moc"
#endif
