/***************************************************************************
                          kbeartextedit.cpp  -  description
                             -------------------
    begin                : Fri Apr 12 2002
    copyright            : (C) 2002 by Peter Svrd
    email                : tocool@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//////////////////////////////////////////////////////
// Qt specific includes
#include <qfile.h>
//////////////////////////////////////////////////////
// KDE specific includes
#include <klocale.h>
#include <kfiledialog.h>
//////////////////////////////////////////////////////
// Application specific includes
#include "kbeartextedit.h"
//////////////////////////////////////////////////////

KBearTextEdit::KBearTextEdit(QWidget* parent, const QString& name)
: QTextEdit(parent,name.latin1())
{
}
//-----------------------------------------------
KBearTextEdit::~KBearTextEdit()
{
}
//-----------------------------------------------
QPopupMenu* KBearTextEdit::createPopupMenu(const QPoint & pos)
{
	popUp = QTextEdit::createPopupMenu(pos);

	/*int saveID =*/ popUp->insertItem(i18n("Save As..."), this, SLOT( slotSaveAs() ) );
  popUp->insertSeparator();
  /*int clearID =*/ popUp->insertItem(i18n("Cl&ear"), this, SLOT( clear() ) );
	
  return popUp;
}
//-----------------------------------------------
void KBearTextEdit::slotSaveAs()
{
	// copy & paste from manual
  QString f = KFileDialog::getSaveFileName( QDir::homeDirPath(), i18n("*|All files"), this, i18n("Save as...") );
  if(!f.isEmpty())
  {
  	QFile file( f );
    if ( file.open( IO_WriteOnly ) )
    {         	
        QTextStream ts( &file );
        selectAll();
        ts << selectedText();
        selectAll( false );
        file.close();
    }
  }	
}
//-----------------------------------------------
#ifndef NO_INCLUDE_MOCFILES
#include "kbeartextedit.moc"
#endif
