//**************************************************************************
//                        mixedsettingswidget.cpp  -  description
//                           -------------------
//  begin                : Sat Sep 30 2000
//  copyright            : (C) 2000 by Bjrn Sahlstrm
//  email                : bjorn@kbear.org
//**************************************************************************/

//**************************************************************************
//                                                                         *
//   This program is free software; you can redistribute it and/or modify  *
//   it under the terms of the GNU General Public License as published by  *
//   the Free Software Foundation; either version 2 of the License, or     *
//   (at your option) any later version.                                   *
//                                                                         *
//**************************************************************************/
#include "mixedsettingswidget.h"

//-----------------------------------------------
MixedSettingsWidget::MixedSettingsWidget( QWidget *parent, const char *name)
	: MixedSettingsWidgetBase(parent,name)
{
	connect( p_autoResumeCheckBox, SIGNAL(clicked()), this, SLOT(slotAutoResumeChecked()));
	connect( p_partExtensionCheckBox, SIGNAL(clicked()), this, SLOT(slotPartExtensionChecked()));
}
//-----------------------------------------------
MixedSettingsWidget::~MixedSettingsWidget(){
}
//-----------------------------------------------
QString MixedSettingsWidget::defaultWebPage(){
	return p_startPageLineEdit->text();
}
//-----------------------------------------------
QString MixedSettingsWidget::defaultEmail(){
	return p_emailComboBox->currentText();
}
//-----------------------------------------------
void MixedSettingsWidget::setDefaultWebPage( const QString& page ){
	p_startPageLineEdit->setText( page );
}
//--------------------------------------------
void MixedSettingsWidget::setDefaultEmail( const QString& email ){
	QString tmp = "";
	// read default email for use as password on anonymous servers
	KConfig* conf =  new KConfig("emaildefaults");
	QStringList groupList = conf->groupList();
	bool found = false;
	for( QStringList::Iterator it = groupList.begin(); it != groupList.end(); it++ ) {
		if( (*it).left( 8 ) == "PROFILE_" ) {
			conf->setGroup( (*it) );
			tmp = conf->readEntry( "EmailAddress" );
			p_emailComboBox->insertItem( tmp );
			if( tmp == email )
				found = true;
		}
	}
	if( email != "" ) {
		if( ! found )
			p_emailComboBox->insertItem( email );
	}
	p_emailComboBox->setCurrentItem( p_emailComboBox->count()-1 );
	p_emailComboBox->setEditable( true );
	delete conf;
}
//-----------------------------------------------
/** Called whenever the AutoResume option is checked/unchecked */
void MixedSettingsWidget::slotAutoResumeChecked(){
	bool ch = p_autoResumeCheckBox->isChecked();
	if( KMessageBox::Continue == KMessageBox::warningContinueCancel ( this,
				i18n("WARNING!\n\nThis setting will affect all KDE2 applications that use it, not only KBEAR."),
				i18n("Warning ! Auto Resume"), 	ch ? i18n("Use auto resume") : i18n("Don't use auto resume"))) {
		bool tmp = p_autoResumeCheckBox->isChecked();
		p_autoResumeCheckBox->setChecked( tmp ? true : false );
	}
	else
		p_autoResumeCheckBox->setChecked( ! ch );
}
//-----------------------------------------------
/** No descriptions */
void MixedSettingsWidget::slotPartExtensionChecked(){
	bool ch = p_partExtensionCheckBox->isChecked();
	if( KMessageBox::Continue == KMessageBox::warningContinueCancel ( this,
				i18n("WARNING!\n\nThis setting will affect all KDE2 applications that use it, not only KBEAR."),
				i18n("Warning ! Part Extension"), ch ? i18n("Don't use '.part' extension") : i18n("Use '.part' extension"))) {
		bool tmp = p_partExtensionCheckBox->isChecked();
		p_partExtensionCheckBox->setChecked( tmp ? true : false);
	}
	else
		p_partExtensionCheckBox->setChecked( ! ch );

}
//-----------------------------------------------
