/***************************************************************************
*                        kfiledndiconview.cpp  -  description
*                           -------------------
*  begin                : Wed Nov 1 2000
*  copyright            : (C) 2000 by Bjrn Sahlstrm
*  email                : bjorn@kbear.org
***************************************************************************/

/***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

#include "kfiledndiconview.h"
//-----------------------------------------------
KFileDnDIconView::KFileDnDIconView( QWidget *parent, const char *name )
	: KFileIconView(parent,name), myAutoOpenTimer( this ),
		autoOpenTime( 750 ), b_useAutoOpenTimer( true ), dropItem(0)
{
	useAutoOpenTimer( true );
}
//-----------------------------------------------
KFileDnDIconView::~KFileDnDIconView(){
}
//-----------------------------------------------
void KFileDnDIconView::slotOpenFolder(){
	myAutoOpenTimer.stop();
	if( !dropItem )
		return;
	const KFileViewItemList* fileList = KFileView::items();
	KFileViewItemListIterator it( *(QList<KFileViewItem>*)fileList );
	for( ; it.current() ;++it ){
		if( (*it)->name() == dropItem->text() && (*it)->isFile())
			return;
	}
	emit openFolder( dropItem->text() );
}
//-----------------------------------------------
void KFileDnDIconView::contentsDragEnterEvent( QDragEnterEvent *e ) {
	setSelectionMode( KFile::Single );  // change selection mode to single, otherwhise we get a very strange behavior ;)
	if ( QUriDrag::canDecode( e ) ) { // can we decode this ?
		e->accept( true );            // Yes
		QIconViewItem *i = findItem( contentsToViewport( e->pos() ) );
		if ( i ) {  // are we over an item ?
			dropItem = i;  // set new dropItem
			myAutoOpenTimer.start( autoOpenTime ); // restart timer
		}
	}
}
//-----------------------------------------------
void KFileDnDIconView::contentsDragMoveEvent( QDragMoveEvent *e ) {
	if ( QUriDrag::canDecode( e ) ) { // can we decode this ?
		e->accept( true );     // Yes
		QIconViewItem *i = findItem( contentsToViewport( e->pos() ) );
		if ( i ) {  // are we over an item ?
			if ( i != dropItem ) { // if so, is it a new one ?
				myAutoOpenTimer.stop(); // stop timer
				dropItem = i;      // set new dropItem
				myAutoOpenTimer.start( autoOpenTime ); // restart timer
			}
		}
		else
			myAutoOpenTimer.stop(); // stop timer
	}
}
//-----------------------------------------------
void KFileDnDIconView::contentsDragLeaveEvent( QDragLeaveEvent* ) {
	myAutoOpenTimer.stop(); // stop timer
	dropItem = 0;                  // clear dropItem
	setSelectionMode( KFile::Extended ); // change selection mode back to extended
}
//-----------------------------------------------
void KFileDnDIconView::contentsDropEvent( QDropEvent* e ) {
	setSelectionMode( KFile::Extended );
	myAutoOpenTimer.stop();
	dropItem = 0;
	KFileIconView::contentsDropEvent( e );
	if( QUriDrag::canDecode( e ) ) { // the drop was accepted so lets emit this
		KURL::List urlList;    // to the outside world
		KURLDrag::decode( e, urlList );
		emit dropped( urlList );
		QApplication::sendPostedEvents();
	}
}
//-----------------------------------------------
void KFileDnDIconView::startDrag(){
	if ( ! currentItem() ) // is there any selected items ?
		return;              // nope
	dragObject()->dragCopy();   // start the drag
}
//-----------------------------------------------
QDragObject* KFileDnDIconView::dragObject() {
	// create a list of the URL:s that we want to drag
	KURL::List urls;
	const KFileViewItemList* fileList = KFileView::selectedItems();
	KFileViewItemListIterator it( *(QList<KFileViewItem>*)fileList );
	for ( ; it.current(); ++it ){
		urls.append( (*it)->url() );
	}
	QDragObject* myDragObject = KURLDrag::newDrag( urls, this );
	myDragObject->setPixmap( *(currentItem()->pixmap()) );
	return myDragObject;
}
//-----------------------------------------------
void KFileDnDIconView::setAutoOpenTime( const int& time ){
	autoOpenTime = time;
	useAutoOpenTimer();
}
//-----------------------------------------------
void KFileDnDIconView::useAutoOpenTimer( bool use ){
	b_useAutoOpenTimer = use;
	if ( use )
		connect( &myAutoOpenTimer, SIGNAL( timeout() ),this, SLOT( slotOpenFolder() ) );
	else {
		disconnect( &myAutoOpenTimer, SIGNAL( timeout() ),this, SLOT( slotOpenFolder() ) );
		dropItem = 0;
		myAutoOpenTimer.stop();
	}
}
//-----------------------------------------------
void KFileDnDIconView::setDnDEnabled( bool useDnd ){
	setAcceptDrops( useDnd );
	viewport()->setAcceptDrops( useDnd );
}
//-----------------------------------------------
