/*********************************************************************************
                          kbeartransferviewitem.h  -  description
                             -------------------
    Begin					: Wed Jul 26 2000
    Copyright				: (C) 2000 by Bjrn Sahlstrm
    Email						: bjorn.sahlstrom@mail.bip.net
 ********************************************************************************/

/*********************************************************************************
 *																															*
 *   This program is free software; you can redistribute it and/or modify		*
 *   it under the terms of the GNU General Public License as published by	*
 *   the Free Software Foundation; either version 2 of the License, or			*
 *   (at your option) any later version.																*
 *																															*
 ********************************************************************************/

#ifndef KBEARTRANSFERVIEWITEM_H
#define KBEARTRANSFERVIEWITEM_H
//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qwidget.h>
#include <qtimer.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kio/job.h>
#include <kio/jobclasses.h>
#include <kio/progressbase.h>
#include <kurl.h>
//////////////////////////////////////////////////////////////////////
// application specific include files
#include "kbeartreeview.h"
#include "kbeartransferview.h"

class KBearTransferView;

/**
	*This class represents a transferjob, it connects the @ref KIO::Job signals with apropriate slots.
	* On the graphic side it shows an item in the TransferView
	*@short This class represents a transferjob
	*@see KBearTransferView
  *@author Bjrn Sahlstrm
*/
class KBearTransferViewItem : public ProgressBase, public KBearTreeViewItem {
   Q_OBJECT
public:
	/**  */
	KBearTransferViewItem( KIO::CopyJob* job, KBearTransferView* v,
								const QString& host, bool move );
	/**  */
	~KBearTransferViewItem();
signals:
	void finished();
public slots: // Public slots
	/** */
	void slotTotalSize( KIO::Job*, unsigned long );
	/**  */
	void slotTotalFiles( KIO::Job*, unsigned long );
	/**  */
	void slotTotalDirs( KIO::Job*, unsigned long );
	/**  */
	void slotProcessedSize( KIO::Job*, unsigned long );
	/**  */
	void slotSpeed( KIO::Job*, unsigned long );
	/**  */
	void slotPercent( KIO::Job*, unsigned long );

protected slots: // Protected slots
	/**  */
	void slotStop();
	/**  */
	void slotFinished( KIO::Job* );
	/**  */
	void slotRemoveItem();
	/**  */
	void slotShowMenu( KBearTransferViewItem* );
private: // Private attributes
	KBearTransferView* p_myTransferView;
	unsigned long totalSize;
	unsigned long processedSize;
private: // Private methods
  /**  */
  QPixmap myPix;
  /**  */
  KIO::Job* p_myJob;
  /** For internal use only */
  QString createSizeString( unsigned long size );
};

#endif
