#include <string>
#include <vector>
#include <iostream>
using namespace std;

#include "category.h"
#include "errors.h"
#include "globals.h"
#include "utility.h"

#ifdef GUI
#include <qmessagebox.h>

#include "browser.h"
#endif

void addParseWarning( string msg )
{
        string address = parsingfile + ":" + itos( (*linenrv)[linenr-1] ) + ":";
        parsewarningv.push_back( address + " " + msg );
}

void addParseWarning( string msg, int linenr )
{
        string address = parsingfile + ":" + itos( linenr ) + ":";
	parsewarningv.push_back( address + " " + msg );
}

void showParseWarnings( )
{
        if( parsewarningv.empty() )
                return;

	string msg;	
        for( unsigned int n = 0; n < parsewarningv.size(); n++ )
                msg += parsewarningv[n] + "\n";
	msg.erase( msg.length()-1, 1 );

#ifdef GUI
	string caption = "Parse Warning";
	if( parsewarningv.size() > 1 )
		caption += "s";

	QMessageBox mb( caption.c_str(), msg.c_str(), QMessageBox::Warning, QMessageBox::Ok, 0, 0 );
	mb.exec();		
#else
	cout << msg << endl; 
#endif
}

void showNavigationError( Category *category, string msg )
{
        if( category == 0 )
        {
            showNavigationError( msg );
            return;
        }

	msg = fullPath( cPath, category ) + ":\n" + msg;

	showNavigationError( msg );
}	

void showNavigationError( string msg )
{
        if( checkingstructure )
                return;

#ifdef GUI
	QMessageBox mb( "Navigation Error", msg.c_str(), QMessageBox::Warning, QMessageBox::Ok, 0, 0 ); 
	mb.exec();
#else
        cout << msg << endl;
#endif

}

