#include <qwidget.h>
#include <qtoolbar.h>
#include <qlabel.h>
#include <qevent.h>
#include <qscrollview.h>
#include <qpixmap.h>
#include <qlayout.h>
#include <qpoint.h>
#include <qpopupmenu.h>
#include <qtoolbutton.h>
#include <qpushbutton.h> 
#include <qmainwindow.h> 

class Category;
class ChatBox;
class Separator;
class SourceBox;
class Keyboard;
class Bookmarks;
class MailingLists;
class OwnerButton;
class Currents;

#include <vector>
#include <string>
using namespace std;

class Browser : public QMainWindow {
	Q_OBJECT

public: 
	Browser();

	void showNewCategory();
	void buildToolbar();
	void renewToolbar();
	void setTitleLabelColors();
	void setBackgroundColor();
	void setCatLabelColors();
	void checkScrollHeight();
	void buildBookmarkMenu();

	int update( int );

	int action_openfile();
	int action_openurl();
	int action_backtrace();
	int action_forwardtrace();
	void action_showlinks();
	void action_showinfo();
	void action_shownews();
	void action_chat();

	void timedMessage( string, int );

	ChatBox *chatBox; 
	QToolBar *toolBar;
	QPopupMenu *mainmenu, *editmenu;
	int editmenuid, bmmenuid; 
	SourceBox *sourceBox, *debugWindow;
	vector<QLabel *> allLabelv;

	Separator *maskSep, *genSep;

	QScrollView *scrollView;

	Category *extcat;

	int keyboardaction;
	int disabled;

	QToolButton *TBlinks, *TBback, *TBchat, *TBroot, *TBinfo, *TBstop, *TBmark,
	 	    *TBtomark, *TBforward, *TBnews, *TBdiscuss, *TBbookmarks, *TBbase;

public slots:
	void enterCategory( Category * );
	void aboutQt();
	void about();
	void aboutKDE();
	void aboutAapje();
	void uhm_oops();
	void openFile();
	void openURL();

	void showPreferences();
	void showBookmarks();
	void showMailingLists();

	void backPressed();
	void rootPressed();
	void chatPressed();
	void linksPressed();
	void infoPressed();
	void newsPressed();
	void mlistPressed();
	void markPressed();
	void tomarkPressed();
	void faqPressed();
	void basePressed();
	void discussPressed();
	void forwardPressed();
	void stopPressed();
	void viewPageSource();
	void sendEmail();
	void gotoHomepage();
	void clearCachePressed();
	void debugWindowPressed();
	void addBookmark();
	void bookmarkSelected( int );

	void choseChannel( string );
	void choseLink( string );
	void choseMlist( string, string );
	void choseFaq( string );
	void choseDiscuss( string );
	void choseBase( string );

	void showRightMenu( int, int );
	void showRightMenuExtension( int, int, Category * );

	void extensionOpen();
	void extensionOpenWith();
	void copyLinkLocation();

	void setReady();

signals:
	void stopSignal();

protected: 
	void initDialog();
	void resizeEvent( QResizeEvent * );
	void keyPressEvent( QKeyEvent * );

private: 
	void addCatLabel( vector<QLabel *> &, Category * );
	int resizeCatLabels( vector<QLabel *> &, int ); 
	void createVectors( vector<string> * );
	void addToolButton( QToolButton *&, string, string, const char * ); 
	void tryToSelect( vector<string> *, string, string );
	void enableDisable( int );

	QPixmap folder;
	QVBoxLayout *grid;

	QPopupMenu *catmenu, *ownermenu, *bmmenu, *rightmenu, *mediamenu, *movemenu;

	OwnerButton *Bowner;

	QLabel *titleLabel;
	QPushButton *mailButton;

	QWidget *scrollWidget;
	
	vector<QLabel *> catLabelv, maskLabelv, genLabelv;

	vector<QToolButton *> toolButtonv; 

	Keyboard *keyboard;
	Bookmarks *bookmarks;
	MailingLists *mailinglists;

	vector<string> namev, memoryv, descv; 

	string markaddress;
	Currents *markcurrents;

	int catinfoid, catnewsid, catchatid, catlinksid, catbaseid, catdiscussid, 
	    catfaqid, catmlistid;
	int rightinfoid, rightnewsid, rightchatid, rightlinksid, rightbaseid, 
	    rightdiscussid, rightfaqid, rightmlistid, rightopenid, rightopenwid, 
	    rightcopyid;
	int movebackid, movefwdid, movetomarkid, moverootid, movemarkid, movestopid;
	int editsourceid, editclearid, editdebugid;
	int bmaddid;
};
