"""database management
3 types of data : str, int, float
the base is loaded in memory
access by list comprehension or generator expression
Syntax :
    db = strakell.create('dummy',name=str,age=int,size=float)
    db = strakell.open('dummy')

    db.write(name,age,float)
    res = [ (expression on r) for r in db if (condition) ]
    db.remove(selected_records)
    # to update records
    for r in selected_records:
        change_record(r)
    db.commit() # to save on disk
"""

import os
import cPickle
import threading
class Record(object):

    def __init__(self,kw):
        self.__dict__=kw

class Base:

    def __init__(self,basename):
        self.name = basename

    def create(self,**args):
        if os.path.exists(self.name):
            raise IOError,"Base %s already exists" %basename
        for v in args.values():
            if v not in [str,unicode,int,float]:
                raise TypeError,"type %s not allowed" %v
        self.args = args
        self.records = []
        self.next_id = 0

    def open(self):
        _in = open(self.name,'rb')
        args = cPickle.load(_in)
        self.args = dict((k,eval(v)) for (k,v) in args.iteritems())
        self.records = []
        for i,r in enumerate(cPickle.load(_in)):
            r.update({'__id__':i})
            self.records.append(Record(r))

    def commit(self):
        """Write the database to a file
        A lock is used to prevent concurrent writes"""
        lock = threading.Lock()
        lock.acquire()
        try:
            out = open(self.name,'wb')
            args = dict((k,v.__name__) for (k,v) in self.args.iteritems())
            cPickle.dump(args,out)
            records = [ r.__dict__ for r in self.records ]
            cPickle.dump(records,out)
            out.close()
        finally:
            lock.release()

    def insert(self,**kw):
        for (k,v) in kw.iteritems():
            if not k in self.args.keys():
                raise NameError,"No field named %s" %k
            if not isinstance(v,self.args[k]):
                raise TypeError,"Bad type for %s : expected %s, got %s" \
                      %(k,self.args[k].__name__,v.__class__.__name__)
        kw.update({'__id__':self.next_id})
        self.records.append(Record(kw))
        self.next_id += 1

    def remove(self,records):
        for r in records:
            self.records.remove(r)

    def dump(self):
        cols = ['__id__'] + self.args.keys()
        print ' '.join(cols)
        for r in self.records:
            print ' '.join(str(getattr(r,c)) for c in cols)

    def __getitem__(self,num):
        return self.records[num]
        
    def __iter__(self):
        return iter(self.records)

if __name__ == '__main__':
    db = Base('dummy')
    if not os.path.exists('dummy'):
        db.create(name=str,age=int,size=float)
        import random
        names = ['pierre','claire','simon','camille','jean',
                 'florence','marie-anne']
        for i in range(100):
            db.insert(name=random.choice(names),
                 age=random.randint(7,47),size=random.uniform(1.10,1.75))
        db.commit()
    else:
        db.open()
    for record in [r for r in db if r.age>27] :
        print '[%s]'%record.__id__,record.name,record.age
    for record in [r for r in db if r.name=='pierre'] :
        record.name = "Pierre"
    db.dump()
    
