#ifndef FILTER_H
#define FILTER_H

/* The match types */
#define FILTER_MATCH_CLASS     0
#define FILTER_MATCH_PACKAGE   1
#define FILTER_MATCH_RECURSIVE 2
#define FILTER_MATCH_ALL       3

#define FILTER_EXCLUDE 0
#define FILTER_INCLUDE 1

/* Returns true if the given classname is matched by the filter */
int filter_class_name (const char *classname);

/** Removes all current filters. */
void filter_clear_filters ();

/* Set the filters to the one given.
 * This will remove all of the other filters (will call free on the structures). 
 * @param filter_type one of FILTER_MATCH_*
 * @param filter the string to filter on ("rabbit.proxy"). 
 *  This string will be duplicated.
 */
void filter_set_filter (int filter_type, const char *filter);

/** The type of the filters. */
typedef struct class_filter class_filter;

/** Get the filter type
 * @return one of the FILTER_MATCH_*
 */
int get_filter_type (class_filter*);

/** Get the filter name
 * @return the name that is matched for the given filter.
 */
char* get_filter_name (class_filter*); 

/** 
 * @return FILTER_INCLUDE or FILTER_EXCLUDE
 */ 
int get_inc_or_exc (class_filter*);

/* A list containing filters. */
typedef struct filter_list filter_list;

/** Get the current first filter. */
filter_list* get_current_filters ();

/** Get the next filter.
 * @return the next filter or NULL if there are no more filters.
 */
filter_list* get_next_filter (filter_list* fl);

/** Get the actual filter
 */
class_filter* get_class_filter (filter_list* fl);

/** Add a filter to the current list of filters. 
 * @param mode one of FILTER_INCLUDE and FILTER_EXCLUDE
 * @param text the text of the new filter
 * @param type one of FILTER_MATCH_*
 */
void filter_add_filter (int mode, const char* text, int type);

/** Remove a filter from the current list of filters. */
void remove_filter (class_filter* filter);

#endif /* FILTER_H */

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
