(in-package :crypto-tests)


;;; tests from the RFC

(ecb-mode-test "0123456712" "0123456789ABCDEF" "7AC816D16E9B302E")
(ecb-mode-test "01234567123456782345" "0123456789ABCDEF" "EB6A711A2C02271B")
(ecb-mode-test "0123456712345678234567893456789A" "0123456789ABCDEF" "238B4FE5847E44B2")

;;; tests from NESSIE (http://www.cryptonessie.org/)

(ecb-mode-test "80000000000000000000000000000000" "0000000000000000" "EF854DE5D7D1895B")
(ecb-mode-test "40000000000000000000000000000000" "0000000000000000" "3E50834A3AFDD951")
(ecb-mode-test "20000000000000000000000000000000" "0000000000000000" "6C5FA655407A380E")
(ecb-mode-test "10000000000000000000000000000000" "0000000000000000" "B0DFC4E5C9F257BC")
(ecb-mode-test "08000000000000000000000000000000" "0000000000000000" "3F822FB3B0C9C28C")
(ecb-mode-test "04000000000000000000000000000000" "0000000000000000" "75B2AC4AB060F043")
(ecb-mode-test "02000000000000000000000000000000" "0000000000000000" "935AC5D1CCE3C5CD")
(ecb-mode-test "01000000000000000000000000000000" "0000000000000000" "9E468256E0979A5F")
(ecb-mode-test "00800000000000000000000000000000" "0000000000000000" "59F292BD3B08D7AC")
(ecb-mode-test "00400000000000000000000000000000" "0000000000000000" "546C4968B908E896")
(ecb-mode-test "00200000000000000000000000000000" "0000000000000000" "D43D7E92F3AA127F")
(ecb-mode-test "00100000000000000000000000000000" "0000000000000000" "7AC9BE73E70B1312")
(ecb-mode-test "00080000000000000000000000000000" "0000000000000000" "0600189023CA09D1")
(ecb-mode-test "00040000000000000000000000000000" "0000000000000000" "2FB6C23C21451925")
(ecb-mode-test "00020000000000000000000000000000" "0000000000000000" "8803FB7B0DB7A9A3")
(ecb-mode-test "00010000000000000000000000000000" "0000000000000000" "93A4702D63844097")
(ecb-mode-test "00008000000000000000000000000000" "0000000000000000" "02F5E8FAECBD2EC2")
(ecb-mode-test "00004000000000000000000000000000" "0000000000000000" "3F92299A5CC63B4A")
(ecb-mode-test "00002000000000000000000000000000" "0000000000000000" "484DCE47A87047F3")
(ecb-mode-test "00001000000000000000000000000000" "0000000000000000" "2D51FE333776874E")
(ecb-mode-test "00000800000000000000000000000000" "0000000000000000" "01E49D47516FFEB1")
(ecb-mode-test "00000400000000000000000000000000" "0000000000000000" "F4914E49CEADD52D")
(ecb-mode-test "00000200000000000000000000000000" "0000000000000000" "B58E493FDA5ED282")
(ecb-mode-test "00000100000000000000000000000000" "0000000000000000" "4C6CED3D1759C223")
(ecb-mode-test "00000080000000000000000000000000" "0000000000000000" "C05CFC0A3B6360EA")
(ecb-mode-test "00000040000000000000000000000000" "0000000000000000" "20DB6A71F0B2DB90")
(ecb-mode-test "00000020000000000000000000000000" "0000000000000000" "EEAC9804EBA612D7")
(ecb-mode-test "00000010000000000000000000000000" "0000000000000000" "65B4AA119CDD25AF")
(ecb-mode-test "00000008000000000000000000000000" "0000000000000000" "F781BBAB06314E4D")
(ecb-mode-test "00000004000000000000000000000000" "0000000000000000" "1A2D537BC7AA0807")
(ecb-mode-test "00000002000000000000000000000000" "0000000000000000" "C425E1DE6236DE88")
(ecb-mode-test "00000001000000000000000000000000" "0000000000000000" "854911691D25C05F")
(ecb-mode-test "00000000800000000000000000000000" "0000000000000000" "016D443DD0EF4506")
(ecb-mode-test "00000000400000000000000000000000" "0000000000000000" "5C1381E9C8BFCDCC")
(ecb-mode-test "00000000200000000000000000000000" "0000000000000000" "BACFB74E0D6BE8B6")
(ecb-mode-test "00000000100000000000000000000000" "0000000000000000" "168158BA1958DD41")
(ecb-mode-test "00000000080000000000000000000000" "0000000000000000" "322D903D31B14135")
(ecb-mode-test "00000000040000000000000000000000" "0000000000000000" "D50F1567B1C3149F")
(ecb-mode-test "00000000020000000000000000000000" "0000000000000000" "CBADCB678491508C")
(ecb-mode-test "00000000010000000000000000000000" "0000000000000000" "22CF0E4D2C488AF2")
(ecb-mode-test "00000000008000000000000000000000" "0000000000000000" "BEE20899A559EF68")
(ecb-mode-test "00000000004000000000000000000000" "0000000000000000" "A3996936624E2B2C")
(ecb-mode-test "00000000002000000000000000000000" "0000000000000000" "8313130424DD980C")
(ecb-mode-test "00000000001000000000000000000000" "0000000000000000" "B28DF6C2F87CF763")
(ecb-mode-test "00000000000800000000000000000000" "0000000000000000" "0C1292506F532F78")
(ecb-mode-test "00000000000400000000000000000000" "0000000000000000" "B13AA665278546D5")
(ecb-mode-test "00000000000200000000000000000000" "0000000000000000" "30E40EA440176A8C")
(ecb-mode-test "00000000000100000000000000000000" "0000000000000000" "38434853FD54CB3B")
(ecb-mode-test "00000000000080000000000000000000" "0000000000000000" "A082786343D6E937")
(ecb-mode-test "00000000000040000000000000000000" "0000000000000000" "1F4C394EEE7BE70A")
(ecb-mode-test "00000000000020000000000000000000" "0000000000000000" "45A8ACC0C530A216")
(ecb-mode-test "00000000000010000000000000000000" "0000000000000000" "90341ACAF300CCCE")
(ecb-mode-test "00000000000008000000000000000000" "0000000000000000" "B791785F3A2038A0")
(ecb-mode-test "00000000000004000000000000000000" "0000000000000000" "5FB305CEA7D5E26C")
(ecb-mode-test "00000000000002000000000000000000" "0000000000000000" "1434F39FC8C46F29")
(ecb-mode-test "00000000000001000000000000000000" "0000000000000000" "F250342A891EBB2D")
(ecb-mode-test "00000000000000800000000000000000" "0000000000000000" "1F87C1DFF663D707")
(ecb-mode-test "00000000000000400000000000000000" "0000000000000000" "81B161F882EC1F22")
(ecb-mode-test "00000000000000200000000000000000" "0000000000000000" "8FD52EB0E9DD180A")
(ecb-mode-test "00000000000000100000000000000000" "0000000000000000" "4B3A39BE8061272D")
(ecb-mode-test "00000000000000080000000000000000" "0000000000000000" "3185204FD5BB8A4B")
(ecb-mode-test "00000000000000040000000000000000" "0000000000000000" "02E38E3579A134E4")
(ecb-mode-test "00000000000000020000000000000000" "0000000000000000" "F7BA0DA19ADBE4E6")
(ecb-mode-test "00000000000000010000000000000000" "0000000000000000" "2E8C4128D7022215")
(ecb-mode-test "00000000000000008000000000000000" "0000000000000000" "4E4796EF83C620FD")
(ecb-mode-test "00000000000000004000000000000000" "0000000000000000" "3482EA478149C884")
(ecb-mode-test "00000000000000002000000000000000" "0000000000000000" "46344736AF6FD584")
(ecb-mode-test "00000000000000001000000000000000" "0000000000000000" "B4D0EE3537A03475")
(ecb-mode-test "00000000000000000800000000000000" "0000000000000000" "8783A151DD7DAAB7")
(ecb-mode-test "00000000000000000400000000000000" "0000000000000000" "330156A864ABB7B0")
(ecb-mode-test "00000000000000000200000000000000" "0000000000000000" "FF82D24877E58781")
(ecb-mode-test "00000000000000000100000000000000" "0000000000000000" "23E4303830F8D85A")
(ecb-mode-test "00000000000000000080000000000000" "0000000000000000" "D81D32FF8E00A7B5")
(ecb-mode-test "00000000000000000040000000000000" "0000000000000000" "F8230811ADDFCDB0")
(ecb-mode-test "00000000000000000020000000000000" "0000000000000000" "655F264261BD89A4")
(ecb-mode-test "00000000000000000010000000000000" "0000000000000000" "81A2E3A49901B551")
(ecb-mode-test "00000000000000000008000000000000" "0000000000000000" "71DA16E5350E73A2")
(ecb-mode-test "00000000000000000004000000000000" "0000000000000000" "C25B521F4DC83BD7")
(ecb-mode-test "00000000000000000002000000000000" "0000000000000000" "60A0CD7A8C3DFE95")
(ecb-mode-test "00000000000000000001000000000000" "0000000000000000" "2CCAFA6B45FF4BA8")
(ecb-mode-test "00000000000000000000800000000000" "0000000000000000" "0413C755869B3D20")
(ecb-mode-test "00000000000000000000400000000000" "0000000000000000" "DBB16605E738A58A")
(ecb-mode-test "00000000000000000000200000000000" "0000000000000000" "E737E2DD10133F43")
(ecb-mode-test "00000000000000000000100000000000" "0000000000000000" "EAA0828A257F4663")
(ecb-mode-test "00000000000000000000080000000000" "0000000000000000" "6D72DAD84CA179D4")
(ecb-mode-test "00000000000000000000040000000000" "0000000000000000" "50B88BEDC5321569")
(ecb-mode-test "00000000000000000000020000000000" "0000000000000000" "83A8BFAAC0BB29AE")
(ecb-mode-test "00000000000000000000010000000000" "0000000000000000" "ED8E574A5A904809")
(ecb-mode-test "00000000000000000000008000000000" "0000000000000000" "1DB59E9707C97834")
(ecb-mode-test "00000000000000000000004000000000" "0000000000000000" "66F0E8C29BB0B9CF")
(ecb-mode-test "00000000000000000000002000000000" "0000000000000000" "B2ED3A1531C0D7F6")
(ecb-mode-test "00000000000000000000001000000000" "0000000000000000" "75D742554B503DCF")
(ecb-mode-test "00000000000000000000000800000000" "0000000000000000" "F4BF6E0D513C65D0")
(ecb-mode-test "00000000000000000000000400000000" "0000000000000000" "C49D1E4FF3C60AA7")
(ecb-mode-test "00000000000000000000000200000000" "0000000000000000" "36911221165FDDC2")
(ecb-mode-test "00000000000000000000000100000000" "0000000000000000" "9BF9D1598D21ACD2")
(ecb-mode-test "00000000000000000000000080000000" "0000000000000000" "330794307604F886")
(ecb-mode-test "00000000000000000000000040000000" "0000000000000000" "2DEA71658135D05F")
(ecb-mode-test "00000000000000000000000020000000" "0000000000000000" "F74167923282F52F")
(ecb-mode-test "00000000000000000000000010000000" "0000000000000000" "4A85B2D6D0D923BA")
(ecb-mode-test "00000000000000000000000008000000" "0000000000000000" "C2BA0E432C762ECC")
(ecb-mode-test "00000000000000000000000004000000" "0000000000000000" "C726E9A6D81EEE4D")
(ecb-mode-test "00000000000000000000000002000000" "0000000000000000" "60F7A8BE9DB706AA")
(ecb-mode-test "00000000000000000000000001000000" "0000000000000000" "D10E905544BF1044")
(ecb-mode-test "00000000000000000000000000800000" "0000000000000000" "8912579BE071FD03")
(ecb-mode-test "00000000000000000000000000400000" "0000000000000000" "4EF32D2359D73851")
(ecb-mode-test "00000000000000000000000000200000" "0000000000000000" "6A1E1D7707DCE956")
(ecb-mode-test "00000000000000000000000000100000" "0000000000000000" "898D5490B051FF78")
(ecb-mode-test "00000000000000000000000000080000" "0000000000000000" "19F6F03AAC2C2ED6")
(ecb-mode-test "00000000000000000000000000040000" "0000000000000000" "521EC33A6926B94D")
(ecb-mode-test "00000000000000000000000000020000" "0000000000000000" "D88C0E48553890FB")
(ecb-mode-test "00000000000000000000000000010000" "0000000000000000" "B3D2CC395834671F")
(ecb-mode-test "00000000000000000000000000008000" "0000000000000000" "E5B5723FB3F95A1E")
(ecb-mode-test "00000000000000000000000000004000" "0000000000000000" "050010F1770C302D")
(ecb-mode-test "00000000000000000000000000002000" "0000000000000000" "0F331B1B9151361A")
(ecb-mode-test "00000000000000000000000000001000" "0000000000000000" "472EAC6D605B0506")
(ecb-mode-test "00000000000000000000000000000800" "0000000000000000" "8C07518F6A78FFF7")
(ecb-mode-test "00000000000000000000000000000400" "0000000000000000" "3C6B6CD8950396FB")
(ecb-mode-test "00000000000000000000000000000200" "0000000000000000" "E45F8A602705E91D")
(ecb-mode-test "00000000000000000000000000000100" "0000000000000000" "411A32E76FCCC69D")
(ecb-mode-test "00000000000000000000000000000080" "0000000000000000" "79B212E51932147E")
(ecb-mode-test "00000000000000000000000000000040" "0000000000000000" "B5C3B4D357FCCC09")
(ecb-mode-test "00000000000000000000000000000020" "0000000000000000" "A376C6C50C472008")
(ecb-mode-test "00000000000000000000000000000010" "0000000000000000" "AAD5D1C6A101F3EF")
(ecb-mode-test "00000000000000000000000000000008" "0000000000000000" "D9FC8FCAD48C8207")
(ecb-mode-test "00000000000000000000000000000004" "0000000000000000" "4D9214E4B16C875C")
(ecb-mode-test "00000000000000000000000000000002" "0000000000000000" "AF87AB7B3BA5D255")
(ecb-mode-test "00000000000000000000000000000001" "0000000000000000" "C1E8328DABE3EE01")
(ecb-mode-test "00000000000000000000000000000000" "8000000000000000" "000D844AFCE35696")
(ecb-mode-test "00000000000000000000000000000000" "4000000000000000" "501C44F14E59ABB8")
(ecb-mode-test "00000000000000000000000000000000" "2000000000000000" "C5F833B098A7B4BF")
(ecb-mode-test "00000000000000000000000000000000" "1000000000000000" "12A3910F21AA9689")
(ecb-mode-test "00000000000000000000000000000000" "0800000000000000" "A984BF3C4B606B8A")
(ecb-mode-test "00000000000000000000000000000000" "0400000000000000" "01244E4D4573BEC9")
(ecb-mode-test "00000000000000000000000000000000" "0200000000000000" "33BBD030509A1AAE")
(ecb-mode-test "00000000000000000000000000000000" "0100000000000000" "62C7D78705B69201")
(ecb-mode-test "00000000000000000000000000000000" "0080000000000000" "C2CD4CEB8233AA2C")
(ecb-mode-test "00000000000000000000000000000000" "0040000000000000" "3C518F056EEA080D")
(ecb-mode-test "00000000000000000000000000000000" "0020000000000000" "B053D84D6D776A45")
(ecb-mode-test "00000000000000000000000000000000" "0010000000000000" "F5976B5A23EBD435")
(ecb-mode-test "00000000000000000000000000000000" "0008000000000000" "26EF4E726B4300C6")
(ecb-mode-test "00000000000000000000000000000000" "0004000000000000" "00DE9EE7EF40F784")
(ecb-mode-test "00000000000000000000000000000000" "0002000000000000" "72C2E4721771ADB1")
(ecb-mode-test "00000000000000000000000000000000" "0001000000000000" "6B4E05D55C726980")
(ecb-mode-test "00000000000000000000000000000000" "0000800000000000" "738F32218912DA4B")
(ecb-mode-test "00000000000000000000000000000000" "0000400000000000" "20FC7693F51BCFEE")
(ecb-mode-test "00000000000000000000000000000000" "0000200000000000" "7B3D23EDE2E7F0CC")
(ecb-mode-test "00000000000000000000000000000000" "0000100000000000" "4BC5B57623107A6A")
(ecb-mode-test "00000000000000000000000000000000" "0000080000000000" "36DB7DB56B9DEDED")
(ecb-mode-test "00000000000000000000000000000000" "0000040000000000" "067DDC1B5D970425")
(ecb-mode-test "00000000000000000000000000000000" "0000020000000000" "9F024030D92CA56D")
(ecb-mode-test "00000000000000000000000000000000" "0000010000000000" "70F0BBB5B7668646")
(ecb-mode-test "00000000000000000000000000000000" "0000008000000000" "006EA1887A12D170")
(ecb-mode-test "00000000000000000000000000000000" "0000004000000000" "C0611754E09AA011")
(ecb-mode-test "00000000000000000000000000000000" "0000002000000000" "79BF5E2CAA6A3DAF")
(ecb-mode-test "00000000000000000000000000000000" "0000001000000000" "46ED1F52B5B9559D")
(ecb-mode-test "00000000000000000000000000000000" "0000000800000000" "D190E5631B73C5A6")
(ecb-mode-test "00000000000000000000000000000000" "0000000400000000" "0961B2ECFFD93933")
(ecb-mode-test "00000000000000000000000000000000" "0000000200000000" "94264A0ED5203638")
(ecb-mode-test "00000000000000000000000000000000" "0000000100000000" "C67A47D369B57B85")
(ecb-mode-test "00000000000000000000000000000000" "0000000080000000" "342D7633EF48BCEB")
(ecb-mode-test "00000000000000000000000000000000" "0000000040000000" "7EFC3B1845D986EB")
(ecb-mode-test "00000000000000000000000000000000" "0000000020000000" "B56EA85BFFBC0FA4")
(ecb-mode-test "00000000000000000000000000000000" "0000000010000000" "CABE3D27862D5EFB")
(ecb-mode-test "00000000000000000000000000000000" "0000000008000000" "BA4DF14185FF32AF")
(ecb-mode-test "00000000000000000000000000000000" "0000000004000000" "8F0289AA45946E16")
(ecb-mode-test "00000000000000000000000000000000" "0000000002000000" "2192A1C13CAB0749")
(ecb-mode-test "00000000000000000000000000000000" "0000000001000000" "5B577B8E9128FD84")
(ecb-mode-test "00000000000000000000000000000000" "0000000000800000" "4C4EA46E8C096255")
(ecb-mode-test "00000000000000000000000000000000" "0000000000400000" "0CB194032F16B8DA")
(ecb-mode-test "00000000000000000000000000000000" "0000000000200000" "4507939A7EC4040A")
(ecb-mode-test "00000000000000000000000000000000" "0000000000100000" "3276C89846D533C7")
(ecb-mode-test "00000000000000000000000000000000" "0000000000080000" "AB68E284B76F7256")
(ecb-mode-test "00000000000000000000000000000000" "0000000000040000" "E3004D46218B9428")
(ecb-mode-test "00000000000000000000000000000000" "0000000000020000" "61BFF8D033E47310")
(ecb-mode-test "00000000000000000000000000000000" "0000000000010000" "E08CC3CAEFCAC0F8")
(ecb-mode-test "00000000000000000000000000000000" "0000000000008000" "B986D33C7B8AF266")
(ecb-mode-test "00000000000000000000000000000000" "0000000000004000" "44296DF985D5B6B1")
(ecb-mode-test "00000000000000000000000000000000" "0000000000002000" "6E9D5710AB4C7C78")
(ecb-mode-test "00000000000000000000000000000000" "0000000000001000" "C9793934CFB0614C")
(ecb-mode-test "00000000000000000000000000000000" "0000000000000800" "CDA94B6BFA73C69B")
(ecb-mode-test "00000000000000000000000000000000" "0000000000000400" "CAAD0D61CE248CA9")
(ecb-mode-test "00000000000000000000000000000000" "0000000000000200" "0FABE55E3A8B487A")
(ecb-mode-test "00000000000000000000000000000000" "0000000000000100" "CC692E69AE887249")
(ecb-mode-test "00000000000000000000000000000000" "0000000000000080" "06646851AE39901D")
(ecb-mode-test "00000000000000000000000000000000" "0000000000000040" "3C9596DB1883D2DB")
(ecb-mode-test "00000000000000000000000000000000" "0000000000000020" "095CCA9A1A84E38B")
(ecb-mode-test "00000000000000000000000000000000" "0000000000000010" "BCE9B8F3CC34E9F9")
(ecb-mode-test "00000000000000000000000000000000" "0000000000000008" "1B451B8B885A7DA8")
(ecb-mode-test "00000000000000000000000000000000" "0000000000000004" "0332D472F9FF9EE1")
(ecb-mode-test "00000000000000000000000000000000" "0000000000000002" "5102D2D608639663")
(ecb-mode-test "00000000000000000000000000000000" "0000000000000001" "D4B9607C9B9EEF9B")
(ecb-mode-test "00000000000000000000000000000000" "0000000000000000" "13C502B354D53871")
(ecb-mode-test "01010101010101010101010101010101" "0101010101010101" "03EA441C3CE90553")
(ecb-mode-test "02020202020202020202020202020202" "0202020202020202" "0FCE7D728F6138AE")
(ecb-mode-test "03030303030303030303030303030303" "0303030303030303" "C947BAABF7FFF0A1")
(ecb-mode-test "04040404040404040404040404040404" "0404040404040404" "044AB7D6A2E875E4")
(ecb-mode-test "05050505050505050505050505050505" "0505050505050505" "F3076E0480FD1B9F")
(ecb-mode-test "06060606060606060606060606060606" "0606060606060606" "23F99D1EFDA9204B")
(ecb-mode-test "07070707070707070707070707070707" "0707070707070707" "D5F0ACAB764761E1")
(ecb-mode-test "08080808080808080808080808080808" "0808080808080808" "C3F818B9E6BFAF33")
(ecb-mode-test "09090909090909090909090909090909" "0909090909090909" "D5EA1A88D4F48803")
(ecb-mode-test "0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A" "0A0A0A0A0A0A0A0A" "E77CFAA6EDE580A1")
(ecb-mode-test "0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B" "0B0B0B0B0B0B0B0B" "15EFD651E1469057")
(ecb-mode-test "0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C" "0C0C0C0C0C0C0C0C" "CDA162911E3C2405")
(ecb-mode-test "0D0D0D0D0D0D0D0D0D0D0D0D0D0D0D0D" "0D0D0D0D0D0D0D0D" "F63245D5A06EEC7B")
(ecb-mode-test "0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E" "0E0E0E0E0E0E0E0E" "C87E8750FF8FDDD4")
(ecb-mode-test "0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F" "0F0F0F0F0F0F0F0F" "7668146E424460DE")
(ecb-mode-test "10101010101010101010101010101010" "1010101010101010" "55A07970924FC77B")
(ecb-mode-test "11111111111111111111111111111111" "1111111111111111" "1FC34DB8EBF21BC0")
(ecb-mode-test "12121212121212121212121212121212" "1212121212121212" "EF0051C5DDEC53A9")
(ecb-mode-test "13131313131313131313131313131313" "1313131313131313" "C43D14B8FF13251B")
(ecb-mode-test "14141414141414141414141414141414" "1414141414141414" "2DAC46CD829D08EE")
(ecb-mode-test "15151515151515151515151515151515" "1515151515151515" "60895337A0C292FA")
(ecb-mode-test "16161616161616161616161616161616" "1616161616161616" "D6E7AD831E3BACD4")
(ecb-mode-test "17171717171717171717171717171717" "1717171717171717" "104F8AF1497AE9E2")
(ecb-mode-test "18181818181818181818181818181818" "1818181818181818" "D07DA88C9CB8D1D1")
(ecb-mode-test "19191919191919191919191919191919" "1919191919191919" "74B3CD54797F7C64")
(ecb-mode-test "1A1A1A1A1A1A1A1A1A1A1A1A1A1A1A1A" "1A1A1A1A1A1A1A1A" "E483B165F91F88E4")
(ecb-mode-test "1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B" "1B1B1B1B1B1B1B1B" "4E30A66C0340CB32")
(ecb-mode-test "1C1C1C1C1C1C1C1C1C1C1C1C1C1C1C1C" "1C1C1C1C1C1C1C1C" "67B392DDD4D60B3B")
(ecb-mode-test "1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D" "1D1D1D1D1D1D1D1D" "5A173639029747FE")
(ecb-mode-test "1E1E1E1E1E1E1E1E1E1E1E1E1E1E1E1E" "1E1E1E1E1E1E1E1E" "4774317AA39EFF49")
(ecb-mode-test "1F1F1F1F1F1F1F1F1F1F1F1F1F1F1F1F" "1F1F1F1F1F1F1F1F" "B52B9DC6A941A7A8")
(ecb-mode-test "20202020202020202020202020202020" "2020202020202020" "D24C12E60F182DE3")
(ecb-mode-test "21212121212121212121212121212121" "2121212121212121" "C90077A6371469E0")
(ecb-mode-test "22222222222222222222222222222222" "2222222222222222" "636C807E203B032A")
(ecb-mode-test "23232323232323232323232323232323" "2323232323232323" "91578F2FDE1EBD73")
(ecb-mode-test "24242424242424242424242424242424" "2424242424242424" "647B7B36BBA9AB7D")
(ecb-mode-test "25252525252525252525252525252525" "2525252525252525" "42E42E1B513D4110")
(ecb-mode-test "26262626262626262626262626262626" "2626262626262626" "92CC5DBF71818457")
(ecb-mode-test "27272727272727272727272727272727" "2727272727272727" "D34CF5D065DA63B8")
(ecb-mode-test "28282828282828282828282828282828" "2828282828282828" "805876D05C017BC3")
(ecb-mode-test "29292929292929292929292929292929" "2929292929292929" "A8EACC2F2BE0AA6D")
(ecb-mode-test "2A2A2A2A2A2A2A2A2A2A2A2A2A2A2A2A" "2A2A2A2A2A2A2A2A" "24A1F474DD90B566")
(ecb-mode-test "2B2B2B2B2B2B2B2B2B2B2B2B2B2B2B2B" "2B2B2B2B2B2B2B2B" "F3E09755FA8D5D91")
(ecb-mode-test "2C2C2C2C2C2C2C2C2C2C2C2C2C2C2C2C" "2C2C2C2C2C2C2C2C" "841B00C99FE2F11B")
(ecb-mode-test "2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D" "2D2D2D2D2D2D2D2D" "A1CCCAABFD533449")
(ecb-mode-test "2E2E2E2E2E2E2E2E2E2E2E2E2E2E2E2E" "2E2E2E2E2E2E2E2E" "10E6ECAA6163E77B")
(ecb-mode-test "2F2F2F2F2F2F2F2F2F2F2F2F2F2F2F2F" "2F2F2F2F2F2F2F2F" "209BB27B03EC7D9A")
(ecb-mode-test "30303030303030303030303030303030" "3030303030303030" "0966DA2B6BC0E033")
(ecb-mode-test "31313131313131313131313131313131" "3131313131313131" "7379A558117B1963")
(ecb-mode-test "32323232323232323232323232323232" "3232323232323232" "8B24CFACC88DF2A6")
(ecb-mode-test "33333333333333333333333333333333" "3333333333333333" "ED96F5C0E5D76A2D")
(ecb-mode-test "34343434343434343434343434343434" "3434343434343434" "BA1CCCBEBD793F2D")
(ecb-mode-test "35353535353535353535353535353535" "3535353535353535" "0A590DF4D85B90CA")
(ecb-mode-test "36363636363636363636363636363636" "3636363636363636" "206B0F8919CCD4CB")
(ecb-mode-test "37373737373737373737373737373737" "3737373737373737" "31145228A354A0C9")
(ecb-mode-test "38383838383838383838383838383838" "3838383838383838" "9599CC2E07EDCDF7")
(ecb-mode-test "39393939393939393939393939393939" "3939393939393939" "55FB8CB5FCE94871")
(ecb-mode-test "3A3A3A3A3A3A3A3A3A3A3A3A3A3A3A3A" "3A3A3A3A3A3A3A3A" "1B0204E231F94CAC")
(ecb-mode-test "3B3B3B3B3B3B3B3B3B3B3B3B3B3B3B3B" "3B3B3B3B3B3B3B3B" "CC6875BF02D0EDC8")
(ecb-mode-test "3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C" "3C3C3C3C3C3C3C3C" "C04004650588AEF6")
(ecb-mode-test "3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D" "3D3D3D3D3D3D3D3D" "27D1240ED40118FB")
(ecb-mode-test "3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E" "3E3E3E3E3E3E3E3E" "FC1DCF3AF7589533")
(ecb-mode-test "3F3F3F3F3F3F3F3F3F3F3F3F3F3F3F3F" "3F3F3F3F3F3F3F3F" "36D344B3027BC561")
(ecb-mode-test "40404040404040404040404040404040" "4040404040404040" "BF62D780F4A4340B")
(ecb-mode-test "41414141414141414141414141414141" "4141414141414141" "1922B7FC3F6C54E4")
(ecb-mode-test "42424242424242424242424242424242" "4242424242424242" "2B3C44ABB2A2F6B9")
(ecb-mode-test "43434343434343434343434343434343" "4343434343434343" "2BF4CA6564107AA5")
(ecb-mode-test "44444444444444444444444444444444" "4444444444444444" "0DE485ED95EB7916")
(ecb-mode-test "45454545454545454545454545454545" "4545454545454545" "ADF827AEA3D7B480")
(ecb-mode-test "46464646464646464646464646464646" "4646464646464646" "5400D10D3EA493E3")
(ecb-mode-test "47474747474747474747474747474747" "4747474747474747" "5FF846D6EE31BEAB")
(ecb-mode-test "48484848484848484848484848484848" "4848484848484848" "10CFCE9C3F6D6744")
(ecb-mode-test "49494949494949494949494949494949" "4949494949494949" "4F059F1D68F94763")
(ecb-mode-test "4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A" "4A4A4A4A4A4A4A4A" "164876F0AF5BE32D")
(ecb-mode-test "4B4B4B4B4B4B4B4B4B4B4B4B4B4B4B4B" "4B4B4B4B4B4B4B4B" "45982518CF0CC3D4")
(ecb-mode-test "4C4C4C4C4C4C4C4C4C4C4C4C4C4C4C4C" "4C4C4C4C4C4C4C4C" "1288424AAB4DBBF1")
(ecb-mode-test "4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D" "4D4D4D4D4D4D4D4D" "2C54BE0B869B541E")
(ecb-mode-test "4E4E4E4E4E4E4E4E4E4E4E4E4E4E4E4E" "4E4E4E4E4E4E4E4E" "189E6AB98E9EAD08")
(ecb-mode-test "4F4F4F4F4F4F4F4F4F4F4F4F4F4F4F4F" "4F4F4F4F4F4F4F4F" "CE1E08676A9F70CC")
(ecb-mode-test "50505050505050505050505050505050" "5050505050505050" "54504A4E9D5B7B9C")
(ecb-mode-test "51515151515151515151515151515151" "5151515151515151" "0AC63B5D7D8BEE3B")
(ecb-mode-test "52525252525252525252525252525252" "5252525252525252" "A8CD8824E3E9B510")
(ecb-mode-test "53535353535353535353535353535353" "5353535353535353" "75C2D459ADEE5E6C")
(ecb-mode-test "54545454545454545454545454545454" "5454545454545454" "F9EEBCBF321C576C")
(ecb-mode-test "55555555555555555555555555555555" "5555555555555555" "916720C6878CDFB1")
(ecb-mode-test "56565656565656565656565656565656" "5656565656565656" "4D70959A24DAB704")
(ecb-mode-test "57575757575757575757575757575757" "5757575757575757" "46B082FD94327BCF")
(ecb-mode-test "58585858585858585858585858585858" "5858585858585858" "8DEA569C738AE33D")
(ecb-mode-test "59595959595959595959595959595959" "5959595959595959" "F6BF0BC30C91AE2F")
(ecb-mode-test "5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A" "5A5A5A5A5A5A5A5A" "45E6FBFFB680F50A")
(ecb-mode-test "5B5B5B5B5B5B5B5B5B5B5B5B5B5B5B5B" "5B5B5B5B5B5B5B5B" "FCF0779EA34683B7")
(ecb-mode-test "5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C" "5C5C5C5C5C5C5C5C" "7189B7F0A6F66705")
(ecb-mode-test "5D5D5D5D5D5D5D5D5D5D5D5D5D5D5D5D" "5D5D5D5D5D5D5D5D" "9857CD8DBDAC4218")
(ecb-mode-test "5E5E5E5E5E5E5E5E5E5E5E5E5E5E5E5E" "5E5E5E5E5E5E5E5E" "667D23D8D2E4918E")
(ecb-mode-test "5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F" "5F5F5F5F5F5F5F5F" "E71E41A4AE4064E7")
(ecb-mode-test "60606060606060606060606060606060" "6060606060606060" "D14105DA05845F1D")
(ecb-mode-test "61616161616161616161616161616161" "6161616161616161" "F7EA089B0C135B31")
(ecb-mode-test "62626262626262626262626262626262" "6262626262626262" "3C66E859B6C77122")
(ecb-mode-test "63636363636363636363636363636363" "6363636363636363" "B957E277BF8AD53A")
(ecb-mode-test "64646464646464646464646464646464" "6464646464646464" "4569435BDD43C104")
(ecb-mode-test "65656565656565656565656565656565" "6565656565656565" "79CD41DB6991CACB")
(ecb-mode-test "66666666666666666666666666666666" "6666666666666666" "4ABD7FBB9A50D520")
(ecb-mode-test "67676767676767676767676767676767" "6767676767676767" "9755C63EA9C43E15")
(ecb-mode-test "68686868686868686868686868686868" "6868686868686868" "95EE3C2F402A43AB")
(ecb-mode-test "69696969696969696969696969696969" "6969696969696969" "225BED53D34E01F2")
(ecb-mode-test "6A6A6A6A6A6A6A6A6A6A6A6A6A6A6A6A" "6A6A6A6A6A6A6A6A" "479C7B1C099158F3")
(ecb-mode-test "6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B" "6B6B6B6B6B6B6B6B" "171476C71BBD0079")
(ecb-mode-test "6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C" "6C6C6C6C6C6C6C6C" "C0AF0E4CB0E4B4A4")
(ecb-mode-test "6D6D6D6D6D6D6D6D6D6D6D6D6D6D6D6D" "6D6D6D6D6D6D6D6D" "776B48A129A470FE")
(ecb-mode-test "6E6E6E6E6E6E6E6E6E6E6E6E6E6E6E6E" "6E6E6E6E6E6E6E6E" "1192D5C8FD231A9F")
(ecb-mode-test "6F6F6F6F6F6F6F6F6F6F6F6F6F6F6F6F" "6F6F6F6F6F6F6F6F" "1C11E716290F3E23")
(ecb-mode-test "70707070707070707070707070707070" "7070707070707070" "82ADF4FFB3F5CC1C")
(ecb-mode-test "71717171717171717171717171717171" "7171717171717171" "78C75F6FFABE43F3")
(ecb-mode-test "72727272727272727272727272727272" "7272727272727272" "05A191935E72562C")
(ecb-mode-test "73737373737373737373737373737373" "7373737373737373" "845F14C8316AA12C")
(ecb-mode-test "74747474747474747474747474747474" "7474747474747474" "8DACA678721295EC")
(ecb-mode-test "75757575757575757575757575757575" "7575757575757575" "8F85A5931E371A1C")
(ecb-mode-test "76767676767676767676767676767676" "7676767676767676" "DFE4B0D5FD51C611")
(ecb-mode-test "77777777777777777777777777777777" "7777777777777777" "2EDDD077EC82D42C")
(ecb-mode-test "78787878787878787878787878787878" "7878787878787878" "08C12EF5A29A34C3")
(ecb-mode-test "79797979797979797979797979797979" "7979797979797979" "C2E689A5926B1469")
(ecb-mode-test "7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A" "7A7A7A7A7A7A7A7A" "89264B9EA39B750C")
(ecb-mode-test "7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B" "7B7B7B7B7B7B7B7B" "F55FF33E57E15027")
(ecb-mode-test "7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C" "7C7C7C7C7C7C7C7C" "B4211BF2050986A5")
(ecb-mode-test "7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D" "7D7D7D7D7D7D7D7D" "59E3D7AE37632B3C")
(ecb-mode-test "7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E" "7E7E7E7E7E7E7E7E" "1DCD98BF8E3CEFDA")
(ecb-mode-test "7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F" "7F7F7F7F7F7F7F7F" "FA1FDCE135BDFA6A")
(ecb-mode-test "80808080808080808080808080808080" "8080808080808080" "F481C569295DA7B8")
(ecb-mode-test "81818181818181818181818181818181" "8181818181818181" "647D9D7FB4CD1444")
(ecb-mode-test "82828282828282828282828282828282" "8282828282828282" "E0AC3FE4289B03DC")
(ecb-mode-test "83838383838383838383838383838383" "8383838383838383" "9E3A6BE24809A5EA")
(ecb-mode-test "84848484848484848484848484848484" "8484848484848484" "0A550D4300434938")
(ecb-mode-test "85858585858585858585858585858585" "8585858585858585" "FA28C2C72CDBD40F")
(ecb-mode-test "86868686868686868686868686868686" "8686868686868686" "5507C230A13FA64E")
(ecb-mode-test "87878787878787878787878787878787" "8787878787878787" "C0865623E4C0530A")
(ecb-mode-test "88888888888888888888888888888888" "8888888888888888" "4FAF087BAB3C0410")
(ecb-mode-test "89898989898989898989898989898989" "8989898989898989" "50AA81BF2CFC0D92")
(ecb-mode-test "8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A" "8A8A8A8A8A8A8A8A" "E9F95FA12EC17C51")
(ecb-mode-test "8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B" "8B8B8B8B8B8B8B8B" "CE3BE6306F62212E")
(ecb-mode-test "8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C" "8C8C8C8C8C8C8C8C" "2E774C21F352645A")
(ecb-mode-test "8D8D8D8D8D8D8D8D8D8D8D8D8D8D8D8D" "8D8D8D8D8D8D8D8D" "FB60C17D755F16F3")
(ecb-mode-test "8E8E8E8E8E8E8E8E8E8E8E8E8E8E8E8E" "8E8E8E8E8E8E8E8E" "B7520F518D36A0F1")
(ecb-mode-test "8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F" "8F8F8F8F8F8F8F8F" "4494B183948C451C")
(ecb-mode-test "90909090909090909090909090909090" "9090909090909090" "5714C7D798BBFE1C")
(ecb-mode-test "91919191919191919191919191919191" "9191919191919191" "7C4B8A8B0749981F")
(ecb-mode-test "92929292929292929292929292929292" "9292929292929292" "BB67FEC861FBEA45")
(ecb-mode-test "93939393939393939393939393939393" "9393939393939393" "1FDB856313CB5B2C")
(ecb-mode-test "94949494949494949494949494949494" "9494949494949494" "A16B1E9E02527BF8")
(ecb-mode-test "95959595959595959595959595959595" "9595959595959595" "FBE639AA0E97E7E4")
(ecb-mode-test "96969696969696969696969696969696" "9696969696969696" "DE1198A1E8346884")
(ecb-mode-test "97979797979797979797979797979797" "9797979797979797" "365C214A1DEA8676")
(ecb-mode-test "98989898989898989898989898989898" "9898989898989898" "B9EDBCEED003C29C")
(ecb-mode-test "99999999999999999999999999999999" "9999999999999999" "DB13FD14584AD7B9")
(ecb-mode-test "9A9A9A9A9A9A9A9A9A9A9A9A9A9A9A9A" "9A9A9A9A9A9A9A9A" "934BB6498EC4785B")
(ecb-mode-test "9B9B9B9B9B9B9B9B9B9B9B9B9B9B9B9B" "9B9B9B9B9B9B9B9B" "DF3A81E1F605CBEC")
(ecb-mode-test "9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C" "9C9C9C9C9C9C9C9C" "B605EE708B899F73")
(ecb-mode-test "9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D" "9D9D9D9D9D9D9D9D" "C3B3329AD1441719")
(ecb-mode-test "9E9E9E9E9E9E9E9E9E9E9E9E9E9E9E9E" "9E9E9E9E9E9E9E9E" "00513DEC53CE2736")
(ecb-mode-test "9F9F9F9F9F9F9F9F9F9F9F9F9F9F9F9F" "9F9F9F9F9F9F9F9F" "E325603C3766D2F6")
(ecb-mode-test "A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0" "A0A0A0A0A0A0A0A0" "0F7F21E937709510")
(ecb-mode-test "A1A1A1A1A1A1A1A1A1A1A1A1A1A1A1A1" "A1A1A1A1A1A1A1A1" "F7AA07D98F058599")
(ecb-mode-test "A2A2A2A2A2A2A2A2A2A2A2A2A2A2A2A2" "A2A2A2A2A2A2A2A2" "B5B59A5477E3FB06")
(ecb-mode-test "A3A3A3A3A3A3A3A3A3A3A3A3A3A3A3A3" "A3A3A3A3A3A3A3A3" "4C2BC22974B7734D")
(ecb-mode-test "A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4A4" "A4A4A4A4A4A4A4A4" "55C2E6838C1FF979")
(ecb-mode-test "A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5" "A5A5A5A5A5A5A5A5" "5A1B17C8BBCE9BBC")
(ecb-mode-test "A6A6A6A6A6A6A6A6A6A6A6A6A6A6A6A6" "A6A6A6A6A6A6A6A6" "4ED8F930538870D0")
(ecb-mode-test "A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7A7" "A7A7A7A7A7A7A7A7" "B0D825A1973C112E")
(ecb-mode-test "A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8A8" "A8A8A8A8A8A8A8A8" "579678CE5CF2364B")
(ecb-mode-test "A9A9A9A9A9A9A9A9A9A9A9A9A9A9A9A9" "A9A9A9A9A9A9A9A9" "4A66F8DAD0B92B40")
(ecb-mode-test "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" "AAAAAAAAAAAAAAAA" "5E51CBC951FED9ED")
(ecb-mode-test "ABABABABABABABABABABABABABABABAB" "ABABABABABABABAB" "162D697D599BEBAF")
(ecb-mode-test "ACACACACACACACACACACACACACACACAC" "ACACACACACACACAC" "25C479AC7DCBB3C5")
(ecb-mode-test "ADADADADADADADADADADADADADADADAD" "ADADADADADADADAD" "873C3DB72B6C17EF")
(ecb-mode-test "AEAEAEAEAEAEAEAEAEAEAEAEAEAEAEAE" "AEAEAEAEAEAEAEAE" "62D1CD613580EFED")
(ecb-mode-test "AFAFAFAFAFAFAFAFAFAFAFAFAFAFAFAF" "AFAFAFAFAFAFAFAF" "1C140194BC8FB722")
(ecb-mode-test "B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0B0" "B0B0B0B0B0B0B0B0" "1C17392342782F74")
(ecb-mode-test "B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1B1" "B1B1B1B1B1B1B1B1" "4725C78D37917825")
(ecb-mode-test "B2B2B2B2B2B2B2B2B2B2B2B2B2B2B2B2" "B2B2B2B2B2B2B2B2" "72784284349B1D90")
(ecb-mode-test "B3B3B3B3B3B3B3B3B3B3B3B3B3B3B3B3" "B3B3B3B3B3B3B3B3" "83454AB3F4A47246")
(ecb-mode-test "B4B4B4B4B4B4B4B4B4B4B4B4B4B4B4B4" "B4B4B4B4B4B4B4B4" "9F33B1421DB9FB61")
(ecb-mode-test "B5B5B5B5B5B5B5B5B5B5B5B5B5B5B5B5" "B5B5B5B5B5B5B5B5" "77A779C1D3757406")
(ecb-mode-test "B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6" "B6B6B6B6B6B6B6B6" "90314C094B0E23AF")
(ecb-mode-test "B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7" "B7B7B7B7B7B7B7B7" "1D50C146124AA364")
(ecb-mode-test "B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8B8" "B8B8B8B8B8B8B8B8" "0FF2A5C6FAA86AB5")
(ecb-mode-test "B9B9B9B9B9B9B9B9B9B9B9B9B9B9B9B9" "B9B9B9B9B9B9B9B9" "9005E3F81FE3E8BB")
(ecb-mode-test "BABABABABABABABABABABABABABABABA" "BABABABABABABABA" "3DDC8B59E763022B")
(ecb-mode-test "BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB" "BBBBBBBBBBBBBBBB" "731C525F69C08501")
(ecb-mode-test "BCBCBCBCBCBCBCBCBCBCBCBCBCBCBCBC" "BCBCBCBCBCBCBCBC" "106DA3CDEB2D6D0B")
(ecb-mode-test "BDBDBDBDBDBDBDBDBDBDBDBDBDBDBDBD" "BDBDBDBDBDBDBDBD" "419B11BC936DD5DD")
(ecb-mode-test "BEBEBEBEBEBEBEBEBEBEBEBEBEBEBEBE" "BEBEBEBEBEBEBEBE" "74FC227708EAA900")
(ecb-mode-test "BFBFBFBFBFBFBFBFBFBFBFBFBFBFBFBF" "BFBFBFBFBFBFBFBF" "9C6AEA6BB5EAA0A1")
(ecb-mode-test "C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0" "C0C0C0C0C0C0C0C0" "7C3EABDA658C1BE9")
(ecb-mode-test "C1C1C1C1C1C1C1C1C1C1C1C1C1C1C1C1" "C1C1C1C1C1C1C1C1" "3F5A6FB1B799866B")
(ecb-mode-test "C2C2C2C2C2C2C2C2C2C2C2C2C2C2C2C2" "C2C2C2C2C2C2C2C2" "EB3FC8DAC64FE987")
(ecb-mode-test "C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3C3" "C3C3C3C3C3C3C3C3" "41639BFFF983A391")
(ecb-mode-test "C4C4C4C4C4C4C4C4C4C4C4C4C4C4C4C4" "C4C4C4C4C4C4C4C4" "46E998D95C2F7D82")
(ecb-mode-test "C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5C5" "C5C5C5C5C5C5C5C5" "A77869425FBA6F85")
(ecb-mode-test "C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6" "C6C6C6C6C6C6C6C6" "679CC20A4CC8DAE3")
(ecb-mode-test "C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7" "C7C7C7C7C7C7C7C7" "FC63CD59B387F7EB")
(ecb-mode-test "C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8" "C8C8C8C8C8C8C8C8" "806239D1D675EC08")
(ecb-mode-test "C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9" "C9C9C9C9C9C9C9C9" "2D45484E913A2264")
(ecb-mode-test "CACACACACACACACACACACACACACACACA" "CACACACACACACACA" "DB12E39337991E6E")
(ecb-mode-test "CBCBCBCBCBCBCBCBCBCBCBCBCBCBCBCB" "CBCBCBCBCBCBCBCB" "986EB04CE6B5C83B")
(ecb-mode-test "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC" "CCCCCCCCCCCCCCCC" "74B7ACB1C4E54E47")
(ecb-mode-test "CDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCD" "CDCDCDCDCDCDCDCD" "0A3E756B2F5D3B78")
(ecb-mode-test "CECECECECECECECECECECECECECECECE" "CECECECECECECECE" "CCD7203A3330E59C")
(ecb-mode-test "CFCFCFCFCFCFCFCFCFCFCFCFCFCFCFCF" "CFCFCFCFCFCFCFCF" "231CFD138D215FCE")
(ecb-mode-test "D0D0D0D0D0D0D0D0D0D0D0D0D0D0D0D0" "D0D0D0D0D0D0D0D0" "947886BC1713140B")
(ecb-mode-test "D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1D1" "D1D1D1D1D1D1D1D1" "9850392AB1C5DF58")
(ecb-mode-test "D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2" "D2D2D2D2D2D2D2D2" "A3DBDE5CB3B0D14A")
(ecb-mode-test "D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3D3" "D3D3D3D3D3D3D3D3" "516EE0CE139FF3AA")
(ecb-mode-test "D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4D4" "D4D4D4D4D4D4D4D4" "67A08619967B8781")
(ecb-mode-test "D5D5D5D5D5D5D5D5D5D5D5D5D5D5D5D5" "D5D5D5D5D5D5D5D5" "4237C2B1C20AD741")
(ecb-mode-test "D6D6D6D6D6D6D6D6D6D6D6D6D6D6D6D6" "D6D6D6D6D6D6D6D6" "9B270032AF9790D2")
(ecb-mode-test "D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7D7" "D7D7D7D7D7D7D7D7" "F485014561B43A95")
(ecb-mode-test "D8D8D8D8D8D8D8D8D8D8D8D8D8D8D8D8" "D8D8D8D8D8D8D8D8" "794857ED7836797B")
(ecb-mode-test "D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9D9" "D9D9D9D9D9D9D9D9" "BDE24546BF1ABDAE")
(ecb-mode-test "DADADADADADADADADADADADADADADADA" "DADADADADADADADA" "1A33DBE057FDFC3D")
(ecb-mode-test "DBDBDBDBDBDBDBDBDBDBDBDBDBDBDBDB" "DBDBDBDBDBDBDBDB" "F74D857E82C66088")
(ecb-mode-test "DCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDC" "DCDCDCDCDCDCDCDC" "88D72547385B1D2F")
(ecb-mode-test "DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD" "DDDDDDDDDDDDDDDD" "E3CA2146C71CE583")
(ecb-mode-test "DEDEDEDEDEDEDEDEDEDEDEDEDEDEDEDE" "DEDEDEDEDEDEDEDE" "2818AAF1A02205A6")
(ecb-mode-test "DFDFDFDFDFDFDFDFDFDFDFDFDFDFDFDF" "DFDFDFDFDFDFDFDF" "27DCAA26208ACA3D")
(ecb-mode-test "E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0E0" "E0E0E0E0E0E0E0E0" "8CD523F19F6A269F")
(ecb-mode-test "E1E1E1E1E1E1E1E1E1E1E1E1E1E1E1E1" "E1E1E1E1E1E1E1E1" "D5AEA349553161E2")
(ecb-mode-test "E2E2E2E2E2E2E2E2E2E2E2E2E2E2E2E2" "E2E2E2E2E2E2E2E2" "64EB3CFAEFDDD61C")
(ecb-mode-test "E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3E3" "E3E3E3E3E3E3E3E3" "CAAABD1E2F033824")
(ecb-mode-test "E4E4E4E4E4E4E4E4E4E4E4E4E4E4E4E4" "E4E4E4E4E4E4E4E4" "60CAFDD281C139F9")
(ecb-mode-test "E5E5E5E5E5E5E5E5E5E5E5E5E5E5E5E5" "E5E5E5E5E5E5E5E5" "5F738EBA5C7D179E")
(ecb-mode-test "E6E6E6E6E6E6E6E6E6E6E6E6E6E6E6E6" "E6E6E6E6E6E6E6E6" "53203C41C2C28ED7")
(ecb-mode-test "E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7E7" "E7E7E7E7E7E7E7E7" "811A8F9F1BCDFE9C")
(ecb-mode-test "E8E8E8E8E8E8E8E8E8E8E8E8E8E8E8E8" "E8E8E8E8E8E8E8E8" "933989D7EF56E534")
(ecb-mode-test "E9E9E9E9E9E9E9E9E9E9E9E9E9E9E9E9" "E9E9E9E9E9E9E9E9" "F246C569E15DBADC")
(ecb-mode-test "EAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEA" "EAEAEAEAEAEAEAEA" "FF7EC5C73AA4D892")
(ecb-mode-test "EBEBEBEBEBEBEBEBEBEBEBEBEBEBEBEB" "EBEBEBEBEBEBEBEB" "BF744BED738C8060")
(ecb-mode-test "ECECECECECECECECECECECECECECECEC" "ECECECECECECECEC" "893AF631836FC721")
(ecb-mode-test "EDEDEDEDEDEDEDEDEDEDEDEDEDEDEDED" "EDEDEDEDEDEDEDED" "B196D17B5BD8EB03")
(ecb-mode-test "EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE" "EEEEEEEEEEEEEEEE" "C3854743B8E39971")
(ecb-mode-test "EFEFEFEFEFEFEFEFEFEFEFEFEFEFEFEF" "EFEFEFEFEFEFEFEF" "5ACDEF9847F8085B")
(ecb-mode-test "F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0F0" "F0F0F0F0F0F0F0F0" "205BDE6C6CE800E2")
(ecb-mode-test "F1F1F1F1F1F1F1F1F1F1F1F1F1F1F1F1" "F1F1F1F1F1F1F1F1" "012309B3210CEFEE")
(ecb-mode-test "F2F2F2F2F2F2F2F2F2F2F2F2F2F2F2F2" "F2F2F2F2F2F2F2F2" "83E92926264F123F")
(ecb-mode-test "F3F3F3F3F3F3F3F3F3F3F3F3F3F3F3F3" "F3F3F3F3F3F3F3F3" "5BA80701E5009A1C")
(ecb-mode-test "F4F4F4F4F4F4F4F4F4F4F4F4F4F4F4F4" "F4F4F4F4F4F4F4F4" "75B12595A8F1CF84")
(ecb-mode-test "F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5F5" "F5F5F5F5F5F5F5F5" "8BE8D04B7506BFBA")
(ecb-mode-test "F6F6F6F6F6F6F6F6F6F6F6F6F6F6F6F6" "F6F6F6F6F6F6F6F6" "06AFC3F429493838")
(ecb-mode-test "F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7" "F7F7F7F7F7F7F7F7" "2B53DC24D5499DDB")
(ecb-mode-test "F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8F8" "F8F8F8F8F8F8F8F8" "D1D5A311D568E59A")
(ecb-mode-test "F9F9F9F9F9F9F9F9F9F9F9F9F9F9F9F9" "F9F9F9F9F9F9F9F9" "9D5D2537033FEBB8")
(ecb-mode-test "FAFAFAFAFAFAFAFAFAFAFAFAFAFAFAFA" "FAFAFAFAFAFAFAFA" "20AB2D42A0C94052")
(ecb-mode-test "FBFBFBFBFBFBFBFBFBFBFBFBFBFBFBFB" "FBFBFBFBFBFBFBFB" "8880794BE00876FA")
(ecb-mode-test "FCFCFCFCFCFCFCFCFCFCFCFCFCFCFCFC" "FCFCFCFCFCFCFCFC" "A826B58B13B7B9C1")
(ecb-mode-test "FDFDFDFDFDFDFDFDFDFDFDFDFDFDFDFD" "FDFDFDFDFDFDFDFD" "65B7E9FA03B72838")
(ecb-mode-test "FEFEFEFEFEFEFEFEFEFEFEFEFEFEFEFE" "FEFEFEFEFEFEFEFE" "1405A7801255ECEA")
(ecb-mode-test "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" "FFFFFFFFFFFFFFFF" "1D0C41EB2B24A69B")
(ecb-mode-test "000102030405060708090A0B0C0D0E0F" "0011223344556677" "DF7F1DD20217842A")
(ecb-mode-test "2BD6459F82C5B300952C49104881FF48" "EA024714AD5C4D84" "7AEE54052CB37F9D")