// --------------------------------------------------------------------
// The visitor base class.
// --------------------------------------------------------------------
/*

    This file is part of the extensible drawing editor Ipe.
    Copyright (C) 1993-2007  Otfried Cheong

    Ipe is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exception, you have permission to link Ipe with the
    CGAL library and distribute executables, as long as you follow the
    requirements of the Gnu General Public License in regard to all of
    the software in the executable aside from CGAL.

    Ipe is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details.

    You should have received a copy of the GNU General Public License
    along with Ipe; if not, you can find it at
    "http://www.gnu.org/copyleft/gpl.html", or write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include "ipevisitor.h"
#include "ipegroup.h"
#include "ipepath.h"
#include "ipemark.h"
#include "ipetext.h"
#include "iperef.h"
#include "ipeimage.h"

// --------------------------------------------------------------------

/*! \class IpeVisitor
  \ingroup high
  \brief Base class for visitors to IpeObject.

  Many operations on Ipe objects are implemented as visitors, all
  derived from IpeVisitor.

  The default implementation of each VisitXXX member calls
  VisitObject.  The default implementation of VisitObject doesn't do
  anything.
*/

//! Pure virtual destructor.
IpeVisitor::~IpeVisitor()
{
  // void
}

//! Called on an IpeGroup object.
void IpeVisitor::VisitGroup(const IpeGroup *obj)
{
  VisitObject(obj);
}

//! Called on an IpePath object.
void IpeVisitor::VisitPath(const IpePath *obj)
{
  VisitObject(obj);
}

//! Called on an IpeMark object.
void IpeVisitor::VisitMark(const IpeMark * obj)
{
  VisitObject(obj);
}

//! Called on an IpeImage object.
void IpeVisitor::VisitImage(const IpeImage * obj)
{
  VisitObject(obj);
}

//! Called on an IpeText object.
void IpeVisitor::VisitText(const IpeText * obj)
{
  VisitObject(obj);
}

//! Called on an IpeReference object.
void IpeVisitor::VisitReference(const IpeReference * obj)
{
  VisitObject(obj);
}

//! Called on an IpeObject.
/*! This is called if the more specific function is not implemented by
  a derived class. */
void IpeVisitor::VisitObject(const IpeObject *)
{
  // nothing
}

// --------------------------------------------------------------------
