/*
 * Copyright (C) 2011 Daniel Scharrer
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the author(s) be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software. If you use this software
 *    in a product, an acknowledgment in the product documentation would be
 *    appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 */

#include "setup/type.hpp"

#include "setup/version.hpp"
#include "util/load.hpp"
#include "util/storedenum.hpp"

namespace setup {

namespace {

FLAGS(type_flags,
	CustomSetupType
);

STORED_FLAGS_MAP(stored_type_flags,
	CustomSetupType,
);

STORED_ENUM_MAP(stored_setup_type, type_entry::User,
	type_entry::User,
	type_entry::DefaultFull,
	type_entry::DefaultCompact,
	type_entry::DefaultCustom,
);

} // anonymous namespace

} // namespace setup

NAMED_FLAGS(setup::type_flags)

namespace setup {

void type_entry::load(std::istream & is, const version & version) {
	
	is >> encoded_string(name, version.codepage());
	is >> encoded_string(description, version.codepage());
	if(version >= INNO_VERSION(4, 0, 1)) {
		is >> encoded_string(languages, version.codepage());
	} else {
		languages.clear();
	}
	if(version >= INNO_VERSION_EXT(3, 0, 6, 1)) {
		is >> encoded_string(check, version.codepage());
	} else {
		check.clear();
	}
	
	winver.load(is, version);
	
	type_flags options = stored_flags<stored_type_flags>(is).get();
	custom_type = (options & CustomSetupType);
	
	if(version >= INNO_VERSION(4, 0, 3)) {
		type = stored_enum<stored_setup_type>(is).get();
	} else {
		type = User;
	}
	
	size = (version >= INNO_VERSION(4, 0, 0)) ? load_number<uint64_t>(is) : load_number<uint32_t>(is);
}

} // namespace setup

NAMES(setup::type_flags, "Setyp Type Option",
	"is custom",
)

NAMES(setup::type_entry::setup_type, "Setyp Type",
	"user",
	"default full",
	"default compact",
	"default custom",
)
