;;; initz-make.el --- Generic make procedures.

;; Copyright (C) 2001-2002 OHASHI Akira <bg66@koka-in.org>

;; Author: OHASHI Akira <bg66@koka-in.org>
;; Keywords: startup, init

;; This file is part of Initz.

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.


;;; Commentary:
;;

;;; Code:

(require 'cl)

(defun install-just-print-p ()
  (let ((flag (getenv "MAKEFLAGS"))
	case-fold-search)
    (princ (format "%s\n" flag))
    (if flag
	(string-match "^\\(\\(--[^ ]+ \\)+-\\|[^ =-]\\)*n" flag))))

(defun config-initz ()
  (let (prefix exec-prefix lisp-dir version-specific-lisp-dir)
    (and (setq prefix (car command-line-args-left))
         (or (string-equal "NONE" prefix)
             (setq PREFIX prefix)))
    (setq command-line-args-left (cdr command-line-args-left))
    (and (setq lisp-dir (car command-line-args-left))
         (or (string-equal "NONE" lisp-dir)
             (setq LISPDIR lisp-dir)))
    (setq command-line-args-left (cdr command-line-args-left))
    (and (setq version-specific-lisp-dir (car command-line-args-left))
         (or (string-equal "NONE" version-specific-lisp-dir)
             (progn
               (defvar VERSION_SPECIFIC_LISPDIR version-specific-lisp-dir)
               (princ (format "VERSION_SPECIFIC_LISPDIR=%s\n"
                              VERSION_SPECIFIC_LISPDIR)))))
    (setq command-line-args-left (cdr command-line-args-left))
    (setq load-path (cons (expand-file-name ".") load-path))
    (load "initz-config")
    (or (boundp 'initz-modules-to-compile)
	(load "initz-modules"))
    (princ (format "PREFIX=%s\tLISPDIR=%s\n" PREFIX LISPDIR))))

(defun compile-initz ()
  ;;(setq byte-compile-dynamic t)
  (config-initz)
  (compile-elisp-modules initz-modules-to-compile "."))

(defun install-initz ()
  (compile-initz)
  (let ((just-print (install-just-print-p))
	(dir (expand-file-name "initz" LISPDIR)))
    (princ (format "%s\n" emacs-version))
    (install-elisp-modules initz-modules "." dir just-print)))

(provide 'initz-make)

;;; initz-make.el ends here
