/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2011 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef IGGWIDGETKEYSLIDER_H
#define IGGWIDGETKEYSLIDER_H

//
//  Non-abstract classes defined in this file
//
//  iggWidgetKeyIntSlider;
//  iggWidgetKeyLargeIntSlider;
//  iggWidgetKeyFloatSlider;
//  iggWidgetKeyDoubleSlider;
//  iggWidgetKeyRelativeFloatSlider;
//  iggWidgetKeyPositionSlider;
//  iggWidgetKeySizeSlider;
//  iggWidgetKeyVariableLimitsSlider;
//
#include "iggwidgetkeyhandler.h"


template<class T> class iPointerArray;

class iggDataTypeProvider;

class ibgWidgetEntrySubject;

//
//  A helper class with registry functionality
//
class iggWidgetSlider : public iggWidget
{

public:

	iggWidgetSlider(int numdig, const iString &label, ibgWidgetEntrySubject *subject, iggWidget *owner);
	virtual ~iggWidgetSlider();

	static void SetAllEditable(bool s);
	static bool IsEditableByDefault(){ return mIsEditableByDefault; }

protected:

	virtual void UpdateWidgetBody();

	ibgWidgetEntrySubject *mSubject;
	static bool mIsEditableByDefault;
	//
	//  Registry functionality
	//
	static iPointerArray<iggWidgetSlider> &List();
};

//
//  Main termplate class
//
template<class T>
class iggWidgetKeySlider : public iggWidgetKeyHandler<T>
{

public:

	iggWidgetKeySlider(int numdig, const iString &label, const iObjectKey &key, int rm, iggFrame *parent, int index, const iObjectKey *indkey);

	virtual void SetRenderMode(int m);

	void SetRange(int smin, int smax, int pagestep = 0);
	void SetStretch(int label, int slider, int number = 0);
	void SetNumberOfTicks(int n);

protected:

	virtual void QueryValue(T &val) const;
	virtual void UpdateValue(T val);

	virtual void ConvertToSliderInt(T val, int &sint) const = 0;
	virtual void ConvertFromSliderInt(int sint, T &val) const = 0;
	virtual T GetDisplayedValue(T val) const;  //  both of these functions have to be inherited
	virtual T GetInternalValue(T dv) const;    //  they provide direct and reverse transforms

	virtual void OnInt1Body(int);
	virtual void OnVoid1Body();
	virtual void OnString1Body(const iString &);

	ibgWidgetEntrySubject *mSubject;
	bool mHighResolutionValue;
};


template<class T>
class iggWidgetKeyGenericNumberSlider : public iggWidgetKeySlider<T>
{

public:

	iggWidgetKeyGenericNumberSlider(T min, T max, int res, int stretch, T smallnum, int numdig, const iString &label, const iObjectKey &key, int rm, iggFrame *parent, int index = -1, const iObjectKey *indkey = 0);

protected:

	virtual void ConvertToSliderInt(T val, int &sint) const;
	virtual void ConvertFromSliderInt(int sint, T &val) const;
	void AdjustLowerLimitBody(bool shrink);

	const T mTiny;
	T mMin, mMax;
	int mResolution;
	int mStretch;
};


class iggWidgetKeyIntSlider : public iggWidgetKeySlider<int>
{

public:

	iggWidgetKeyIntSlider(int min, int max, int numdig, const iString &label, const iObjectKey &key, int rm, iggFrame *parent, int index = -1, const iObjectKey *indkey = 0);

protected:

	virtual void ConvertToSliderInt(int val, int &sint) const;
	virtual void ConvertFromSliderInt(int sint, int &val) const;
};


class iggWidgetKeyLargeIntSlider : public iggWidgetKeyIntSlider
{

public:

	iggWidgetKeyLargeIntSlider(int min, int max, int numdig, const iString &label, const iObjectKey &key, int rm, iggFrame *parent, int index = -1, const iObjectKey *indkey = 0);

protected:

	virtual void ConvertToSliderInt(int val, int &sint) const;
	virtual void ConvertFromSliderInt(int sint, int &val) const;
};


class iggWidgetKeyFloatSlider : public iggWidgetKeyGenericNumberSlider<float>
{

public:

	iggWidgetKeyFloatSlider(float min, float max, int res, int stretch, int numdig, const iString &label, const iObjectKey &key, int rm, iggFrame *parent, int index = -1, const iObjectKey *indkey = 0);

	void AdjustLowerLimit(bool shrink);
};


class iggWidgetKeyDoubleSlider : public iggWidgetKeyGenericNumberSlider<double>
{

public:

	iggWidgetKeyDoubleSlider(double min, double max, int res, int stretch, int numdig, const iString &label, const iObjectKey &key, int rm, iggFrame *parent, int index = -1, const iObjectKey *indkey = 0);
};


class iggWidgetKeyRelativeFloatSlider : public iggWidgetKeyGenericNumberSlider<float>
{

public:

	iggWidgetKeyRelativeFloatSlider(const iObjectKey &relKey, float min, float max, int res, int stretch, int numdig, const iString &label, const iObjectKey &key, int rm, iggFrame *parent, int index = -1, const iObjectKey *indkey = 0);
	virtual ~iggWidgetKeyRelativeFloatSlider();

protected:

	virtual void ConvertToSliderInt(float val, int &sint) const;
	virtual void ConvertFromSliderInt(int sint, float &val) const;

	const iObjectKey &mRelativeKey;
	float *mRelativeValue;
};


class iggWidgetKeyPositionSlider : public iggWidgetKeySlider<double>
{

public:

	iggWidgetKeyPositionSlider(int numdig, const iString &label, const iObjectKey &key, int rm, iggFrame *parent, int index = -1, const iObjectKey *indkey = 0);
	virtual ~iggWidgetKeyPositionSlider();

protected:

	virtual void ConvertToSliderInt(double val, int &sint) const;
	virtual void ConvertFromSliderInt(int sint, double &val) const;
	virtual double GetDisplayedValue(double val) const;
	virtual double GetInternalValue(double dv) const;

	virtual void OnBool1Body(bool);

	int mResolution;
	//
	//  Registry functionality
	//
	static iPointerArray<iggWidgetKeyPositionSlider> &List();
};


class iggWidgetKeySizeSlider : public iggWidgetKeyGenericNumberSlider<double>
{

public:

	iggWidgetKeySizeSlider(double min, int numdig, const iString &label, const iObjectKey &key, int rm, iggFrame *parent, int index = -1, const iObjectKey *indkey = 0);
	virtual ~iggWidgetKeySizeSlider();

	void AdjustLowerLimit(bool shrink);

protected:

	virtual double GetDisplayedValue(double val) const;
	virtual double GetInternalValue(double dv) const;
};


class iggWidgetKeyVariableLimitsSlider : public iggWidgetKeyFloatSlider
{

public:

	iggWidgetKeyVariableLimitsSlider(const iggDataTypeProvider *provider, int numdig, const iString &label, const iObjectKey &key, const iObjectKey *varkey, const iObjectKey *stretchkey, int rm, iggFrame *parent, int index = -1, const iObjectKey *indkey = 0);
//	iggWidgetKeyVariableLimitsSlider(const iggDataTypeProvider *provider, int numdig, const iString &label, const iObjectKey &key, const iObjectKey *varkey, const iObjectKey &varmaxkey, const iObjectKey &minkey, const iObjectKey &maxkey, const iObjectKey &stepkey, const iObjectKey *logkey, int rm, iggFrame *parent, int index = -1, const iObjectKey *indkey = 0);
	virtual ~iggWidgetKeyVariableLimitsSlider();

	void SetStep(float step);

protected:

	int ComputeResolution();

	virtual void UpdateWidgetBody();

	float mStep;
	const iObjectKey *mVarKey, *mStretchKey;
};

#endif  // IGGWIDGETKEYSLIDER_H

